/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.ThreadUpdatePanel;
import de.quippy.javamod.system.Log;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.border.Border;

public abstract class MeterPanelBase
extends ThreadUpdatePanel {
    private static final long serialVersionUID = -7284099301353768209L;
    private volatile int myTop;
    private volatile int myLeft;
    private volatile int myWidth;
    private volatile int myHeight;
    private Image imageBuffer;

    public MeterPanelBase(int n) {
        super(n);
        this.prepareComponentListener();
    }

    private void prepareComponentListener() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MeterPanelBase.this.internalComponentWasResized();
            }
        });
    }

    protected synchronized void internalComponentWasResized() {
        this.imageBuffer = null;
        Border border = this.getBorder();
        Insets insets = border == null ? new Insets(1, 1, 1, 1) : border.getBorderInsets(this);
        this.myTop = insets.top;
        this.myLeft = insets.left;
        this.myWidth = this.getWidth() - insets.left - insets.right;
        this.myHeight = this.getHeight() - insets.top - insets.bottom;
        if (this.myWidth > 0 && this.myHeight > 0) {
            this.componentWasResized(0, 0, this.myWidth, this.myHeight);
        }
    }

    protected Image getDoubleBuffer() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.imageBuffer == null && this.myWidth > 0 && this.myHeight > 0 && (graphicsConfiguration = this.getGraphicsConfiguration()) != null) {
            this.imageBuffer = graphicsConfiguration.createCompatibleImage(this.myWidth, this.myHeight);
        }
        return this.imageBuffer;
    }

    @Override
    protected synchronized void doThreadUpdate() {
        Image image = this.getDoubleBuffer();
        if (image != null) {
            try {
                this.drawMeter(image.getGraphics(), 0, 0, this.myWidth, this.myHeight);
            }
            catch (Exception exception) {
                Log.error("drawMeter:", exception);
            }
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Image image = this.getDoubleBuffer();
        if (image != null) {
            graphics.drawImage(image, this.myLeft, this.myTop, null);
        }
    }

    protected abstract void drawMeter(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract void componentWasResized(int var1, int var2, int var3, int var4);
}

