/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist.cuesheet;

import de.quippy.javamod.main.playlist.cuesheet.CueFile;
import de.quippy.javamod.main.playlist.cuesheet.CueIndex;
import de.quippy.javamod.main.playlist.cuesheet.CueTrack;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Pattern;

public class CueSheet {
    private static final String QUOTATION_MARK = "\"";
    private URL cueSheedFileName;
    private String title;
    private String performer;
    private String songwriter;
    private ArrayList<CueFile> cueFiles = new ArrayList();

    public CueSheet() {
    }

    public CueSheet(URL uRL) {
        this();
        this.cueSheedFileName = uRL;
        this.readCueSheet(uRL);
    }

    public CueSheet(File file) {
        this(Helpers.createURLfromFile(file));
    }

    public CueSheet(String string) {
        this(Helpers.createURLfromString(string));
    }

    public URL getCueSheedFileName() {
        return this.cueSheedFileName;
    }

    public void setCueSheedFileName(URL uRL) {
        this.cueSheedFileName = uRL;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String string) {
        this.performer = string;
    }

    public String getSongwriter() {
        return this.songwriter;
    }

    public void setSongwriter(String string) {
        this.songwriter = string;
    }

    public ArrayList<CueFile> getCueFiles() {
        return this.cueFiles;
    }

    public void addFile(CueFile cueFile) {
        this.cueFiles.add(cueFile);
    }

    private void writeCommentBlock(Writer writer, String string, String string2, String string3, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("  ");
            ++n2;
        }
        if (string2 != null && string2.length() != 0) {
            writer.write(String.valueOf(stringBuilder.toString()) + "PERFORMER \"" + string2 + "\"\r\n");
        }
        if (string != null && string.length() != 0) {
            writer.write(String.valueOf(stringBuilder.toString()) + "TITLE \"" + string + "\"\r\n");
        }
        if (string3 != null && string3.length() != 0) {
            writer.write(String.valueOf(stringBuilder.toString()) + "SONGWRITER \"" + string3 + "\"\r\n");
        }
    }

    public void writeCueSheet(File file) {
        block16: {
            String string = file.getAbsolutePath();
            string = string.substring(0, string.lastIndexOf(File.separatorChar) + 1).toLowerCase();
            int n = string.length();
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                    bufferedWriter.write("REM COMMENT \"Java Mod Player V2.0\"\r\n");
                    this.writeCommentBlock(bufferedWriter, this.getTitle(), this.getPerformer(), this.getSongwriter(), 0);
                    ArrayList<CueFile> arrayList = this.getCueFiles();
                    int n2 = arrayList.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        CueFile cueFile = arrayList.get(n3);
                        String string2 = Helpers.createLocalFileStringFromURL(cueFile.getFile(), true);
                        if (string2.toLowerCase().startsWith(string)) {
                            string2 = string2.substring(n);
                        }
                        bufferedWriter.write("FILE \"" + string2 + "\" " + cueFile.getType() + "\r\n");
                        ArrayList<CueTrack> arrayList2 = cueFile.getTracks();
                        int n4 = arrayList2.size();
                        int n5 = 0;
                        while (n5 < n4) {
                            CueTrack cueTrack = arrayList2.get(n5);
                            int n6 = cueTrack.getTrackNo();
                            String string3 = n6 < 10 ? "0" + n6 : String.valueOf(n6);
                            bufferedWriter.write("  TRACK " + string3 + " " + cueTrack.getFormat() + "\r\n");
                            this.writeCommentBlock(bufferedWriter, cueTrack.getTitle(), cueTrack.getPerformer(), cueTrack.getSongwriter(), 2);
                            ArrayList<CueIndex> arrayList3 = cueTrack.getIndexes();
                            int n7 = arrayList3.size();
                            int n8 = 0;
                            while (n8 < n7) {
                                CueIndex cueIndex = arrayList3.get(n8);
                                int n9 = cueIndex.getIndexNo();
                                String string4 = n9 < 10 ? "0" + n9 : String.valueOf(n9);
                                long l = cueIndex.getMillisecondIndex();
                                Integer n10 = (int)(l / 60000L);
                                Integer n11 = (int)(l / 1000L % 60L);
                                Integer n12 = (int)(((l -= (n10.longValue() * 60L + n11.longValue()) * 1000L) * 75L + 500L) / 1000L);
                                String string5 = String.format("%02d:%02d:%02d", n10, n11, n12);
                                bufferedWriter.write("    INDEX " + string4 + " " + string5 + "\r\n");
                                ++n8;
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                catch (Throwable throwable) {
                    Log.error("[CueSheet]: Writing to \"" + file.getAbsolutePath() + "\" failed", throwable);
                    if (bufferedWriter == null) break block16;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
        }
    }

    public static CueSheet createCueSheet(String string) {
        return new CueSheet(string);
    }

    public static CueSheet createCueSheet(File file) {
        return new CueSheet(file);
    }

    public static CueSheet createCueSheet(URL uRL) {
        return new CueSheet(uRL);
    }

    private static String getStringFromQuotation(Scanner scanner) {
        String string = scanner.next();
        if (string.startsWith(QUOTATION_MARK)) {
            string = string.endsWith(QUOTATION_MARK) ? string.substring(1, string.length() - 1) : String.valueOf(string.substring(1)) + scanner.useDelimiter(QUOTATION_MARK).next();
        }
        return string;
    }

    private void readCueSheet(URL uRL) {
        block23: {
            BufferedReader bufferedReader = null;
            CueFile cueFile = null;
            CueTrack cueTrack = null;
            try {
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        Scanner scanner;
                        if (string.length() == 0 || !(scanner = new Scanner(string)).hasNext()) continue;
                        String string2 = scanner.next();
                        if (string2.equalsIgnoreCase("FILE")) {
                            String string3 = CueSheet.getStringFromQuotation(scanner);
                            cueFile = new CueFile();
                            this.addFile(cueFile);
                            cueFile.setFile(Helpers.createAbsolutePathForFile(uRL, string3));
                            cueFile.setType(scanner.next());
                            cueTrack = null;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("TRACK")) {
                            if (cueFile == null) {
                                throw new RuntimeException("Illegal cue sheet: track without file");
                            }
                            cueTrack = new CueTrack();
                            cueFile.addTrack(cueTrack);
                            cueTrack.setTrackNo(scanner.nextInt());
                            cueTrack.setFormat(scanner.nextLine().trim().toUpperCase());
                            continue;
                        }
                        if (string2.equalsIgnoreCase("TITLE")) {
                            String string4 = CueSheet.getStringFromQuotation(scanner);
                            if (cueTrack != null && cueTrack.getTitle() == null) {
                                cueTrack.setTitle(string4);
                                continue;
                            }
                            this.setTitle(string4);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("PERFORMER")) {
                            String string5 = CueSheet.getStringFromQuotation(scanner);
                            if (cueTrack != null && cueTrack.getPerformer() == null) {
                                cueTrack.setPerformer(string5);
                                continue;
                            }
                            this.setPerformer(string5);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("SONGWRITER")) {
                            String string6 = CueSheet.getStringFromQuotation(scanner);
                            if (cueTrack != null && cueTrack.getSongwriter() == null) {
                                cueTrack.setSongwriter(string6);
                                continue;
                            }
                            this.setSongwriter(string6);
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("INDEX")) continue;
                        if (cueTrack == null) {
                            throw new RuntimeException("Illegal cue sheet: index without track");
                        }
                        int n = scanner.nextInt();
                        Scanner scanner2 = scanner.useDelimiter(Pattern.compile(":| "));
                        int n2 = scanner2.nextInt();
                        int n3 = scanner2.nextInt();
                        int n4 = scanner2.nextInt();
                        CueIndex cueIndex = new CueIndex();
                        cueIndex.setIndexNo(n);
                        cueIndex.setMillisecondIndex(((long)n2 * 60L + (long)n3) * 1000L + (long)n4 * 1000L / 75L);
                        cueTrack.addIndex(cueIndex);
                    }
                }
                catch (Throwable throwable) {
                    Log.error("[CueSheet]: Loading failed", throwable);
                    if (bufferedReader == null) break block23;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
        }
    }
}

