/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APETagFooter {
    public String m_cID = "APETAGEX";
    public int m_nVersion;
    public int m_nSize;
    public int m_nFields;
    public int m_nFlags;
    public static final int APE_TAG_FOOTER_BYTES = 32;
    public static final int CURRENT_APE_TAG_VERSION = 2000;

    APETagFooter() {
        this(0, 0);
    }

    APETagFooter(int n) {
        this(n, 0);
    }

    APETagFooter(int n, int n2) {
        this.m_nFields = n;
        this.m_nFlags = 0x40000000;
        this.m_nSize = n2 + 32;
        this.m_nVersion = 2000;
    }

    public int GetTotalTagBytes() {
        return this.m_nSize + (this.GetHasHeader() ? 32 : 0);
    }

    public int GetFieldBytes() {
        return this.m_nSize - 32;
    }

    public int GetFieldsOffset() {
        return this.GetHasHeader() ? 32 : 0;
    }

    public int GetNumberFields() {
        return this.m_nFields;
    }

    public boolean GetHasHeader() {
        return (this.m_nFlags & Integer.MIN_VALUE) > 0;
    }

    public boolean GetIsHeader() {
        return (this.m_nFlags & 0x20000000) > 0;
    }

    public int GetVersion() {
        return this.m_nVersion;
    }

    public boolean GetIsValid(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.m_cID.equals("APETAGEX") && this.m_nVersion <= 2000 && this.m_nFields <= 65536 && this.GetFieldBytes() <= 0x1000000;
        if (bl2 && !bl && this.GetIsHeader()) {
            bl2 = false;
        }
        return bl2;
    }

    public static APETagFooter read(File file) throws IOException {
        file.seek(file.length() - 32L);
        APETagFooter aPETagFooter = new APETagFooter();
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(file, 32);
            aPETagFooter.m_cID = byteArrayReader.readString(8, "US-ASCII");
            aPETagFooter.m_nVersion = byteArrayReader.readInt();
            aPETagFooter.m_nSize = byteArrayReader.readInt();
            aPETagFooter.m_nFields = byteArrayReader.readInt();
            aPETagFooter.m_nFlags = byteArrayReader.readInt();
            return aPETagFooter;
        }
        catch (EOFException eOFException) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter byteArrayWriter) {
        byteArrayWriter.writeString(this.m_cID, 8, "US-ASCII");
        byteArrayWriter.writeInt(this.m_nVersion);
        byteArrayWriter.writeInt(this.m_nSize);
        byteArrayWriter.writeInt(this.m_nFields);
        byteArrayWriter.writeInt(this.m_nFlags);
        byteArrayWriter.writeInt(0);
        byteArrayWriter.writeInt(0);
    }
}

