/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.SID;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReSID
extends SIDEmu {
    private static final Logger RESID = Logger.getLogger(ReSID.class.getName());
    private static final String VERSION = "0.0.2";
    private IEventContext m_context = null;
    private Event.event_phase_t m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
    private SID m_sid = new SID();
    private long m_accessClk;
    private long m_gain = 100L;
    private static String m_credit = "ReSID V0.0.2 Engine:\t(C) 1999-2002 Simon White <sidplay2@yahoo.com>MOS6581 (SID) Emulation (ReSID V0.15):\t(C) 1999-2002 Dag Lem <resid@nimrod.no>";
    private final String m_error;
    private boolean m_status = true;
    private boolean m_locked = false;
    private byte m_optimisation = 0;

    public ReSID(SIDBuilder sIDBuilder) {
        super(sIDBuilder);
        if (this.m_sid == null) {
            this.m_error = "RESID ERROR: Unable to create sid object";
            this.m_status = false;
            return;
        }
        this.m_error = "N/A";
        this.reset((short)0);
    }

    @Override
    public final String credits() {
        return m_credit;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(short s) {
        this.m_accessClk = 0L;
        this.m_sid.reset();
        this.m_sid.write(24, s);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public short read(short var1_1) {
        block3: {
            var2_2 = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += var2_2;
            if (this.m_optimisation == 0) ** GOTO lbl8
            if (var2_2 == 0L) break block3;
            this.m_sid.clock((int)var2_2);
            break block3;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl8:
                // 2 sources

                ** while (var2_2-- != 0L)
            }
        }
        return (short)this.m_sid.read(var1_1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(short var1_1, short var2_2) {
        block5: {
            if (ReSID.RESID.isLoggable(Level.FINE)) {
                ReSID.RESID.fine(String.format("write 0x%02x=0x%02x", new Object[]{var1_1, var2_2}));
                ReSID.RESID.fine("\n");
            }
            var3_3 = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += var3_3;
            if (this.m_optimisation == 0) ** GOTO lbl11
            if (var3_3 == 0L) break block5;
            this.m_sid.clock((int)var3_3);
            break block5;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl11:
                // 2 sources

                ** while (var3_3-- != 0L)
            }
        }
        this.m_sid.write(var1_1, var2_2);
    }

    @Override
    public final String error() {
        return this.m_error;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long output(short var1_1) {
        block3: {
            var2_2 = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += var2_2;
            if (this.m_optimisation == 0) ** GOTO lbl8
            if (var2_2 == 0L) break block3;
            this.m_sid.clock((int)var2_2);
            break block3;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl8:
                // 2 sources

                ** while (var2_2-- != 0L)
            }
        }
        return (long)this.m_sid.output(var1_1) * this.m_gain / 100L;
    }

    public void filter(boolean bl) {
        this.m_sid.enable_filter(bl);
    }

    @Override
    public void voice(short s, short s2, boolean bl) {
        this.m_sid.mute(s, bl);
    }

    @Override
    public void gain(short s) {
        this.m_gain = s;
        this.m_gain += 100L;
        if (this.m_gain > 200L) {
            this.m_gain = 200L;
        }
    }

    @Override
    public void optimisation(byte by) {
        this.m_optimisation = by;
    }

    public boolean bool() {
        return this.m_status;
    }

    public void sampling(long l) {
        this.m_sid.set_sampling_parameters(1000000.0, ISIDDefs.sampling_method.SAMPLE_FAST, l, -1.0, 0.79);
    }

    public boolean filter(sid_filter_t sid_filter_t2) {
        Object object;
        int[][] nArray;
        int[][] nArray2 = nArray = new int[2050][2];
        int n = 0;
        if (sid_filter_t2 == null) {
            object = new SID.FCPoints();
            this.m_sid.fc_default((SID.FCPoints)object);
            nArray = ((SID.FCPoints)object).points;
            n = ((SID.FCPoints)object).count;
        } else {
            n = sid_filter_t2.points;
            if (n < 2 || n > 2048) {
                return false;
            }
            int[] nArray3 = new int[2];
            nArray3[0] = -1;
            Object object2 = object = (Object)nArray3;
            int n2 = 0;
            int n3 = 0;
            while (n-- > 0) {
                if (object2[0] >= sid_filter_t2.cutoff[n2][0]) {
                    return false;
                }
                nArray[++n3][0] = sid_filter_t2.cutoff[n2][0];
                nArray[n3][1] = sid_filter_t2.cutoff[n2][1];
                object2 = sid_filter_t2.cutoff[n2++];
            }
            nArray[n3 + 1][0] = nArray[n3][0];
            nArray[n3 + 1][1] = nArray[n3][1];
            nArray[0][0] = nArray[1][0];
            nArray[0][1] = nArray[1][1];
            n = sid_filter_t2.points + 2;
        }
        this.m_sid.filter.interpolate(nArray2, 0, --n, this.m_sid.fc_plotter(), 1.0);
        if (sid_filter_t2 != null && sid_filter_t2.Lthreshold != 0) {
            this.m_sid.set_distortion_properties(sid_filter_t2.Lthreshold, sid_filter_t2.Lsteepness, sid_filter_t2.Llp, sid_filter_t2.Lbp, sid_filter_t2.Lhp, sid_filter_t2.Hthreshold, sid_filter_t2.Hsteepness, sid_filter_t2.Hlp, sid_filter_t2.Hbp, sid_filter_t2.Hhp);
        }
        return true;
    }

    public void model(ISID2Types.sid2_model_t sid2_model_t2) {
        if (sid2_model_t2 == ISID2Types.sid2_model_t.SID2_MOS8580) {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        } else {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        }
    }

    public boolean lock(C64Env c64Env) {
        if (c64Env == null) {
            if (!this.m_locked) {
                return false;
            }
            this.m_locked = false;
            this.m_context = null;
        } else {
            if (this.m_locked) {
                return false;
            }
            this.m_locked = true;
            this.m_context = c64Env.context();
        }
        return true;
    }
}

