/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import net.sourceforge.dvb.projectx.xinput.ftp.StringCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpServer {
    private FtpVO ftpVO;
    private StringCommandListener scl;
    private FTPClient ftpClient;
    private boolean isOpen;
    private String testMsg;

    private FtpServer() {
        throw new UnsupportedOperationException();
    }

    public FtpServer(FtpVO ftpVO) {
        if (ftpVO == null) {
            throw new IllegalArgumentException("aFtpVO mustn't be null!");
        }
        this.ftpVO = ftpVO;
        this.scl = new StringCommandListener();
        this.ftpClient = new FTPClient();
        this.ftpClient.addProtocolCommandListener(this.scl);
        this.isOpen = false;
    }

    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("Is already closed, must be opened before!");
        }
        try {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
        catch (Exception exception) {}
        this.isOpen = false;
    }

    public String getLog() {
        return this.scl.getMessages();
    }

    public String getTestMsg() {
        return this.testMsg;
    }

    public FtpVO[] listDirectories() {
        int n;
        ArrayList<FtpVO> arrayList = new ArrayList<FtpVO>();
        FTPFile[] fTPFileArray = null;
        try {
            fTPFileArray = this.ftpClient.listFiles();
            int n2 = 0;
            n = fTPFileArray.length;
            while (n2 < n) {
                if (fTPFileArray[n2].isDirectory() && !fTPFileArray[n2].getName().startsWith(".")) {
                    FtpVO ftpVO = (FtpVO)this.ftpVO.clone();
                    ftpVO.setDirectory(String.valueOf(ftpVO.getDirectory()) + "/" + fTPFileArray[n2].getName());
                    ftpVO.setFtpFile(fTPFileArray[n2]);
                    arrayList.add(ftpVO);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("!> error create ftp directory list: " + exception);
        }
        FtpVO[] ftpVOArray = new FtpVO[arrayList.size()];
        n = 0;
        int n3 = ftpVOArray.length;
        while (n < n3) {
            ftpVOArray[n] = (FtpVO)arrayList.get(n);
            ++n;
        }
        return ftpVOArray;
    }

    public XInputFile[] listFiles() {
        int n;
        ArrayList<XInputFile> arrayList = new ArrayList<XInputFile>();
        FTPFile[] fTPFileArray = null;
        try {
            fTPFileArray = this.ftpClient.listFiles();
            int n2 = 0;
            n = fTPFileArray.length;
            while (n2 < n) {
                if (fTPFileArray[n2].isFile()) {
                    FtpVO ftpVO = (FtpVO)this.ftpVO.clone();
                    ftpVO.setFtpFile(fTPFileArray[n2]);
                    arrayList.add(new XInputFile(ftpVO));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("!> error create ftp filelist: " + exception);
        }
        XInputFile[] xInputFileArray = new XInputFile[arrayList.size()];
        n = 0;
        int n3 = xInputFileArray.length;
        while (n < n3) {
            xInputFileArray[n] = (XInputFile)arrayList.get(n);
            ++n;
        }
        return xInputFileArray;
    }

    public boolean open() {
        boolean bl = false;
        if (this.isOpen) {
            throw new IllegalStateException("Is already open, must be closed before!");
        }
        try {
            this.ftpClient.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
            int n = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(n)) {
                this.ftpClient.disconnect();
                throw new IOException("Can't connect!");
            }
            if (!this.ftpClient.login(this.ftpVO.getUser(), this.ftpVO.getPassword())) {
                this.ftpClient.logout();
                throw new IOException("Can't login!");
            }
            if (!this.ftpClient.changeWorkingDirectory(this.ftpVO.getDirectory())) {
                this.ftpClient.logout();
                throw new IOException("Can't change directory!");
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            bl = true;
        }
        catch (Exception exception) {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
            bl = false;
        }
        this.isOpen = bl;
        return bl;
    }

    public InputStream retrieveFileStream(String string) throws IOException {
        return this.ftpClient.retrieveFileStream(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test() {
        boolean bl;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    boolean bl4;
                    block13: {
                        boolean bl5 = false;
                        bl = false;
                        this.testMsg = null;
                        try {
                            try {
                                this.ftpClient.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
                                int n = this.ftpClient.getReplyCode();
                                if (!FTPReply.isPositiveCompletion(n)) {
                                    this.ftpClient.disconnect();
                                    this.testMsg = Resource.getString("ftpchooser.msg.noconnect");
                                    bl4 = false;
                                    Object var6_8 = null;
                                    if (!this.ftpClient.isConnected()) return bl4;
                                    break block13;
                                }
                                if (!this.ftpClient.login(this.ftpVO.getUser(), this.ftpVO.getPassword())) {
                                    this.ftpClient.logout();
                                    this.testMsg = Resource.getString("ftpchooser.msg.nologin");
                                    bl3 = false;
                                    break block14;
                                }
                                this.ftpClient.syst();
                                if (!this.ftpClient.changeWorkingDirectory(this.ftpVO.getDirectory())) {
                                    this.testMsg = Resource.getString("ftpchooser.msg.nodirectory");
                                    bl2 = false;
                                    break block15;
                                }
                                this.testMsg = Resource.getString("ftpchooser.msg.success");
                                this.ftpClient.logout();
                            }
                            catch (IOException iOException) {
                                this.testMsg = iOException.getLocalizedMessage();
                                bl = true;
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (!this.ftpClient.isConnected()) throw throwable;
                            try {
                                this.ftpClient.disconnect();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    this.ftpClient.disconnect();
                    return bl4;
                }
                Object var6_9 = null;
                if (!this.ftpClient.isConnected()) return bl3;
                try {}
                catch (IOException iOException) {}
                this.ftpClient.disconnect();
                return bl3;
            }
            Object var6_10 = null;
            if (!this.ftpClient.isConnected()) return bl2;
            try {}
            catch (IOException iOException) {}
            this.ftpClient.disconnect();
            return bl2;
        }
        Object var6_11 = null;
        if (!this.ftpClient.isConnected()) return bl ^ true;
        try {}
        catch (IOException iOException) {
            return bl ^ true;
        }
        this.ftpClient.disconnect();
        return bl ^ true;
    }
}

