/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class DecadeElm
extends ChipElm {
    public DecadeElm(int n, int n2) {
        super(n, n2);
    }

    public DecadeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "decade counter";
    }

    boolean needsBits() {
        return true;
    }

    void setupPins() {
        this.sizeX = this.bits > 2 ? this.bits : 2;
        this.sizeY = 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(1, 2, "");
        this.pins[0].clock = true;
        this.pins[1] = new ChipElm.Pin(this.sizeX - 1, 1, "R");
        this.pins[1].bubble = true;
        for (int i = 0; i != this.bits; ++i) {
            int n = i + 2;
            this.pins[n] = new ChipElm.Pin(i, 0, "Q" + i);
            this.pins[n].state = true;
            this.pins[n].output = true;
        }
        this.allocNodes();
    }

    int getPostCount() {
        return this.bits + 2;
    }

    int getVoltageSourceCount() {
        return this.bits;
    }

    void execute() {
        int n;
        if (this.pins[0].value && !this.lastClock) {
            for (n = 0; n != this.bits && !this.pins[n + 2].value; ++n) {
            }
            if (n < this.bits) {
                this.pins[n++ + 2].value = false;
            }
            this.pins[(n %= this.bits) + 2].value = true;
        }
        if (!this.pins[1].value) {
            for (n = 1; n != this.bits; ++n) {
                this.pins[n + 2].value = false;
            }
            this.pins[2].value = true;
        }
        this.lastClock = this.pins[0].value;
    }

    int getDumpType() {
        return 163;
    }
}

