/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class InverterElm
extends CircuitElm {
    double slewRate;
    Polygon gatePoly;
    Point pcircle;

    public InverterElm(int n, int n2) {
        super(n, n2);
        this.noDiagonal = true;
        this.slewRate = 0.5;
    }

    public InverterElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.noDiagonal = true;
        try {
            this.slewRate = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.slewRate = 0.5;
        }
    }

    String dump() {
        return super.dump() + " " + this.slewRate;
    }

    int getDumpType() {
        return 73;
    }

    void draw(Graphics graphics) {
        this.drawPosts(graphics);
        this.draw2Leads(graphics);
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        InverterElm.drawThickPolygon(graphics, this.gatePoly);
        InverterElm.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, 3);
        this.curcount = this.updateDotCount(this.current, this.curcount);
        this.drawDots(graphics, this.lead2, this.point2, this.curcount);
    }

    void setPoints() {
        super.setPoints();
        int n = 16;
        int n2 = 16;
        if ((double)n2 > this.dn / 2.0) {
            n2 = (int)(this.dn / 2.0);
        }
        this.lead1 = this.interpPoint(this.point1, this.point2, 0.5 - (double)n2 / this.dn);
        this.lead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 + 2) / this.dn);
        this.pcircle = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 2) / this.dn);
        Point[] pointArray = this.newPointArray(3);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n);
        pointArray[2] = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 5) / this.dn);
        this.gatePoly = this.createPolygon(pointArray);
        this.setBbox(this.point1, this.point2, n);
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[1], this.voltSource);
    }

    void doStep() {
        double d = this.volts[1];
        double d2 = this.volts[0] > 2.5 ? 0.0 : 5.0;
        double d3 = this.slewRate * InverterElm.sim.timeStep * 1.0E9;
        d2 = Math.max(Math.min(d + d3, d2), d - d3);
        sim.updateVoltageSource(0, this.nodes[1], this.voltSource, d2);
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "inverter";
        stringArray[1] = "Vi = " + InverterElm.getVoltageText(this.volts[0]);
        stringArray[2] = "Vo = " + InverterElm.getVoltageText(this.volts[1]);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Slew Rate (V/ns)", this.slewRate, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        this.slewRate = editInfo.value;
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    boolean hasGroundConnection(int n) {
        return n == 1;
    }

    int getShortcut() {
        return 49;
    }
}

