/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.util.StringTokenizer;

class JKFlipFlopElm
extends ChipElm {
    final int FLAG_RESET = 2;

    boolean hasReset() {
        return (this.flags & 2) != 0;
    }

    public JKFlipFlopElm(int n, int n2) {
        super(n, n2);
    }

    public JKFlipFlopElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.pins[4].value = !this.pins[3].value;
    }

    String getChipName() {
        return "JK flip-flop";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "J");
        this.pins[1] = new ChipElm.Pin(1, 2, "");
        this.pins[1].clock = true;
        this.pins[1].bubble = true;
        this.pins[2] = new ChipElm.Pin(2, 2, "K");
        this.pins[3] = new ChipElm.Pin(0, 3, "Q");
        this.pins[3].state = true;
        this.pins[3].output = true;
        this.pins[4] = new ChipElm.Pin(2, 3, "Q");
        this.pins[4].output = true;
        this.pins[4].lineOver = true;
        if (this.hasReset()) {
            this.pins[5] = new ChipElm.Pin(1, 3, "R");
        }
    }

    int getPostCount() {
        return 5 + (this.hasReset() ? 1 : 0);
    }

    int getVoltageSourceCount() {
        return 2;
    }

    void execute() {
        if (!this.pins[1].value && this.lastClock) {
            boolean bl = this.pins[3].value;
            if (this.pins[0].value) {
                bl = this.pins[2].value ? !bl : true;
            } else if (this.pins[2].value) {
                bl = false;
            }
            this.pins[3].value = bl;
            this.pins[4].value = !bl;
        }
        this.lastClock = this.pins[1].value;
        if (this.hasReset() && this.pins[5].value) {
            this.pins[3].value = false;
            this.pins[4].value = true;
        }
    }

    int getDumpType() {
        return 156;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Reset Pin", this.hasReset());
            return editInfo;
        }
        return super.getEditInfo(n);
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 2) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            this.setupPins();
            this.allocNodes();
            this.setPoints();
        }
        super.setEditValue(n, editInfo);
    }
}

