/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Graphics;
import java.util.StringTokenizer;

class LogicOutputElm
extends CircuitElm {
    final int FLAG_TERNARY = 1;
    final int FLAG_NUMERIC = 2;
    final int FLAG_PULLDOWN = 4;
    double threshold;
    String value;

    public LogicOutputElm(int n, int n2) {
        super(n, n2);
        this.threshold = 2.5;
    }

    public LogicOutputElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        try {
            this.threshold = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.threshold = 2.5;
        }
    }

    String dump() {
        return super.dump() + " " + this.threshold;
    }

    int getDumpType() {
        return 77;
    }

    int getPostCount() {
        return 1;
    }

    boolean isTernary() {
        return (this.flags & 1) != 0;
    }

    boolean isNumeric() {
        return (this.flags & 3) != 0;
    }

    boolean needsPullDown() {
        return (this.flags & 4) != 0;
    }

    void setPoints() {
        super.setPoints();
        this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 12.0 / this.dn);
    }

    void draw(Graphics graphics) {
        String string;
        Font font = new Font("SansSerif", 1, 20);
        graphics.setFont(font);
        graphics.setColor(lightGrayColor);
        String string2 = string = this.volts[0] < this.threshold ? "L" : "H";
        if (this.isTernary()) {
            string = this.volts[0] > 3.75 ? "2" : (this.volts[0] > 1.25 ? "1" : "0");
        } else if (this.isNumeric()) {
            string = this.volts[0] < this.threshold ? "0" : "1";
        }
        this.value = string;
        this.setBbox(this.point1, this.lead1, 0.0);
        this.drawCenteredText(graphics, string, this.x2, this.y2, true);
        this.setVoltageColor(graphics, this.volts[0]);
        LogicOutputElm.drawThickLine(graphics, this.point1, this.lead1);
        this.drawPosts(graphics);
    }

    void stamp() {
        if (this.needsPullDown()) {
            sim.stampResistor(this.nodes[0], 0, 1000000.0);
        }
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "logic output";
        String string = stringArray[1] = this.volts[0] < this.threshold ? "low" : "high";
        if (this.isNumeric()) {
            stringArray[1] = this.value;
        }
        stringArray[2] = "V = " + LogicOutputElm.getVoltageText(this.volts[0]);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Threshold", this.threshold, 10.0, -10.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Current Required", this.needsPullDown());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.threshold = editInfo.value;
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? 4 : (this.flags &= 0xFFFFFFFB);
        }
    }

    int getShortcut() {
        return 111;
    }
}

