/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class OpAmpElm
extends CircuitElm {
    int opsize;
    int opheight;
    int opwidth;
    int opaddtext;
    double maxOut;
    double minOut;
    double gain;
    double gbw;
    boolean reset;
    final int FLAG_SWAP = 1;
    final int FLAG_SMALL = 2;
    final int FLAG_LOWGAIN = 4;
    Point[] in1p;
    Point[] in2p;
    Point[] textp;
    Polygon triangle;
    Font plusFont;
    double lastvd;

    public OpAmpElm(int n, int n2) {
        super(n, n2);
        this.noDiagonal = true;
        this.maxOut = 15.0;
        this.minOut = -15.0;
        this.gbw = 1000000.0;
        this.setSize(OpAmpElm.sim.smallGridCheckItem.getState() ? 1 : 2);
        this.setGain();
    }

    public OpAmpElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.maxOut = 15.0;
        this.minOut = -15.0;
        this.gbw = 1000000.0;
        try {
            this.maxOut = new Double(stringTokenizer.nextToken());
            this.minOut = new Double(stringTokenizer.nextToken());
            this.gbw = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.noDiagonal = true;
        this.setSize((n5 & 2) != 0 ? 1 : 2);
        this.setGain();
    }

    void setGain() {
        this.gain = (this.flags & 4) != 0 ? 1000.0 : 100000.0;
    }

    String dump() {
        return super.dump() + " " + this.maxOut + " " + this.minOut + " " + this.gbw;
    }

    boolean nonLinear() {
        return true;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, this.opheight * 2);
        this.setVoltageColor(graphics, this.volts[0]);
        OpAmpElm.drawThickLine(graphics, this.in1p[0], this.in1p[1]);
        this.setVoltageColor(graphics, this.volts[1]);
        OpAmpElm.drawThickLine(graphics, this.in2p[0], this.in2p[1]);
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        this.setPowerColor(graphics, true);
        OpAmpElm.drawThickPolygon(graphics, this.triangle);
        graphics.setFont(this.plusFont);
        this.drawCenteredText(graphics, "-", this.textp[0].x, this.textp[0].y - 2, true);
        this.drawCenteredText(graphics, "+", this.textp[1].x, this.textp[1].y, true);
        this.setVoltageColor(graphics, this.volts[2]);
        OpAmpElm.drawThickLine(graphics, this.lead2, this.point2);
        this.curcount = this.updateDotCount(this.current, this.curcount);
        this.drawDots(graphics, this.point2, this.lead2, this.curcount);
        this.drawPosts(graphics);
    }

    double getPower() {
        return this.volts[2] * this.current;
    }

    void setSize(int n) {
        this.opsize = n;
        this.opheight = 8 * n;
        this.opwidth = 13 * n;
        this.flags = this.flags & 0xFFFFFFFD | (n == 1 ? 2 : 0);
    }

    void setPoints() {
        int n;
        super.setPoints();
        if (this.dn > 150.0 && this == OpAmpElm.sim.dragElm) {
            this.setSize(2);
        }
        if ((double)(n = this.opwidth) > this.dn / 2.0) {
            n = (int)(this.dn / 2.0);
        }
        this.calcLeads(n * 2);
        int n2 = this.opheight * this.dsign;
        if ((this.flags & 1) != 0) {
            n2 = -n2;
        }
        this.in1p = this.newPointArray(2);
        this.in2p = this.newPointArray(2);
        this.textp = this.newPointArray(2);
        this.interpPoint2(this.point1, this.point2, this.in1p[0], this.in2p[0], 0.0, n2);
        this.interpPoint2(this.lead1, this.lead2, this.in1p[1], this.in2p[1], 0.0, n2);
        this.interpPoint2(this.lead1, this.lead2, this.textp[0], this.textp[1], 0.2, n2);
        Point[] pointArray = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n2 * 2);
        this.triangle = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
        this.plusFont = new Font("SansSerif", 0, this.opsize == 2 ? 14 : 10);
    }

    int getPostCount() {
        return 3;
    }

    Point getPost(int n) {
        return n == 0 ? this.in1p[0] : (n == 1 ? this.in2p[0] : this.point2);
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "op-amp";
        stringArray[1] = "V+ = " + OpAmpElm.getVoltageText(this.volts[1]);
        stringArray[2] = "V- = " + OpAmpElm.getVoltageText(this.volts[0]);
        double d = Math.max(Math.min(this.volts[2], this.maxOut), this.minOut);
        stringArray[3] = "Vout = " + OpAmpElm.getVoltageText(d);
        stringArray[4] = "Iout = " + OpAmpElm.getCurrentText(this.getCurrent());
        stringArray[5] = "range = " + OpAmpElm.getVoltageText(this.minOut) + " to " + OpAmpElm.getVoltageText(this.maxOut);
    }

    void stamp() {
        int n = OpAmpElm.sim.nodeList.size() + this.voltSource;
        sim.stampNonLinear(n);
        sim.stampMatrix(this.nodes[2], n, 1.0);
    }

    void doStep() {
        double d = this.volts[1] - this.volts[0];
        if (Math.abs(this.lastvd - d) > 0.1) {
            OpAmpElm.sim.converged = false;
        } else if (this.volts[2] > this.maxOut + 0.1 || this.volts[2] < this.minOut - 0.1) {
            OpAmpElm.sim.converged = false;
        }
        double d2 = 0.0;
        int n = OpAmpElm.sim.nodeList.size() + this.voltSource;
        double d3 = 0.0;
        if (d >= this.maxOut / this.gain && (this.lastvd >= 0.0 || sim.getrand(4) == 1)) {
            d3 = 1.0E-4;
            d2 = this.maxOut - d3 * this.maxOut / this.gain;
        } else if (d <= this.minOut / this.gain && (this.lastvd <= 0.0 || sim.getrand(4) == 1)) {
            d3 = 1.0E-4;
            d2 = this.minOut - d3 * this.minOut / this.gain;
        } else {
            d3 = this.gain;
        }
        sim.stampMatrix(n, this.nodes[0], d3);
        sim.stampMatrix(n, this.nodes[1], -d3);
        sim.stampMatrix(n, this.nodes[2], 1.0);
        sim.stampRightSide(n, d2);
        this.lastvd = d;
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    boolean hasGroundConnection(int n) {
        return n == 2;
    }

    double getVoltageDiff() {
        return this.volts[2] - this.volts[1];
    }

    int getDumpType() {
        return 97;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Max Output (V)", this.maxOut, 1.0, 20.0);
        }
        if (n == 1) {
            return new EditInfo("Min Output (V)", this.minOut, -20.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.maxOut = editInfo.value;
        }
        if (n == 1) {
            this.minOut = editInfo.value;
        }
    }
}

