/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class SipoShiftElm
extends ChipElm {
    short data = 0;
    boolean clockstate = false;

    boolean hasReset() {
        return false;
    }

    public SipoShiftElm(int n, int n2) {
        super(n, n2);
    }

    public SipoShiftElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "SIPO shift register";
    }

    void setupPins() {
        this.sizeX = 9;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(1, 2, "D");
        this.pins[1] = new ChipElm.Pin(2, 2, "");
        this.pins[1].clock = true;
        this.pins[2] = new ChipElm.Pin(1, 0, "I7");
        this.pins[2].output = true;
        this.pins[3] = new ChipElm.Pin(2, 0, "I6");
        this.pins[3].output = true;
        this.pins[4] = new ChipElm.Pin(3, 0, "I5");
        this.pins[4].output = true;
        this.pins[5] = new ChipElm.Pin(4, 0, "I4");
        this.pins[5].output = true;
        this.pins[6] = new ChipElm.Pin(5, 0, "I3");
        this.pins[6].output = true;
        this.pins[7] = new ChipElm.Pin(6, 0, "I2");
        this.pins[7].output = true;
        this.pins[8] = new ChipElm.Pin(7, 0, "I1");
        this.pins[8].output = true;
        this.pins[9] = new ChipElm.Pin(8, 0, "I0");
        this.pins[9].output = true;
    }

    int getPostCount() {
        return 10;
    }

    int getVoltageSourceCount() {
        return 8;
    }

    void execute() {
        if (this.pins[1].value && !this.clockstate) {
            this.clockstate = true;
            this.data = (short)(this.data >>> 1);
            if (this.pins[0].value) {
                this.data = (short)(this.data + 128);
            }
            this.pins[2].value = (this.data & 0x80) > 0;
            this.pins[3].value = (this.data & 0x40) > 0;
            this.pins[4].value = (this.data & 0x20) > 0;
            this.pins[5].value = (this.data & 0x10) > 0;
            this.pins[6].value = (this.data & 8) > 0;
            this.pins[7].value = (this.data & 4) > 0;
            this.pins[8].value = (this.data & 2) > 0;
            this.pins[9].value = (this.data & 1) > 0;
        }
        if (!this.pins[1].value) {
            this.clockstate = false;
        }
    }

    int getDumpType() {
        return 189;
    }
}

