/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class ZenerElm
extends DiodeElm {
    final int hs = 8;
    Polygon poly;
    Point[] cathode;
    Point[] wing;
    final double default_zvoltage = 5.6;

    public ZenerElm(int n, int n2) {
        super(n, n2);
        this.zvoltage = 5.6;
        this.setup();
    }

    public ZenerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.zvoltage = new Double(stringTokenizer.nextToken());
        this.setup();
    }

    void setup() {
        this.diode.leakage = 5.0E-6;
        super.setup();
    }

    int getDumpType() {
        return 122;
    }

    String dump() {
        return super.dump() + " " + this.zvoltage;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(16);
        this.cathode = this.newPointArray(2);
        this.wing = this.newPointArray(2);
        Point[] pointArray = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
        this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
        this.interpPoint(this.cathode[0], this.cathode[1], this.wing[0], -0.2, -8.0);
        this.interpPoint(this.cathode[1], this.cathode[0], this.wing[1], -0.2, -8.0);
        this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 8.0);
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, d);
        graphics.fillPolygon(this.poly);
        this.setVoltageColor(graphics, d2);
        ZenerElm.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
        ZenerElm.drawThickLine(graphics, this.wing[0], this.cathode[0]);
        ZenerElm.drawThickLine(graphics, this.wing[1], this.cathode[1]);
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    void getInfo(String[] stringArray) {
        super.getInfo(stringArray);
        stringArray[0] = "Zener diode";
        stringArray[5] = "Vz = " + ZenerElm.getVoltageText(this.zvoltage);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Fwd Voltage @ 1A", this.fwdrop, 10.0, 1000.0);
        }
        if (n == 1) {
            return new EditInfo("Zener Voltage @ 5mA", this.zvoltage, 1.0, 25.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.fwdrop = editInfo.value;
        }
        if (n == 1) {
            this.zvoltage = editInfo.value;
        }
        this.setup();
    }

    int getShortcut() {
        return 0;
    }
}

