/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.installer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jsynoptic.installer.Installer;
import jsynoptic.installer.InstallerPanel;
import simtools.ui.CustomizedLocale;
import simtools.util.LogConfigurator;

class PackagesPanel
extends InstallerPanel {
    static Logger _logger = LogConfigurator.getLogger((class$jsynoptic$installer$PackagesPanel == null ? (class$jsynoptic$installer$PackagesPanel = PackagesPanel.class$("jsynoptic.installer.PackagesPanel")) : class$jsynoptic$installer$PackagesPanel).getName());
    protected ArrayList boxes;
    protected int numPackages;
    protected File location;
    protected JTextField tfLoc;
    protected JButton btnLoc;
    protected JEditorPane tipPane;
    protected JScrollPane tipScroll;
    protected JProgressBar progress;
    protected boolean installFinished;
    protected Thread installThread;
    protected String os;
    static /* synthetic */ Class class$jsynoptic$installer$PackagesPanel;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$jsynoptic$installer$resources$InstallerResources;

    public PackagesPanel(Installer installer) {
        super(installer);
        this.setLayout(new BorderLayout());
        this.boxes = new ArrayList();
        this.numPackages = Long.decode(Installer.resources.getString("numPackages")).intValue();
        this.os = File.separatorChar == '/' ? "Unix" : (File.separatorChar == '\\' ? "Windows" : "Other");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(this.numPackages, 1));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        for (int i = 1; i <= this.numPackages; ++i) {
            String string;
            int n = Long.decode(Installer.resources.getString("packageDefaultState" + i)).intValue();
            try {
                string = Installer.resources.getString("packageName" + i + this.os);
            }
            catch (MissingResourceException missingResourceException) {
                string = Installer.resources.getString("packageName" + i);
            }
            JCheckBox jCheckBox = new JCheckBox(string, n >= 1);
            jCheckBox.addMouseListener(new TipListener("packageTip" + i));
            if (n == 2) {
                jCheckBox.setEnabled(false);
            }
            this.boxes.add(jCheckBox);
            jCheckBox.setAlignmentX(0.0f);
            jPanel2.add(jCheckBox);
        }
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(jPanel3), "West");
        this.tipPane = new JEditorPane();
        this.tipPane.setEditable(false);
        this.tipPane.setAutoscrolls(false);
        this.tipPane.setContentType("text/html");
        this.tipPane.setText(Installer.resources.getString("pointPackageForDescription"));
        this.tipScroll = new JScrollPane(this.tipPane);
        jPanel.add((Component)this.tipScroll, "Center");
        this.progress = new JProgressBar();
        jPanel.add((Component)this.progress, "South");
        this.add((Component)jPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(Installer.resources.getString("location")));
        this.location = new File(Installer.resources.getString("defaultLocation" + this.os));
        this.tfLoc = new JTextField();
        box.add(this.tfLoc);
        this.updateLoc();
        Dimension dimension = this.tfLoc.getPreferredSize();
        dimension.width = this.getWidth();
        this.tfLoc.setMaximumSize(dimension);
        this.btnLoc = new JButton(Installer.resources.getString("chooseLocation"));
        box.add(this.btnLoc);
        this.add((Component)box, "South");
        this.btnLoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(PackagesPanel.this.location);
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(PackagesPanel.this.installer);
                if (n == 0) {
                    PackagesPanel.this.location = jFileChooser.getSelectedFile();
                    if (PackagesPanel.this.location == null) {
                        PackagesPanel.this.location = jFileChooser.getCurrentDirectory();
                    }
                    PackagesPanel.this.updateLoc();
                }
            }
        });
        this.installFinished = false;
        this.installThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        boolean bl = false;
        PackagesPanel packagesPanel = this;
        synchronized (packagesPanel) {
            if (this.installFinished) {
                bl = true;
            } else {
                if (this.installThread != null) {
                    return false;
                }
                this.installThread = new Thread(){

                    public void run() {
                        PackagesPanel.this.install();
                    }
                };
            }
        }
        if (bl) {
            this.runJSynoptic();
            return true;
        }
        this.installThread.start();
        return false;
    }

    protected void runJSynoptic() {
        new Thread(){

            public void run() {
                PackagesPanel.this.installer.writeProperties();
                PackagesPanel.this.location.getAbsolutePath();
                File file = PackagesPanel.this.os.equals("Unix") ? new File(PackagesPanel.this.location, "jsynoptic.sh") : (PackagesPanel.this.os.equals("Windows") ? new File(PackagesPanel.this.location, "jsynoptic.exe") : null);
                if (file != null && file.exists()) {
                    try {
                        Runtime.getRuntime().exec(file.getAbsolutePath());
                        System.exit(0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle("jsynoptic.ui.resources.RunResources", CustomizedLocale.get());
                File file2 = new File(PackagesPanel.this.location, "jsynoptic-" + resourceBundle.getString("productVersion") + ".jar");
                if (!file2.exists()) {
                    JOptionPane.showMessageDialog(PackagesPanel.this.installer, Installer.resources.getString("cantFindJSynoptic"), Installer.resources.getString("errorInInstall"), 0);
                    return;
                }
                PackagesPanel.this.installer.dispose();
                URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                try {
                    Method method = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = PackagesPanel.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = PackagesPanel.class$("java.net.URL")) : class$java$net$URL);
                    method.setAccessible(true);
                    method.invoke((Object)uRLClassLoader, file2.toURL());
                    method = Class.forName("jsynoptic.ui.Run").getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = PackagesPanel.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    method.invoke(null, new Object[]{new String[0]});
                }
                catch (Exception exception) {
                    System.err.println(Installer.resources.getString("installErrorIs") + exception.getLocalizedMessage());
                    System.err.println(Installer.resources.getString("errorInInstall"));
                    System.exit(1);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() {
        Object object;
        this.location = new File(this.tfLoc.getText());
        if (!this.location.exists()) {
            this.location.mkdirs();
        }
        if (!this.location.isDirectory()) {
            this.location = new File(this.location.getParentFile(), "jsynoptic");
        }
        this.tfLoc.setText(this.location.getAbsolutePath());
        boolean bl = false;
        byte[] byArray = new byte[4096];
        this.installer.previous.setEnabled(false);
        this.installer.next.setEnabled(false);
        this.tfLoc.setEnabled(false);
        this.btnLoc.setEnabled(false);
        try {
            int n;
            Object[] objectArray;
            Object object2;
            Object object3;
            Object object4;
            for (int i = 1; i <= this.numPackages; ++i) {
                ZipEntry zipEntry;
                object = (JCheckBox)this.boxes.get(i - 1);
                if (!object.isSelected()) continue;
                object.setBackground(Color.red);
                try {
                    if (this.installer.jre == null) {
                        try {
                            object4 = Installer.resources.getString("packageZip" + i + this.os + "NoJRE");
                        }
                        catch (MissingResourceException missingResourceException) {
                            object4 = Installer.resources.getString("packageZip" + i + this.os);
                        }
                    } else {
                        object4 = Installer.resources.getString("packageZip" + i + this.os);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    object4 = Installer.resources.getString("packageZip" + i);
                }
                object3 = (class$jsynoptic$installer$resources$InstallerResources == null ? PackagesPanel.class$("jsynoptic.installer.resources.InstallerResources") : class$jsynoptic$installer$resources$InstallerResources).getResourceAsStream((String)object4);
                if (object3 == null) {
                    throw new IOException();
                }
                ZipInputStream zipInputStream = new ZipInputStream((InputStream)object3);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n2;
                    long l;
                    object2 = new File(this.location, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        ((File)object2).mkdirs();
                        continue;
                    }
                    if (((File)object2).exists() && !bl) {
                        objectArray = new Object[]{Installer.resources.getString("yes"), Installer.resources.getString("yesAll"), Installer.resources.getString("no"), Installer.resources.getString("cancel")};
                        n = JOptionPane.showOptionDialog(this.installer, Installer.resources.getString("overwriteFile") + ((File)object2).getAbsolutePath(), Installer.resources.getString("overwriteTitle"), -1, 3, null, objectArray, objectArray[0]);
                        if (n == 2) continue;
                        if (n == -1 || n == 3) break;
                        if (n == 1) {
                            bl = true;
                        }
                    }
                    if ((l = zipEntry.getSize()) != -1L) {
                        this.progress.setIndeterminate(false);
                        this.progress.setMinimum(0);
                        this.progress.setMaximum((int)l);
                        this.progress.setValue(0);
                    } else {
                        this.progress.setIndeterminate(true);
                    }
                    this.progress.setString(((File)object2).getAbsolutePath());
                    this.progress.setStringPainted(true);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
                    while ((n2 = zipInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                        try {
                            SwingUtilities.invokeAndWait(new BarUpdater(n2));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                object.setBackground(Color.green);
            }
            if (this.installer.zip != null) {
                ZipFile zipFile = new ZipFile(this.installer.zip);
                object = zipFile.getEntry("jre");
                if (object == null) {
                    throw new IOException("Internal Error!");
                }
                object4 = zipFile.entries();
                while (object4.hasMoreElements()) {
                    long l;
                    object = object4.nextElement();
                    if (!object.getName().startsWith("jre")) continue;
                    object3 = new File(this.location, object.getName());
                    if (object.isDirectory()) {
                        ((File)object3).mkdirs();
                        continue;
                    }
                    if (((File)object3).exists() && !bl) {
                        Object[] objectArray2 = new Object[]{Installer.resources.getString("yes"), Installer.resources.getString("yesAll"), Installer.resources.getString("no"), Installer.resources.getString("cancel")};
                        int n3 = JOptionPane.showOptionDialog(this.installer, Installer.resources.getString("overwriteFile") + ((File)object3).getAbsolutePath(), Installer.resources.getString("overwriteTitle"), -1, 3, null, objectArray2, objectArray2[0]);
                        if (n3 == 2) continue;
                        if (n3 == -1 || n3 == 3) break;
                        if (n3 == 1) {
                            bl = true;
                        }
                    }
                    if ((l = object.getSize()) != -1L) {
                        this.progress.setIndeterminate(false);
                        this.progress.setMinimum(0);
                        this.progress.setMaximum((int)l);
                        this.progress.setValue(0);
                    } else {
                        this.progress.setIndeterminate(true);
                    }
                    this.progress.setString(Installer.resources.getString("installingJRE") + " : " + ((File)object3).getAbsolutePath());
                    this.progress.setStringPainted(true);
                    object2 = new FileOutputStream((File)object3);
                    objectArray = zipFile.getInputStream((ZipEntry)object);
                    while ((n = objectArray.read(byArray)) != -1) {
                        ((FileOutputStream)object2).write(byArray, 0, n);
                        try {
                            SwingUtilities.invokeAndWait(new BarUpdater(n));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                    ((OutputStream)object2).flush();
                    ((FileOutputStream)object2).close();
                }
                zipFile.close();
            } else if (this.installer.jre != null) {
                this.progress.setMinimum(0);
                this.progress.setMaximum(1);
                this.progress.setValue(0);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            PackagesPanel.this.progress.setIndeterminate(true);
                            PackagesPanel.this.progress.setString(Installer.resources.getString("installingJRE"));
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                this.copy(this.installer.jre, this.location);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            PackagesPanel.this.progress.setIndeterminate(false);
                            PackagesPanel.this.progress.setValue(1);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (this.os.equals("Unix")) {
                File file = new File("/usr/bin/chmod");
                if (!file.exists()) {
                    file = new File("/bin/chmod");
                }
                if (!file.exists()) {
                    file = new File("/usr/local/bin/chmod");
                }
                if (!file.exists()) {
                    file = new File("/sbin/chmod");
                }
                if (!file.exists()) {
                    file = new File("/usr/sbin/chmod");
                }
                if (!file.exists()) {
                    file = new File("/usr/local/sbin/chmod");
                }
                if (file.exists()) {
                    object = file.getAbsolutePath() + " +x ";
                    object4 = new File(this.location, "jsynoptic.sh");
                    if (((File)object4).exists()) {
                        Runtime.getRuntime().exec((String)object + ((File)object4).getAbsolutePath());
                    }
                    if (((File)(object3 = new File(new File(this.location, "jre"), "bin"))).exists()) {
                        File[] fileArray = ((File)object3).listFiles();
                        for (int i = 0; i < fileArray.length; ++i) {
                            Runtime.getRuntime().exec((String)object + fileArray[i].getAbsolutePath());
                        }
                    }
                    Runtime.getRuntime().exec((String)object + "jsynoptic.sh");
                }
            }
        }
        catch (IOException iOException) {
            this.installer.previous.setEnabled(true);
            this.installer.next.setEnabled(true);
            this.tfLoc.setEnabled(true);
            this.btnLoc.setEnabled(true);
            JOptionPane.showMessageDialog(this.installer, Installer.resources.getString("installErrorIs") + iOException.getLocalizedMessage(), Installer.resources.getString("errorInInstall"), 0);
            PackagesPanel packagesPanel = this;
            synchronized (packagesPanel) {
                this.installFinished = false;
                this.installThread = null;
            }
            return;
        }
        PackagesPanel packagesPanel = this;
        synchronized (packagesPanel) {
            this.installFinished = true;
            this.progress.setString(Installer.resources.getString("installComplete"));
            this.installer.next.setText(Installer.resources.getString("run"));
            this.installer.cancel.setText(Installer.resources.getString("dontRun"));
            object = this.installer.cancel.getActionListeners();
            for (int i = 0; i < ((ActionListener[])object).length; ++i) {
                this.installer.cancel.removeActionListener(object[i]);
            }
            this.installer.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PackagesPanel.this.installer.writeProperties();
                    System.exit(0);
                }
            });
            this.installer.next.setEnabled(true);
        }
    }

    protected void copy(File file, File file2) throws IOException {
        if (file.isDirectory() && file2.isFile()) {
            throw new IOException("Cannot copy a directory to a file");
        }
        if (file.isDirectory()) {
            File file3 = new File(file2, file.getName());
            if (!file3.mkdirs()) {
                throw new IOException("Cannot create a new Directory");
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.copy(fileArray[i], file3);
            }
            return;
        }
        if (file2.isDirectory()) {
            File file4 = new File(file2, file.getName());
            file4.createNewFile();
            this.copy(file, file4);
            return;
        }
        try {
            long l;
            if (file.length() == 0L) {
                file2.createNewFile();
                return;
            }
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            long l2 = file.length();
            for (long i = 0L; i < l2; i += l) {
                l = fileChannel.transferTo(i, l2 - i, fileChannel2);
                if (l != 0L) continue;
                throw new IOException("Error while copying");
            }
            fileChannel2.close();
            fileChannel.close();
        }
        catch (IOException iOException) {
            if (this.os.equals("Unix")) {
                _logger.fine("Trying to use cp to copy file...");
                File file5 = new File("/usr/bin/cp");
                if (!file5.exists()) {
                    file5 = new File("/bin/cp");
                }
                if (!file5.exists()) {
                    file5 = new File("/usr/local/bin/cp");
                }
                if (!file5.exists()) {
                    file5 = new File("/sbin/cp");
                }
                if (!file5.exists()) {
                    file5 = new File("/usr/sbin/cp");
                }
                if (!file5.exists()) {
                    file5 = new File("/usr/local/sbin/cp");
                }
                if (file5.exists()) {
                    Process process = Runtime.getRuntime().exec(file5.getAbsolutePath() + " '" + file.getAbsolutePath() + "' '" + file2.getAbsolutePath() + "'");
                    try {
                        int n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        throw iOException;
                    }
                    return;
                }
            }
            throw iOException;
        }
    }

    protected void updateLoc() {
        try {
            this.tfLoc.setText(this.location.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.tfLoc.setText(this.location.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        PackagesPanel packagesPanel = this;
        synchronized (packagesPanel) {
            if (this.installFinished) {
                this.installer.next.setText(Installer.resources.getString("run"));
                this.installer.cancel.setText(Installer.resources.getString("dontRun"));
                this.installer.previous.setEnabled(false);
            } else {
                this.installer.next.setText(Installer.resources.getString("install"));
                this.installer.cancel.setText(Installer.resources.getString("cancel"));
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(Installer.resources.getString("selectPackages")));
        for (int i = 1; i <= this.numPackages; ++i) {
            String string;
            JCheckBox jCheckBox = (JCheckBox)this.boxes.get(i - 1);
            try {
                string = Installer.resources.getString("packageName" + i + this.os);
            }
            catch (MissingResourceException missingResourceException) {
                string = Installer.resources.getString("packageName" + i);
            }
            jCheckBox.setText(string);
        }
        this.tipPane.setText(Installer.resources.getString("pointPackageForDescription"));
        this.progress.setMinimum(0);
        this.progress.setMaximum(1);
        this.progress.setValue(0);
        this.progress.setStringPainted(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class TipListener
    extends MouseAdapter {
        protected String key;

        public TipListener(String string) {
            this.key = string;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            String string;
            try {
                string = Installer.resources.getString(this.key + PackagesPanel.this.os);
            }
            catch (MissingResourceException missingResourceException) {
                string = Installer.resources.getString(this.key);
            }
            PackagesPanel.this.tipPane.setText(string);
            JScrollBar jScrollBar = PackagesPanel.this.tipScroll.getVerticalScrollBar();
            if (jScrollBar != null) {
                jScrollBar.setValue(jScrollBar.getMinimum());
            }
        }
    }

    protected class BarUpdater
    implements Runnable {
        int delta;

        public BarUpdater(int n) {
            this.delta = n;
        }

        public void run() {
            PackagesPanel.this.progress.setValue(PackagesPanel.this.progress.getValue() + this.delta);
        }
    }
}

