/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.components;

import fontviewer.FontViewer;
import fontviewer.components.CharacterMapPanel;
import fontviewer.components.PreviewPanel;
import fontviewer.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainPanel
extends JPanel {
    private CharacterMapPanel characterMapPanel = null;
    private FontViewer parent = null;
    private PreviewPanel previewPanel = null;

    public MainPanel(FontViewer fontViewer) {
        this.parent = fontViewer;
        I18N i18N = fontViewer.getLocalisedResources();
        this.characterMapPanel = new CharacterMapPanel(i18N);
        this.previewPanel = new PreviewPanel(i18N);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(i18N.localisedString("Gui.TabPane.Tab.Preview"), this.previewPanel);
        jTabbedPane.addTab(i18N.localisedString("Gui.TabPane.Tab.Charactermap"), this.characterMapPanel);
        jTabbedPane.setTabPlacement(3);
        this.add((Component)jTabbedPane, "Center");
    }

    public void setPanelFont(Font font) {
        this.previewPanel.setPanelFont(font);
        this.characterMapPanel.setPanelFont(font);
    }

    public void updateFont(Font font) {
        this.parent.updateFont(font, false);
    }
}

