/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class UnicodeConverter
extends JFrame {
    private JPanel centerPanel;
    private JButton convertBtn;
    private JPanel northPanel;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private JTextField textField;

    public UnicodeConverter() {
        this.initComponents();
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.textField = new JTextField();
        this.convertBtn = new JButton();
        this.centerPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.setTitle("Unicode Converter");
        this.textField.setColumns(20);
        this.northPanel.add(this.textField);
        this.convertBtn.setText("Convert");
        this.convertBtn.addActionListener(formListener);
        this.northPanel.add(this.convertBtn);
        this.getContentPane().add((Component)this.northPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.scrollPane.setViewportView(this.textArea);
        this.centerPanel.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private void convertBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.textField.getText();
        if (string != null && !string.equals("")) {
            this.textArea.setText("");
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isWhitespace(cArray[i])) {
                    this.textArea.append(" ");
                    continue;
                }
                String string2 = Integer.toHexString(cArray[i]);
                for (int j = string2.length(); j < 4; ++j) {
                    string2 = "0" + string2;
                }
                this.textArea.append("\\u" + string2);
            }
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new UnicodeConverter().setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UnicodeConverter.this.convertBtn) {
                UnicodeConverter.this.convertBtnActionPerformed(actionEvent);
            }
        }
    }
}

