/*
 * Created on 27.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

/**
 * @author Sebastian Schleemilch
 */
public class FontManager extends JDialog implements ActionListener {
	JList fontlist = new JList();
	File fdir_file;
	JFileChooser chooser;
	JButton install = new JButton("Install");
	JButton deinstall = new JButton("Deinstall");
	
	public FontManager() {
		setTitle("Font manager");
		JToolBar bar = new JToolBar();
		bar.add(install); bar.add(deinstall);
		install.addActionListener(this);
		deinstall.addActionListener(this);
		getContentPane().add(bar, "North");
		
		getContentPane().add(new JScrollPane(fontlist), "Center");
		WindowPositionTools.middle(this);
		
		// Init system independent font dir
		String fontdir = "";
		String osname = System.getProperty("os.name").toLowerCase();
		if(osname.indexOf("windows") > -1) {
			try {
				InputStream is = Runtime.getRuntime().exec(
						"command /c echo %WINDIR%").getInputStream();
				StringBuffer sb = new StringBuffer();
				for(int c; (c = is.read()) != -1; )
					sb.append(c);
				fontdir = sb.toString() + "\\Fonts\\";
			} catch (IOException e) {
				e.printStackTrace();
				fontdir = "c:\\windows\\Fonts\\";
			}
		}
		else if(osname.indexOf("linux")> -1 || osname.indexOf("unix")> -1) {
			fontdir = "/usr/X11R6/lib/X11/fonts/truetype";
		}
		
		fdir_file = new File(fontdir);
		chooser = new JFileChooser(fdir_file);
	}
	
	
	
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
		if(src.equals(install)) {
			chooser.setDialogTitle("Select source font");
			int state = chooser.showOpenDialog(this);
			if(state == JFileChooser.APPROVE_OPTION) {
				copy(chooser.getSelectedFile(), new File(fdir_file, chooser.getSelectedFile().getName()));
				refreshItems();
			}
			else
				getToolkit().beep();
		}
		else if(src.equals(deinstall)) {
			if(fontlist.getSelectedIndex() != -1) {
				if(
						JOptionPane.showConfirmDialog(this, "Really deinstall the font " + fontlist.getSelectedValue() + "?", 
								"Deinstall Font", JOptionPane.YES_NO_OPTION)
						== JOptionPane.YES_OPTION) {
					try {
						new File(fdir_file, fontlist.getSelectedValue().toString()).delete();
					} catch (Exception e1) {
						e1.printStackTrace();
					}
					refreshItems();
				}
			}
			else
				getToolkit().beep();
		}
	}
	
	private void copy( InputStream fis, OutputStream fos ) {
	    try {
	      byte[] buffer = new byte[ 0xFFFF ];
	      for ( int len; (len = fis.read(buffer)) != -1; )
	        fos.write( buffer, 0, len );
	    } catch( IOException e ) {
	    	System.err.println( e );
	    }
	    finally {
	      if ( fis != null )
	        try { fis.close(); } catch ( IOException e ) { e.printStackTrace(); }
	      if ( fos != null )
	        try { fos.close(); } catch ( IOException e ) { e.printStackTrace(); }
	    }
	 }

	private void copy( File src, File dest )
	  {
	    try
	    {
	      copy( new FileInputStream( src ), new FileOutputStream( dest ) );
	    }
	    catch( IOException e ) {
	      e.printStackTrace();
	    }
	  }
	
	public void refreshItems() {
		if(fdir_file.isDirectory() && fdir_file.canRead()) {
			File[] f = fdir_file.listFiles();
			String fitems[] = new String[f.length];
			for(int i = 0; i < fitems.length; i++) {
				if(f[i].isFile())
					fitems[i] = f[i].getName();
				else
					System.err.println("Is no font:" + f[i]);
			}
			fontlist.setListData(fitems);
		}
		else System.err.println("No Dir or no permission:" + fdir_file);
	}
	

}
