/*
 * Created on 01.10.2006
 */
package updater;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import de.ssfuture.tools.updater.LoggingInterface;

/**
 * @author Sebastian Schleemilch
 */
public class TextAreaLogger extends JFrame implements LoggingInterface {
	JTextArea area = new JTextArea();
	
	public TextAreaLogger() {
		setTitle("Finishing update installation");
		setSize(480, 500);
		getContentPane().add(new JScrollPane(area), "Center");
		setVisible(true);
	}

	public void defaultLog(String text) {
		area.append("\t" + text.replaceAll("\n", "\t\n") + "\n");
	}
	public void headlineLog(String text) {
		area.append(text.toUpperCase() + "\n");
	}
	public void progressStatus(int status) {
		
	}
	public void progressStatusExit() {
		area.append("DONE\n");
	}
	public void progressStatusInit(String description, int min, int max) {
		area.append("Starting task \"" + description + "\" ...");
	}
}
