/*
 * Decompiled with CFR 0.152.
 */
package dk.mikkle.network.ip.multicast;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.TimerTask;

class MulticastSender
extends TimerTask {
    private MulticastSocket m_MCS;
    private DatagramPacket m_DP;
    private InetAddress m_Group;
    private int m_Port;
    private int m_TTL;
    private byte[] m_Buffer;
    private long m_TotalPackets = 0L;
    private long m_TotalBytes = 0L;

    public MulticastSender(String in_Group, int in_Port, int in_PSize, int in_TTL) {
        try {
            this.m_Group = InetAddress.getByName(in_Group);
            this.m_Port = in_Port;
            this.m_Buffer = new byte[in_PSize];
            this.m_TTL = in_TTL;
            this.m_MCS = new MulticastSocket(this.m_Port);
            this.m_MCS.setTimeToLive(this.m_TTL);
            this.m_DP = new DatagramPacket(this.m_Buffer, this.m_Buffer.length, this.m_Group, this.m_Port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            this.m_MCS.send(this.m_DP);
            ++this.m_TotalPackets;
            this.m_TotalBytes += (long)this.m_Buffer.length;
        }
        catch (Exception e) {
            this.m_MCS.close();
            e.printStackTrace();
        }
    }

    public long getTotalPackets() {
        return this.m_TotalPackets;
    }

    public long getTotalBytes() {
        return this.m_TotalBytes;
    }
}

