/* BootLogo installer */

if RxFuncQuery('SysLoadFuncs') then do
	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs
end

logoFile = 'FIGHT.LGO'
parse arg target optstr
target = translate(target)
targetLen = length(target)
targetTop = substr(target, 1, 1)
targetEnd = substr(target, 2, 1)
target = target || '\OS2LOGO'
optstr = translate(optstr)

say
say '== BootLogo installer ======================'
say


if targetLen = 2 & targetEnd = ':' & pos(targetTop, xrange('A', 'Z')) \= 0
then do
  if pos('/U', optstr) \= 0 then do
    '@attrib -s -h -r ' || target || '.BAK 1>NUL 2>NUL'
    if stream(target || '.BAK', 'c', 'query exists') = '' then do
      say 'ERROR: ' || target || '.BAK is not exists.'
      call DisplayUsage
    end
    else do
      say target || ' will be restored from ' || target || '.BAK.'
      say
      do forever
        call charout ,'Continue[Y/N]? '
        resp = linein()
        if translate(resp) = 'Y' then do
          '@attrib -s -h -r ' || target || ' 1>NUL 2>NUL'
          '@copy ' || target || '.BAK ' || target || ' 1>NUL 2>NUL'
          '@attrib +s +h +r ' || target || '.BAK 1>NUL 2>NUL'
          '@attrib +s +h +r ' || target || ' 1>NUL 2>NUL'
          say
          say target || ' has been restored.'
          say
          call beep 440, 100
          call beep 660, 100
          leave
        end
        if translate(resp) = 'N' then do
          say
          say 'Abandon.'
          say
          '@attrib +s +h +r ' || target || '.BAK 1>NUL 2>NUL'
          leave
        end
      end
    end
  end
  else do
    '@attrib -s -h -r ' || target || ' 1>NUL 2>NUL'
    if stream(target, 'c', 'query exists') = '' then do
      say 'ERROR: ' || target || ' is not exists.'
      call DisplayUsage
    end
    else do
      say target || ' will be replaced with ' || logoFile
      say '(Current' || target || ' will be kept as ' || target || '.BAK.)'
      say
      do forever
        call charout ,'Continue[Y/N]? '
        resp = linein()
        if translate(resp) = 'Y' then do
          '@copy ' || target || ' ' || target || '.BAK 1>NUL 2>NUL'
          '@attrib +s +h +r ' || target || '.BAK 1>NUL 2>NUL'
          '@copy ' || logoFile || ' ' || target || ' 1>NUL 2>NUL'
          '@attrib +s +h +r ' || target || ' 1>NUL 2>NUL'
          say
          say target || ' has been replaced.'
          say
          call beep 440, 100
          call beep 660, 100
          leave
        end
        if translate(resp) = 'N' then do
          say
          say 'Abandon.'
          say
          '@attrib +s +h +r ' || target || ' 1>NUL 2>NUL'
          leave
        end
      end
    end
  end
end
else call DisplayUsage
say
say '== End of BootLogo installer ==============='
say
return

DisplayUsage:
  say 'Please specify correct OS/2 system drive letter with colon.'
  say 'example:'
  say '  instlogo C:      (change BootLogo drive C:)'
  say '  instlogo C: /u   (restore to original BootLogo on C:)'
  say
  return
