/* Assign eComStation-style folder icons to the Lotus SmartSuite main folder */

CALL RxFuncAdd 'SysBootDrive','RexxUtil','SysBootDrive'
CALL RxFuncAdd 'SysSetObjectData','RexxUtil','SysSetObjectData'

errors=0

IF RxFuncQuery('SysBootDrive')<>0 THEN DO
   errors=errors+1
   SAY 'Error: cannot load REXXUTIL.DLL-function SysBootDrive()'
END
IF RxFuncQuery('SysSetObjectData')<>0 THEN DO
   errors=errors+1
   SAY 'Error: cannot load REXXUTIL.DLL-function SysSetObjectData()'
END

path=SysBootDrive()||'\ecs\ICONS\'
file1=path||'LOTUSFCL.ICO'
file2=path||'LOTUSFOP.ICO'

IF Stream(file1,'C','QUERY EXISTS')='' THEN DO
   errors=errors+1
   SAY 'Error: cannot find file' file1
END
IF Stream(file2,'C','QUERY EXISTS')='' THEN DO
   errors=errors+1
   SAY 'Error: cannot find file' file2
END

IF errors>0 THEN DO
   SAY 'Error: cannot assign new folder icons to the Lotus SmartSuite folder.'
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END

IF SysSetObjectData('<LOTSUITE97>','ICONFILE='||file1||';ICONNFILE=1,'||file2)>0 THEN DO
   SAY 'New folder icons assigned to the Lotus SmartSuite folder.'
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END

SAY 'Error: SysSetObjectData() cannot assign new folder icons to' 
SAY '       the Lotus SmartSuite folder.'
CALL CharOut '','Press <ENTER>... '
PULL .

EXIT
