/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_icon.cpp,v 1.4 2001/05/31 05:39:07 glass Exp $
 */

#include "ic_icon.h"

ICIconList ICIconList::icon_list;

/*------------------------------------------------------------------
 * Constructs the empty generic icon
 *------------------------------------------------------------------*/
ICIcon::ICIcon()

: ico_clr_map (   ),
  ico_clr_pal (   ),
  ico_xor_map (   ),
  ico_and_map (   ),
  ico_xhotspot( 0 ),
  ico_yhotspot( 0 )
{}

/*------------------------------------------------------------------
 * Constructs the generic icon
 *------------------------------------------------------------------*/
ICIcon::ICIcon( size_type width, size_type height, size_type bits_per_pixel )

: ico_clr_map ( width, height, bits_per_pixel ),
  ico_xor_map ( width, height  ),
  ico_and_map ( width, height  ),
  ico_clr_pal ( bits_per_pixel ),
  ico_xhotspot( width /2 ),
  ico_yhotspot( height/2 )
{}

/*------------------------------------------------------------------
 * Constructs the generic icon from another icon object
 *------------------------------------------------------------------*/
ICIcon::ICIcon( const ICIcon& icon )

: ico_clr_map ( icon.ico_clr_map  ),
  ico_clr_pal ( icon.ico_clr_pal  ),
  ico_xor_map ( icon.ico_xor_map  ),
  ico_and_map ( icon.ico_and_map  ),
  ico_xhotspot( icon.ico_xhotspot ),
  ico_yhotspot( icon.ico_yhotspot )
{}

/*------------------------------------------------------------------
 * Destructs the generic icon
 *------------------------------------------------------------------*/
ICIcon::~ICIcon() {}

/*------------------------------------------------------------------
 * Assignment operator
 *------------------------------------------------------------------*/
ICIcon& ICIcon::operator=( const ICIcon& icon )
{
  if( &icon != this )
  {
    ico_clr_map  = icon.ico_clr_map;
    ico_clr_pal  = icon.ico_clr_pal;
    ico_xor_map  = icon.ico_xor_map;
    ico_and_map  = icon.ico_and_map;
    ico_xhotspot = icon.ico_xhotspot;
    ico_yhotspot = icon.ico_yhotspot;
  }

  return *this;
}

/*------------------------------------------------------------------
 * Constructs the icons list
 *------------------------------------------------------------------*/
ICIconList::ICIconList()
{
  lst_icons = 0;
  lst_size  = 0;
}

/*------------------------------------------------------------------
 * Destructs the icons list
 *------------------------------------------------------------------*/
ICIconList::~ICIconList()
{
  delete[] lst_icons;
}

/*------------------------------------------------------------------
 * Inserts the icon as the last item in the list
 *------------------------------------------------------------------*/
void ICIconList::push_back( const ICIcon& icon )
{
  ICIcon* new_list = new ICIcon[lst_size+1];
  ICIcon* old_list = lst_icons;
  size_type i;

  for( i = 0; i < lst_size; i++ )
    new_list[i] = old_list[i];

  new_list[i] = icon;
  lst_icons   = new_list;
  lst_size   += 1;

  delete[] old_list;
}

/*------------------------------------------------------------------
 * Removes all icons from the list
 *------------------------------------------------------------------*/
void ICIconList::clear()
{
  lst_icons = 0;
  lst_size  = 0;
  delete[] lst_icons;
}
