/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_chlist.h,v 1.2 2002/06/23 14:01:13 glass Exp $
 */

/**@#-*/
#ifndef IC_CHLIST_H
#define IC_CHLIST_H
/**@#+*/

/**
 * Icon Plus character strings list.
 *
 * The ICIconList class creates and manages a character strings list.
 * @author Dmitry A Steklenev
 */

class ICChList
{
  public:
    /** An unsigned integral type. */
    typedef unsigned long size_type;

  public:
    /** Constructs the strings list. */
    ICChList();
    /** Destructs strings list. */
   ~ICChList();

  public:
    /** Iterator used to iterate over the strings. */
    typedef char** iterator;
    /** Returns an iterator pointing to the beginning of the strings list. */
    iterator  begin() const;
    /** Returns an iterator pointing to the end of the strings list. */
    iterator  end  () const;
    /** Returns the number of strings stored in the list. */
    size_type count() const;

    /** Inserts the strings as the last item in the list. */
    void push_back( const char* strings );

  private:
    char**    lst_strings;
    size_type lst_size;
};

/*------------------------------------------------------------------
 * Returns an iterator pointing to the beginning of the strings list
 *------------------------------------------------------------------*/
inline ICChList::iterator ICChList::begin() const
{
  return lst_strings;
}

/*------------------------------------------------------------------
 * Returns an iterator pointing to the end of the strings list
 *------------------------------------------------------------------*/
inline ICChList::iterator ICChList::end() const
{
  return lst_strings + lst_size;
}

/*------------------------------------------------------------------
 * Returns the number of strings stored in the list
 *------------------------------------------------------------------*/
inline ICChList::size_type ICChList::count() const
{
  return lst_size;
}

/**@#-*/
#endif
