/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_config.h,v 1.5 2002/06/23 14:01:13 glass Exp $
 */

/**@#-*/
#ifndef IC_CONFIG_H
#define IC_CONFIG_H
/**@#+*/

typedef unsigned char      BYTE;   //@- A byte.
typedef unsigned short int UINT16; //@- 16-bit unsigned integer in the range 0 through 65 535.
typedef unsigned long int  UINT32; //@- 32-bit unsigned integer in the range 0 through 4 294 967 295.
typedef short int          INT16;  //@- 16-bit signed integer in the range -32 768 through 32 767.
typedef int                INT32;  //@- 32-bit signed integer in the range -2 147 483 648 through 2 147 483 647.

#if defined(__EMX__) || defined(__IBMCPP__) || defined(__BORLANDC__)
  #define IC_FOPEN_BWRITE "wb"
  #define IC_FOPEN_BREAD  "rb"
#else
  /** 
   * Defines mode for opening a binary file for reading 
   * via <i>fopen</i> function. 
   */

  #define IC_FOPEN_BWRITE "w"

  /** 
   * Defines mode for creating an empty binary file 
   * for writing via <i>fopen</i> function. 
   */

  #define IC_FOPEN_BREAD  "r"
#endif

#if defined(__TOS_OS2__) || defined(__TOS_WIN__)
  #define IC_PC '\\'
  #define IC_PS "\\"
#else
  /** Defines path separator character. */
  #define IC_PC '/'
  /** Defines path separator string. */
  #define IC_PS "/"
#endif

/** Defines known icons types. */

enum icon_type { unknown, /* Unknown format           */
                 os2_v12, /* OS/2 v1.2  icons format  */
                 os2_v20, /* OS/2 v2.0  icons format  */
                 win_ico, /* MS Windows icons format  */
                 win_icl  /* MS Windows icons library */
               };

extern int load_dump; //@- Enables dump of all loaded structures.
extern int maps_dump; //@- Enables dump of all loaded bitmaps.

/**@#-*/
#endif
