/* thumbkin - jpg thumbnail index page creator */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
  
ARG configfile
if configfile='' then
	signal syntax

/* read seq control file */
inputdir=linein(configfile)  /* location of photos to be thumbed */
seqfile=linein(configfile)     /* sequence control file */
indexname=linein(configfile)  /* location and name of thumbnail page */
url=linein(configfile)          /* url to be prefixed to paths to images and thumbs */
across=linein(configfile)      /* images across on the index page */
thumbsize=linein(configfile)  /* geometry of generated thumbs */
description=linein(configfile) /* description of index page (for html) */
footyn=linein(configfile) /* Y/N for footer include */


rc = stream(configfile,'c','query exists')
if rc = '' then do
   say 'no such config file!'
   exit

end /* do */

if right(inputdir,1)<>'\' then inputdir=inputdir'\'

/* assemble path & filenames of images to be thumbed */
count=1
do while lines(seqfile)>0
   w=linein(seqfile)
   p=pos('~',w)
   filename=left(w,p-1)
   say filename'*'
   files.count.1=inputdir''filename
   w=delstr(w,1,p)
   files.count.3=w
   files.count.4=filename
   files.count.2=inputdir'thmb_'filename
   files.count.5=url''filename

/*  set up the html wrapper files for the fullsize images and descriptions */
   w=files.count.1
   p=pos('.',w)
   htmlfilename=left(w,p)
   htmlfilename=htmlfilename'html'
   say htmlfilename'*'
   'del 'htmlfilename
   rc=lineout(htmlfilename,'<!-- HTML wrapper, generated automatically by Thumbkin/2 -->')
   rc=lineout(htmlfilename,'<HTML>')
   rc=lineout(htmlfilename,'<BODY>')
   rc=lineout(htmlfilename,'<CENTER>')
   rc=lineout(htmlfilename,'<BR><BR><Img Border=6 Align=Top Src="'files.count.4'"><BR><BR><BR>'files.count.3)

   rc=lineout(htmlfilename,'</CENTER>')
   rc=lineout(htmlfilename,'</BODY>')
   rc=lineout(htmlfilename,'</HTML>')

   w=files.count.4
   p=pos('.',w)
   htmlfilename=left(w,p)
   htmlfilename=htmlfilename'html'
	 files.count.6 = url''htmlfilename


/*  Wrappers done */

   count=count+1
end /* do */
count=count-1
say count

/* files.x.1 inputfilename (w/path)  */
/* files.x.2 outputfilename (w/path)  */
/* files.x.3 description  */
/* files.x.4 output filename w/o path */
/* files.x.5 url form of image filename */
/* files.x.6 url form of html wrapper for fullsize images & descriptions */

do t = 1 to count
	'montage -geometry 'thumbsize' +shadow +frame jpeg:'files.t.1 'jpeg:'files.t.2
end

'del 'indexname
rc = stream(indexname,'c','open')

if rc <> 'READY:' then do
	say 'create/open of 'indexname' failed - check config file!'
 exit
end /* do */

rc=lineout(indexname,'<!doctype html public>',1)
rc=lineout(indexname,'<!-- Generated by Thumbkin/2 - Version .1 -->')
rc=lineout(indexname,'<!-- Most recent revision: 'date()'. -->')
rc=lineout(indexname,'<Html>')
rc=lineout(indexname,'<Head>')
rc=lineout(indexname,'   <Meta Name="Generator" Content="Thumbkin/2">')
rc=lineout(indexname,'   <meta name="description" content="'description'">')
rc=lineout(indexname,'   <Title>'Description'</Title>')
rc=lineout(indexname,'</Head>')
rc=lineout(indexname,'<BaseFont Size=3>')
rc=lineout(indexname,'<P Align=Center>')
rc=lineout(indexname,'<CENTER><H1>'Description'</H1><BR>')
rc=lineout(indexname,'Please click on an image to see the full sized version.</CENTER><BR>')
rc=lineout(indexname,'<TABLE BORDER ALIGN=CENTER>')

/* account for partial rows */
rows=count%across
xrows=count//across
if xrows>0 then rows=rows+1


do x =0 to rows-1
rc=lineout(indexname,'<TR>')
do y = 1 to across
rc=lineout(indexname,'<TD>')
w=(x*across)+y
if w<= count then
   rc=lineout(indexname,'<A Href="'files.w.6'"><Img Border=0 Src="'url'thmb_'files.w.4'"></A><Br>')
else
   rc=lineout(indexname,' <Br>')

rc=lineout(indexname,'</TD>')
end /* do t */

rc=lineout(indexname,'</TR>')
end /* do rows */


rc=lineout(indexname,'</TABLE>')
rc=lineout(indexname,'<BR>')
rc=lineout(indexname,'<BR>')
rc=lineout(indexname,'<BR>')
if footyn='y' then rc=lineout(indexname,'<!--#include file="footer.shtml" -->')
rc=lineout(indexname,'</BODY')
rc=lineout(indexname,'</HTML>')
rc=stream(indexname,'c','close')
call syscls
say ''
say ''
say 'Thumbnails created'
say 'index page is 'indexname
exit





syntax:

say 'oops'

