/* Rexx */
/* MakeTexPK */

/* checks, if the requested font is in psfonts.map */
/* and calls gsftopk.exe			   */
/* if not,					   */
/* creates a mfjob file and runs mfjob             */

/* Change this */
/* Default mode is the mode to use with mfjob, if you don't know it, let dvipm create
a mfjob file and have a look into */
defaultmfmode="laserjet"

/* fontsubdir is the subdirectory of %dvidrvfonts% where mfjobs stores the fonts */
font_subdir="pixel.lj"

/* mapfile is the path to your psfont.map file */
mapfile='f:\emtex\data\dvips\psfonts.map'

/* End of required changes, hopefully */




'@echo off'
address cmd
tmpfile="xdvi.mfj"
env="OS2ENVIRONMENT"


parse arg name  newres basres dummy mfmode
if mfmode="" then mfmode=defaultmfmode

'if not exist %DVIDRVFONTS% mkdir %DVIDRVFONTS%'
'if not exist %DVIDRVFONTS%\'font_subdir' mkdir %DVIDRVFONTS%\'font_subdir

mag=(newres/basres)

do forever
	if lines(mapfile)=0 then leave
	line=linein(mapfile)
	if word(line,1)=name then do
		'gsftopk 'name newres
    'if not exist %DVIDRVFONTS%\'font_subdir'\'newres'dpi mkdir %DVIDRVFONTS%\'font_subdir'\'newres'dpi'
    'cp 'name'.'newres'pk %DVIDRVFONTS%\'font_subdir'\'newres'dpi\'name'.pk'
 		'rm 'name'.'newres'pk'
 		exit
	end
end



rc=lineout(tmpfile,"input [dvidrv];")
rc=lineout(tmpfile,"{")
rc=lineout(tmpfile,"driver=xdvi;")
rc=lineout(tmpfile,"mode="||mfmode||"["||basres||" "||basres"];")
rc=lineout(tmpfile,"output=pk[$DVIDRVFONTS:"||font_subdir||"\@Rrdpi\@f{.pk,.pxl}];")
rc=lineout(tmpfile,"{font="||name||"; mag="||mag||";}")
rc=lineout(tmpfile,"}")
rc=stream(tmpfile,"C","CLOSE")

'mfjob /3 'tmpfile
'if exist 'tmpfile 'del 'tmpfile

exit

