#define INCL_WIN
#define INCL_GPI
#define VERTICES 4

#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "..\savers.h"
#include "banner.h"
#include "..\wpslib.h"

#define MinorTickSpacing  0
#define MinorTickSize     0
#define MajorTickSpacing  1 
#define MajorTickSize     5
#define TextSpacing       2


typedef struct set_t
	{
	SHORT Foreground;
	SHORT Background;
    CHAR szFamilyName[FACESIZE];
	CHAR Text[256];
	LONG TextLength;
	SHORT Speed;
    FONTDLG fdFontDlg;
    BOOL FontSet;
	}settings;


POINTL TextPosition, maxptl, TextBox[TXTBOX_COUNT];
RECTL rcl={{0},{0},{0},{0}};
settings Set;

MRESULT EXPENTRY __export SaverProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	HPS hps;
    static SIZEF sizef;
    static PFNWP OldSaverProc;

	switch(msg)
	{
    		case UM_INIT_SAVER: 
			OldSaverProc = (PFNWP)mp2;
      		if(!FindSettings(WinQueryAnchorBlock(hwnd), hwnd, (ULONG)sizeof(settings), &Set, "BANNER", "MESSAGE"))
        	{
        		Set.Background =CLR_BLACK;
        		Set.Foreground =CLR_YELLOW;
        		Set.Speed = -5;
        		strcpy(&(Set.Text), "For God so loved the world, he gave his only begotten Son...");
			    Set.TextLength = strlen(Set.Text);
        	}
 			sizef.cy = sizef.cx = MAKEFIXED(Set.fdFontDlg.lEmHeight,0);
            rcl.yTop = maxptl.y = SHORT2FROMMP(mp1);
			rcl.xRight = TextPosition.x = maxptl.x = SHORT1FROMMP(mp1);
			hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
			GpiQueryTextBox(hps, Set.TextLength, Set.Text, TXTBOX_COUNT, TextBox);
			GpiConvert(hps, CVTC_WORLD, CVTC_DEVICE, TXTBOX_COUNT, TextBox);
            WinFillRect(hps, &rcl, Set.Background);
            WinEndPaint(hps);
            TextPosition.y=rand()%(maxptl.y-(Set.fdFontDlg.lEmHeight*2))+ Set.fdFontDlg.lEmHeight; 
			rcl.yBottom = TextPosition.y - Set.fdFontDlg.lEmHeight;
			rcl.yTop =TextPosition.y + Set.fdFontDlg.lEmHeight;
        return(0);

		case WM_PAINT:
			hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
			            if((TextPosition.x += Set.Speed) < (0-TextBox[3].x<<1))
						{
							TextPosition.x = maxptl.x;
			                TextPosition.y=rand()%(maxptl.y-(Set.fdFontDlg.lEmHeight*2))+ Set.fdFontDlg.lEmHeight;
							rcl.yBottom = TextPosition.y -  Set.fdFontDlg.lEmHeight;
							rcl.yTop =TextPosition.y +  Set.fdFontDlg.lEmHeight;
      					}
						else if(TextPosition.x > (maxptl.x-(TextBox[3].x<<1)))
						{
							GpiSetCharBox(hps, &sizef);
							GpiCreateLogFont(hps, NULL, 10L, &(Set.fdFontDlg.fAttrs));
							GpiSetCharSet(hps, 10L);
							GpiSetColor(hps, Set.Foreground);
							rcl.xLeft = TextPosition.x;
							rcl.xRight = TextPosition.x + (TextBox[3].x<<1);
							WinFillRect(hps, &rcl, Set.Background);
							/*get rid of the sprintf in the next statement*/
							GpiCharStringPosAt(hps, &TextPosition, NULL, 0L, Set.TextLength, Set.Text, NULL);
							GpiSetCharSet(hps, LCID_DEFAULT);
							GpiDeleteSetId(hps, 10L);
						}
						else
						{
         					rcl.xLeft=0;
							WinScrollWindow(hwnd, Set.Speed, 0, &rcl, NULL, NULLHANDLE , NULL, NULL);
						}
                        WinEndPaint(hps);
		return(0);


		case UM_KILL_SAVER:
        default:
	    return OldSaverProc(hwnd, msg, mp1, mp2);
    }
}


MRESULT EXPENTRY __export SetupProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	ULONG ulValue;
    HPS hpsScreen;
    HWND hwndFontDlg;

	switch(msg)
	{
		case WM_INITDLG:
 			if(!FindSettings(WinQueryAnchorBlock(hwnd), hwnd, (ULONG)sizeof(settings), (PVOID)&Set, "BANNER", "MESSAGE"))
   			{
        		Set.Background =CLR_BLACK;
        		Set.Foreground =CLR_YELLOW;
        		Set.Speed = -5;
        		strcpy(&(Set.Text), "For God so loved the world, he gave his only begotten Son...");
			    Set.TextLength = strlen(Set.Text);
        	}
			WinSendDlgItemMsg(hwnd, TID_MESSAGE, EM_SETTEXTLIMIT, MPFROM2SHORT(256,0), NULL);
			WinSetDlgItemText(hwnd, TID_MESSAGE, (PSZ)Set.Text);
			InitSlider (hwnd, SDID_SPEED,9,MinorTickSpacing,MinorTickSize, MajorTickSpacing,MajorTickSize, TextSpacing);
			WinSendMsg(WinWindowFromID(hwnd, SDID_SPEED), SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE),MPFROMSHORT(-1*Set.Speed));
			WinSendDlgItemMsg(hwnd, Set.Background+200, BM_SETCHECK, (MPARAM)TRUE, (MPARAM)NULL);
			WinSendDlgItemMsg(hwnd, Set.Foreground+300, BM_SETCHECK, (MPARAM)TRUE, (MPARAM)NULL);
			WinShowWindow(hwnd, TRUE);
		return(0);

		case WM_CONTROL:
			ulValue = SHORT1FROMMP(mp1);
			if((ulValue >= RID_SWHITE) && (ulValue <= RID_SYELLOW))
			{
				WinSendDlgItemMsg(hwnd, Set.Background+200, BM_SETCHECK, FALSE, NULL);
				Set.Background = ulValue - 200;
				WinSendDlgItemMsg(hwnd, Set.Background+200, BM_SETCHECK, (MPARAM)TRUE, (MPARAM)NULL);
			}
			if((ulValue >= RID_FWHITE) && (ulValue <= RID_FYELLOW))
			{
				WinSendDlgItemMsg(hwnd, Set.Foreground+300, BM_SETCHECK, FALSE, NULL);
				Set.Foreground = ulValue - 300;
				WinSendDlgItemMsg(hwnd, Set.Foreground+300, BM_SETCHECK, (MPARAM)TRUE, (MPARAM)NULL);
			}
			
		return(0);

		case WM_COMMAND:
			switch(SHORT1FROMMP(mp1))
			{
				case DID_FONT:
					hpsScreen = WinGetPS(hwnd);
					if(!Set.FontSet)
					{
						memset(&(Set.fdFontDlg), 0, sizeof(FONTDLG));
						Set.fdFontDlg.cbSize = sizeof(FONTDLG);
						Set.fdFontDlg.usFamilyBufLen = FACESIZE;
						Set.fdFontDlg.fl = FNTS_INITFROMFATTRS | FNTS_HELPBUTTON | FNTS_CENTER;
						Set.fdFontDlg.fAttrs.usCodePage = 437;
						Set.FontSet = TRUE;
					}
					Set.fdFontDlg.pszFamilyname = Set.szFamilyName;
					Set.fdFontDlg.hpsScreen = hpsScreen;
					Set.fdFontDlg.pszPreview = Set.Text;
					Set.fdFontDlg.clrFore = Set.Foreground;
					Set.fdFontDlg.clrBack = Set.Background;
					Set.fdFontDlg.fAttrs.fsFontUse = FATTR_FONTUSE_NOMIX;
                                                
					hwndFontDlg = WinFontDlg(HWND_DESKTOP, hwnd, &(Set.fdFontDlg));
					if(hwndFontDlg && (Set.fdFontDlg.lReturn == DID_OK))
					{
						strcpy(Set.szFamilyName, Set.fdFontDlg.pszFamilyname);
					}
					WinDestroyWindow(hwndFontDlg);
					WinReleasePS(hpsScreen);
				return(0);

				case DID_OK:
					Set.Speed = -1*(SHORT) WinSendDlgItemMsg(hwnd, SDID_SPEED, SLM_QUERYSLIDERINFO,MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), NULL);
					if(!Set.Speed) Set.Speed= (-1);
                    Set.TextLength = WinQueryDlgItemTextLength(hwnd, TID_MESSAGE);
					WinQueryDlgItemText(hwnd, TID_MESSAGE, Set.TextLength+1, Set.Text);
                    if(!WriteSettings((WinQueryAnchorBlock(hwnd)), hwnd, (ULONG)sizeof(settings), (PVOID)&Set, "BANNER", "MESSAGE"))
                    {
                         	WinMessageBox(HWND_DESKTOP, hwnd, "An error occured writing to the initialization file.", "WPSaver", 0, MB_OK|MB_ICONEXCLAMATION);
                            if(!WinQueryWindowPtr(hwnd, 0))
                                          exit(0);
                    }                           
				case DID_CANCEL:
					WinDismissDlg(hwnd, TRUE);
				return(0);
			
			}
		break;
	}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
