--- Makefile.org	Fri Mar 29 13:53:36 2002
+++ Makefile	Fri Mar 29 13:55:10 2002
@@ -8,8 +8,13 @@
 
 CC       = gcc
 CFLAGS   = -O2 -Wall
-INCLUDES = -I$(shell pwd)
+#X11DIR   = /usr/X11R6
+X11DIR   = /XFree86
+INCLUDES = -I.
 LDLIBS   =
+OS2EXE   = 
+OS2BIND  = echo
+
 
 PREFIX   = /usr/local
 EPREFIX  = $(PREFIX)
@@ -26,8 +31,8 @@
 SSL_LIBS =
 
 #the xlib layer ( default )
-GUI_XWIN_INC = -I/usr/X11R6/include
-GUI_XWIN_LIB = -L/usr/X11R6/lib -lX11
+GUI_XWIN_INC = -I$(X11DIR)/include
+GUI_XWIN_LIB = -L$(X11DIR)/lib -lX11
 GUI_XWIN_OBJ = gl/xwin.o
 
 #the nt layer
@@ -44,8 +49,10 @@
 GUI_LIBS = ${GUI_XWIN_LIB}
 GUI_OBJ = ${GUI_XWIN_OBJ}
 
-OS = $(shell uname -s)
-MACH = $(shell uname -m)
+OS       = OS2
+MACH     = i386	
+#OS = $(shell uname -s)
+#MACH = $(shell uname -m)
 
 # add architecture specific stuff here.
 ifeq "$(MACH)" "ppc"
@@ -53,6 +60,14 @@
 endif
 
 # add system dependent libs etc
+
+ifeq "$(OS)" "OS2"
+LDLIBS += -lX11 -lsocket -L$(X11DIR)/lib
+OS2EXE   = rdesktop.exe tests\endian.exe
+OS2BIND  = emxbind -b -w
+CFLAGS += -Zcrtdll -Zmtd -D__ST_MT__ERRNO__ -DGUI_XWIN
+endif
+
 ifeq "$(OS)" "UnixWare"
 LDLIBS += -l socket
 endif
@@ -90,19 +105,22 @@
 endif
 
 
-include Makeconf  # local configuration
+#include Makeconf  # local configuration
 
 all:	localendian.h rdesktop
 
 localendian.h: endian
 	rm -f localendian.h
-	./tests/endian > localendian.h
+#	./tests/endian > localendian.h
+	.\tests\endian > localendian.h
 
 endian: tests/endian.c
 	$(CC) -o tests/endian tests/endian.c
+	$(OS2BIND) tests/endian
 
 rdesktop: $(RDPOBJ) $(SSL_OBJ) ${GUI_OBJ} ${GNUOBJ}
 	$(CC) $(CFLAGS) -o rdesktop $(RDPOBJ) $(SSL_OBJ) $(LDDIRS) $(LDLIBS) ${GNUOBJ} ${GUI_OBJ} ${GUI_LIBS} ${SSL_LIBS}
+	$(OS2BIND) rdesktop
 
 rdp-srvr: $(RDPSOBJ) ${SSL_OBJ} ${GUI_OBJ} $(GNUOBJ)
 	$(CC) $(CFLAGS) -o rdp-srvr $(RDPSOBJ) $(SSL_OBJ) $(LDDIRS) $(LDLIBS) ${GNUOBJ} ${GUI_OBJ} ${GUI_LIBS}  ${SSL_LIBS}
@@ -132,7 +150,7 @@
 clean:
 	rm -f tests/endian localendian.h *.o gnu/*.o *.out crypto/*.o rdesktop rdp-srvr core
 	rm -f crypto/*~ gnu/*~ tests/*~ *~ gl/*~ gl/ntxlib/*~
-	rm -f gl/*.o
+	rm -f gl/*.o $(OS2EXE)
 
 rdp-srvr.o: rdesktop.c
 	$(CC) $(CFLAGS) -DSERVER -o $@ -c $<
--- rdesktop.h.org	Fri Mar 29 13:53:42 2002
+++ rdesktop.h	Fri Mar 29 13:55:10 2002
@@ -77,6 +77,13 @@
 #include "proto.h"
 #endif
 
+#ifdef __EMX__
+#define strcasecmp stricmp
+#define strncasecmp strnicmp
+#include <sys/select.h>
+unsigned long DosError (unsigned long ulError);
+#endif
+
 #ifdef WITH_DEBUG_LEAKS
 #define xmalloc(size) xmalloc2(__LINE__, ##__FILE__, size)
 #define xrealloc(mem, size) xrealloc2(__LINE__, ##__FILE__, mem, size)
--- rdesktop.c.org	Fri Mar 29 13:53:42 2002
+++ rdesktop.c	Fri Mar 29 13:55:10 2002
@@ -28,6 +28,11 @@
 #endif
 #include <fcntl.h>		/* open */
 #include <pwd.h>		/* getpwuid */
+#ifdef __EMX__
+#include <sys/types.h>         /* required by stat.h */
+#include <netdb.h>             /* gethostname */
+#include <termios.h>
+#endif
 #include <sys/stat.h>		/* stat */
 #include <sys/time.h>		/* gettimeofday */
 #include <sys/times.h>		/* times */
@@ -188,6 +193,9 @@
 	int c;
 	int option_index = 0;
 
+#ifdef __EMX__
+	DosError(0L); /* Suppress annoying popup error windows. */
+#endif
 	STATUS("rdesktop: A Remote Desktop Protocol client.\n");
 	STATUS("Version " VERSION ". Copyright (C) 1999-2001 Matt Chapman.\n");
 	STATUS("See http://www.rdesktop.org/ for more information.\n");
@@ -213,7 +221,22 @@
 				/* Read password from terminal or stdin */
 				if (isatty(fileno(stdin))) {
 					char *pw;
+#ifdef __EMX__
+			 		struct termios termios;
+
+ 				if (!tcgetattr(STDIN_FILENO,&termios))
+		 		{
+ 					tcflag_t lflag=termios.c_lflag;
+		 			termios.c_lflag&=~ECHO;
+ 					tcsetattr(STDIN_FILENO,TCSANOW,&termios);
+		 			pw = _getpass2("Password: ",0);
+		 			termios.c_lflag=lflag;
+		 			tcsetattr(STDIN_FILENO,TCSANOW,&termios);
+		 		} else
+			 		pw =_getpass2("Password: ",0);
+#else
 					pw = getpass("Password: ");
+#endif
 					password =
 					    (char *) xmalloc(strlen(pw) + 1);
 					strcpy(password, pw);
--- tcp.c.org	Fri Mar 29 13:53:44 2002
+++ tcp.c	Fri Mar 29 13:55:10 2002
@@ -19,6 +19,9 @@
 */
 
 #include <unistd.h>		/* select read write close */
+#ifdef __EMX__
+#include <sys/types.h>	/* required by socket.h */
+#endif
 #include <sys/socket.h>		/* socket connect setsockopt */
 #include <sys/time.h>		/* timeval */
 #include <netdb.h>		/* gethostbyname */
--- gnu\getopt.c.org	Fri Mar 29 13:53:40 2002
+++ gnu\getopt.c	Fri Mar 29 13:55:10 2002
@@ -75,6 +75,10 @@
 #endif
 #endif
 
+#ifdef __EMX__
+#include <string.h>
+#endif
+
 #if defined (WIN32) && !defined (__CYGWIN32__)
 /* It's not Unix, really.  See?  Capital letters.  */
 #include <windows.h>
