Unit AllKeys;

(**********************************************************************

 Direct Keyboard Readout

 Features:
 - detect press of shift, ctrl, caps etc.
 - detect how long keys are pressed
 - detect simultaneous press of many keys

 Limitations of keyboard controller:
 - number of simultaneous keys in one row is limited
 - pause key remains active until another key is pressed

**********************************************************************)


INTERFACE

uses
  dos, crt,
  TrapInt;

type
  string10 = string[10];

var
  KeyChange : boolean;
  lastkey : byte;

var
  KeyData1  : array [1..$5F] of boolean;
const
  KeyName1  : array [1..$5F] of string10 =
             ('Esc','1','2','3','4','5','6','7','8','9','0','-','=','Back',
              'Tab','Q','W','E','R','T','Y','U','I','O','P','[',']','Enter',
              'CtrlLeft','A','S','D','F','G','H','J','K','L',';','"','\',
              'ShiftLeft','\','Z','X','C','V','B','N','M',',','.','/',
              'ShiftRight','Pad*','AltLeft','Space','Caps',
              'F1','F2','F3','F4','F5','F6','F7','F8','F9','F10',
              'Num','Scroll',
              'Pad7','Pad8','Pad9','Pad-',
              'Pad4','Pad5','Pad6','Pad+',
              'Pad1','Pad2','Pad3','Pad0','Pad.',
               '','','\','F11','F12','','','','','','','');
var
  KeyData2  : array [1..$5F] of boolean;
const
  KeyName2  : array [1..$5F] of string10 =
             ('','','','','','','','','','','','','','',
              '','','','','','','','','','','','','','PadEnter',
              'CtrlRight','','','','','','','','','','','','',
              '','','','','','','','','','','','Pad/',
              '','Print','AltRight','','',
              '','','','','','','','','','',
              'Pause','',
              'Home','Up','PgUp','',
              'Left','','Right','',
              'End','Down','PgDn','Ins','Del',
              '','','','','','','','','','','','');


const
 KeyCodeEsc  = 1; KeyCodeTab    =15; KeyCodeCtrlLeft  =29; KeyCodeShiftLeft =42;
 KeyCode1    = 2; KeyCodeQ      =16; KeyCodeA         =30; KeyCodeBackSlashL=43;
 KeyCode2    = 3; KeyCodeW      =17; KeyCodeS         =31; KeyCodeZ         =44;
 KeyCode3    = 4; KeyCodeE      =18; KeyCodeD         =32; KeyCodeX         =45;
 KeyCode4    = 5; KeyCodeR      =19; KeyCodeF         =33; KeyCodeC         =46;
 KeyCode5    = 6; KeyCodeT      =20; KeyCodeG         =34; KeyCodeV         =47;
 KeyCode6    = 7; KeyCodeY      =21; KeyCodeH         =35; KeyCodeB         =48;
 KeyCode7    = 8; KeyCodeU      =22; KeyCodeJ         =36; KeyCodeN         =49;
 KeyCode8    = 9; KeyCodeI      =23; KeyCodeK         =37; KeyCodeM         =50;
 KeyCode9    =10; KeyCodeO      =24; KeyCodeL         =38; KeyCodeComma     =51;
 KeyCode0    =11; KeyCodeP      =25; KeyCodeColon     =39; KeyCodeDot       =52;
 KeyCodeMinus=12; KeyCodeOpenBr =26; KeyCodeDQuote    =40; KeyCodeSlash     =53;
 KeyCodeEqual=13; KeyCodeCloseBr=27; KeyCodeBackSlashR=41; KeyCodeShiftRight=54;
 KeyCodeBack =14; KeyCodeEnter  =28;


 KeyCodeF1       = 59;   KeyCodePadTimes = 55;
 KeyCodeF2       = 60;   KeyCodeAltLeft  = 56;
 KeyCodeF3       = 61;   KeyCodeSpace    = 57;
 KeyCodeF4       = 62;   KeyCodeCaps     = 58;
 KeyCodeF5       = 63;
 KeyCodeF6       = 64;
 KeyCodeF7       = 65;   KeyCodeNum      = 69;
 KeyCodeF8       = 66;   KeyCodeScroll   = 70;
 KeyCodeF9       = 67;
 KeyCodeF10      = 68;


 KeyCodePad7     = 71;   KeyCodePad4   = 75;  KeyCodePad1   = 79;
 KeyCodePad8     = 72;   KeyCodePad5   = 76;  KeyCodePad2   = 80;
 KeyCodePad9     = 73;   KeyCodePad6   = 77;  KeyCodePad3   = 81;
 KeyCodePadMinus = 74;   KeyCodePadPlus= 78;  KeyCodePad0   = 82;
                                              KeyCodePadDot = 83;

 KeyCodeEmpty1   = 84;
 KeyCodeEmpty2   = 85;

 KeyCodePadSlash = 86;
 KeyCodeF11      = 87;
 KeyCodeF12      = 88;



Procedure Start;
Procedure Stop;


IMPLEMENTATION

var
  FlagE0    : boolean;
  FlagE1    : boolean;
  FlagShift : boolean;
  FlagCtrl  : boolean;
  Pause     : boolean;


procedure IntHandler (var reg:registers; var abort:boolean); FAR;
var
  key : byte;
  make: boolean;
begin
  key  := port [$60];
  KeyChange := true;
  LastKey   := key;

  if      key = $E0 then FlagE0 := true
  else if key = $E1 then FlagE1 := true

  else begin
     make := key < $80;
     key  := key and $7F;
     if pause and make then begin
        KeyData2 [$45] := false;
        pause := false;
     end;
     if FlagE0 then begin
        if key = $2A then FlagShift := Make
        else if key < $5F then KeyData2 [key] := make;
        FlagE0 := false;
     end
     else if FlagE1 then begin
        if key = $1D then FlagCtrl := Make;
        FlagE1 := false;
     end
     else if FlagShift then begin
        if key < $5F then KeyData2 [key] := make;
     end
     else if FlagCtrl then begin
       if key = $45 then begin
          KeyData2 [key] := make;
          Pause := true;
       end;
     end
     else begin
        if key < $5F then KeyData1 [key] := make
        else {unknown key};
     end;
  end;

  abort := true;
  port [$20] := $20;
end;


var
  active : boolean;

procedure start;
begin
  if active then exit;
  active := true;
  TrapInterrupt ($9, IntHandler);
  FillChar (keydata1, sizeof(keydata1), 0);
  FillChar (keydata2, sizeof(keydata2), 0);
end;

procedure stop;
begin
  if not active then exit;
  ReleaseInt;
  active := false;
end;


var
  OldExit : pointer;

Procedure MyExit; FAR;
begin
  ExitProc := OldExit;
  stop;
end;


BEGIN
  OldExit := ExitProc;
  ExitProc := @MyExit;
  Pause := false;
  active := false;
END.


