unit sprites;
{$x+}{$v-}
interface
uses crt,dos,soundlib,allkeys,XMS,strings;
type background = array[1..16,1..16]of byte;
posi = record
x1,y1,x2,y2 : integer end;
letter = array[1..8,1..8]of byte;
Timage = record
width: integer;
height : byte;
afb : array[1..10000] of byte;
end;
screenbuffer = array[1..200,1..320]of byte;
bytearray = array[1..65535]of byte;
intarray = array[1..32767]of integer;
picture = record
x,y,pic : integer;
end;
creature = record
x,y,width,height,pic,varA,varB,varC,degrees,delay,samepicture : integer;
needcreatures : array[1..8] of ^picture;
delete : boolean;
end;
creaturearray = array[0..255]of creature;
available = array[1..1024]of boolean;
string128 = string[128];string12 = string[12];
string128ptr = ^string128;
levelheading = record
 startwith,music:byte;
 the : boolean;
 width:integer;
 height:integer;
 typeplayer:byte;
 filename:string[16];
 startx,starty:integer;
 bordl,bordr,bordu,bordd : byte;
 bgcolour:byte;
end;
const
lastone  = 114;
types : array[0..lastone]of byte = (
4,1,1,1,1,1,5,1,1,1,2,3,3,6,6,7,6,6,1,3,6,6,1,8,1,1,6,0,1,0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,0,10,0,1,6,6,6,1,1,1,1,0,0,6,6,6,6,3,3,0,6,3,6,1,3,1,1,1,
1,1,1,9,2,11,12,11,9,0,0,9,1,1,0,2,1,2,6,1,9,6,3,6,3,12,3,9,9,3,0,6,1,1,0,0,6,6,6,0,0,3);
startwithstr : array[0..54]of string[20] =
('destroy the world in','boldly assaults','rockets into','seeks thrills','smashes through',
'hungily enters','ascends','engages','barrels into','goes nuts into',
'regrets entering','blows through','trots through','breaks into',
'hurries through','explodes into','faces danger','attacks','hops across',
'fights this way','crosses into','dares to enter','foolishly enters',
'makes his way into','whoops it up in','enters','makes a run for',
'slips into','plummets in','reflects upon','shivers along','plots down into',
'stumbles upon','backs into','hesitantly acces','reverently enters','moves silently in',
'grits his teeth','dissapears into','crawls into','blazes across','hopefully enters',
'mucks along','purposefully wanders','investigates the','struts through',
'invades','launches into','purposefully struts','bravely enters','warily enters',
'returns to','is in','Loading','unexplainedly finds him self by');
var neededfile : file of available;player : creature;
imageptrs: array[1..1024]of longint;
scorebox : pointer;l : letter;programmings : word;
programmingfile : file of string128;
filenames : file of string12;
double,current : ^screenbuffer;
tmpcreature : creature;bullets,creatures : ^creaturearray;
schoolfishes: array[1..255]of byte;
tmpcrefile : file of creature;imagefile : file;
centerptr,levelwidth,levelheight,gotolevel : integer;
schoolfishptr,schoolfishcount : integer;tmpimage : array[1..12000]of byte;
tmp : available;crazymode : byte;stri : string128;
lay3,tmplay:^intarray;backgrounds : ^bytearray;
lay1,lay4: word;
maxloaded : integer;tmpbackground : background;
imagecount : integer;
gamemap:boolean;biostime : longint absolute $0040:$006c;
sandwich,soundblaster,godmode,noclipping,jumpcheat: boolean;
r : registers;numbers : array['0'..'9']of letter;
allbullets,lives,raindrops,lastimage,timescreens : integer;
points : longint;slowmotion,oudspatie,oudalt,editormode,oldeditormode : boolean;
escape,ctrl,spatie,alt,le,ri,up,down,playerkilled,playervisibility,levelfinished : boolean;
switch1,switch2 : byte;imageptr : longint;
paletinfsize,paletsize,images,bgtype,palet:word;currentlevel:levelheading;
fkeys:array[1..12]of boolean;
reachlevel,levelexist:array[1..255]of boolean;
distanceplayer:real;centery:integer;
procedure bigwindow;
procedure startmessage;
procedure checkkilledplayer;
function touchdanger(var c: creature):boolean;
function gameended:boolean;
procedure testspeed;
procedure animateall;
procedure loadprogrammings;
procedure checkcenter(var x,y:integer);
procedure loadpalet(filename:string);
procedure autoexe;
procedure restorebackgrounds;
procedure fillimage(i:word);
procedure loadimages;
procedure putimageEMB(w:word;x,y:integer);
function touchpoleground(var c : creature) : boolean;
function addcreature(picture,x,y,degrees:integer):integer;
procedure putmessage(t : integer);
procedure puttext(s : string;x,y : integer;fc,bc : integer);
procedure destroycreatures;
procedure setplayer(b : byte);
function touchborderplatform1(var c:creature):boolean;
function touchborderplatform2(var c:creature):boolean;
procedure setkeys(b:boolean);
{procedure makespaceforimages(I : integer);}
procedure playkillsound;
procedure drawscreen(toscreen : boolean);
procedure loadpicture(s : string;I : integer);
{procedure makespaceforbullets(I : integer);}
procedure loadstring(var p : string128ptr;s:string128);
procedure playendsound;
{procedure makespaceforcreatures(I :integer);}
function maxhigh(c:creature) : integer;
procedure defaultplayer(var tmpcreature : creature);
procedure defaultswimplayer(var tmpcreature : creature);
procedure closesound;
function getlay4(x,y : integer) : integer;
function getlay1(x,y :  integer): integer;
procedure playsoundnr(i:integer);
procedure setlay1(x,y : integer;b : integer);
procedure setlay4(x,y : integer;b : integer);
procedure setlay3(x,y:integer;b:integer);
function getlay3(x,y : integer): integer;
procedure putlay4(toscreen : boolean);
procedure putlay2(toscreen : boolean);
procedure putlay1(toscreen : boolean);
procedure putscorebox;
procedure shootcreature(var c : creature;picture,deg,x,y : integer);
procedure destroybullets;
procedure destroyschoolfishes;
procedure checkschoolfishes;
procedure restorescreen;
procedure movememory(i:word;j:longint;k:word;l:longint;m:longint);
procedure sizeimage(I : integer;var w,h : integer);
function getbackground(x,y:integer) : byte;
function spatiepressed : boolean;
procedure setbackground(x,y:integer;b:byte);
procedure makeerror(s : string);
procedure removeallfrommem;
procedure putpixel(x,y : integer; b : byte);
procedure putimage(var doelwit;x,y : integer);
procedure putbackground(b : integer;x,y : integer);
procedure putletter(var l : letter;x,y,fc,bc: integer);
procedure loadimage(var p : pointer;filename,path : string;var ok : integer);
procedure initfiles;
function enter : boolean;
function pageup : boolean;
function pagedown:boolean;
procedure removeimage(var p : word);
procedure runcreature (var c : creature);
function collideplayer(var c:creature) : boolean;
function overlapping(p1,p2 : posi) : boolean;
function possible(x1,y1,x2,y2 : integer):boolean;
function fall(var c:creature) : boolean;
function goforward(var c:creature;speed:integer):boolean;
function readstring(var s :string;x,y:integer): boolean;
procedure checkkeys;
procedure restoreint9;
procedure shootplayerbullet(var c : creature; degr,x1,y1:integer);
function collideplayerbullet(var c : creature):boolean;
procedure destroyplayerbullet(var c: creature);
procedure removeptrimage(var p :pointer);
function distance(c:creature):real;
implementation
var I : char;ticeblock,tsemiblock:(nonepl,goleftpl,gorightpl);
letterfile : file of letter;leveltimer:integer;
hello:text;xmsmemavail,k:word;
procedure movememory;
begin
 moveXMS(i,j,k,l,m);
end;
procedure puttextgood(var s: string;x,y:integer;fc,bc:integer;var po :pointer);
var st,st2: string[40];p:procedure absolute po;i:byte;
begin
 st :='';st2:='';
 repeat
 i:=pos(' ',s);if i = 0 then i:=length(s);
 st:=copy(s,1,i);
 st2:=st2+st;
 puttext(st2,x,y,fc,bc);
 p;move(double^,current^,64000);delay(100);
 delete(s,1,i);until play.stopped;
end;
procedure startmessage;
var test:integer;tmpstr:string[128];p:pointer;f:file;
{$f-}procedure bekijk{$f+};
begin
 bigwindow;
 putimageEMB(870+test,60,60);
 test:=test+1;if test = 6 then test:=1;
end;
begin
 assign(f,'tmp.$$$');
 reset(f);
 blockread(f,double^,500);
 close(f);
 playsoundnr(1);
 test:=1;
 tmpstr:='Keen '+startwithstr[currentlevel.startwith]+
 ' '+currentlevel.filename;
 bigwindow;p:=@bekijk;
 putimageEMB(871,60,60);puttextgood(tmpstr,1,0,15,-1,p)
end;
function iceblock(i:integer):boolean;
begin
 case i of
  371,381,389,398:iceblock:=true;
  else iceblock:= false
  end;
end;
procedure autoexe;
begin
 leveltimer:=leveltimer+1;
 if leveltimer>12 then leveltimer:=0;
 if le then ticeblock:=goleftpl;
 if ri then ticeblock:=gorightpl;
 if iceblock(getlay3(player.x-1,player.y+player.height))or
 iceblock(getlay3(player.x,player.y+player.height)) then
 case ticeblock of
 nonepl: begin if le then ticeblock:=goleftpl;
 if ri then begin le:=false; ticeblock:=gorightpl end end;
 goleftpl: begin ri:=false;le:=false;
 if possible(player.x-1,player.y,player.x-2+player.width,player.y+player.height-1) then
 player.x:=player.x-1;
 end;
 gorightpl: begin le:=false;ri:=false;
 if possible(player.x+1,player.y,player.x+player.width,player.y+player.height-1)
 then player.x:=player.x+1 end end;
 if 364 = getlay3(player.x,player.y+player.height) then case tsemiblock of
 nonepl: begin if le then tsemiblock := goleftpl;
 if ri then begin le:= false;tsemiblock:=gorightpl end end;
 goleftpl: begin ri := false;le:=true end;
 gorightpl: begin ri:=true;le:=false end end else tsemiblock:= nonepl;
end;
function touchdanger;
var b : boolean;i,k : integer;
begin
 b:= false;
 for I:= c.y to c.y+c.height-1 do
 begin
 k:= getbackground(c.x,i); if (k = 5)or(k=6) then b:= true;
 end;
 touchdanger := b;
 end;
procedure checkkilledplayer;
begin
 if touchdanger(player) and not godmode then playerkilled:=true;
 if playerkilled and (player.pic <90)and(player.pic<>34)and
 (player.pic <> 35) then player.pic:=34;
 if playerkilled and(player.pic >90) and(player.pic <>139)and
 (player.pic <>140) then player.pic :=139;
end;
function gameended;
var i : integer;b:boolean;
begin
 gameended:=true;b:=false;
 for I:= 1 to 255 do begin
 if levelexist[i] then b:= true;
  if levelexist[i] and not reachlevel[i] then gameended := false
  end;
 if not b then gameended := false;
end;
procedure testspeed;
type
  _32K_buffer = array [0..$7fff] of byte;
var
  handle, which : word;
  mypointer : ^_32K_buffer;
  l, timer : longint;
  biostime : longint absolute $0040:$006c;
  c_to_x, x_to_c, x_to_x : longint;
  annual:longint;
begin
  getmem(mypointer, $8000);
  Allocate_XMS(512, handle);
  fillchar(mypointer^, $8000, 0);
  writeln;
  write('Testing copying speed of conventional to XMS...');
  which := 0;
  l := 0;
  timer := biostime;
  while timer=biostime do;
  timer := biostime+91;
  repeat
    MoveXMS(0, longint(mypointer),
            handle, longint(which) * longint($8000),
            $8000);
    inc(which);
    if which > 15 then
    begin
      which := 0;
      inc(l);
    end;
  until biostime >= timer;
  c_to_x := (l*16)+which;
  writeln('done.');
  write('Testing copying speed of XMS to conventional...');
  which := 0;
  l := 0;
  timer := biostime;
  while timer=biostime do;
  timer := biostime+91;
  repeat
    MoveXMS(handle, longint(which) * longint($8000),
            0, longint(mypointer),
            $8000);
    inc(which);
    if which > 15 then
    begin
      which := 0;
      inc(l);
    end;
  until biostime >= timer;
  x_to_c := (l*16)+which;
  writeln('done.');
  write('Testing copying speed of XMS to XMS...');
  which := 0;
  l := 0;
  timer := biostime;
  while timer=biostime do;
  timer := biostime+91;
  repeat
    MoveXMS(handle, longint(which) * longint($8000),
            handle, longint((which+8) and $0f) * longint($8000),
            $8000);
    inc(which);
    if which > 15 then
    begin
      which := 0;
      inc(l);
    end;
  until biostime >= timer;
  x_to_x := (l*16)+which;
  writeln('done.');
  writeln;
  writeln(32*c_to_x/5.0:0:0,' KB per second conv to XMS.');
  writeln(32*x_to_c/5.0:0:0,' KB per second  XMS to conv.');
  writeln(32*x_to_x/5.0:0:0,' KB per second  XMS to XMS.');
  annual:=round(((32*c_to_x/5.0)+(32*x_to_c/5.0)+(32*x_to_x/5.0))/3);
  if annual < 150000 then distanceplayer:=12.0;
  if annual < 300000 then distanceplayer:=24.0;
  if annual < 450000 then distanceplayer:=48.0;
  if annual < 600000 then distanceplayer:=96.0;
  if annual >= 600000 then distanceplayer:=200.0;
  Free_XMS(handle)
end;
function distance;
begin
 distance :=sqrt(sqr(1.0*c.x-player.x)+sqr(1.0*c.y-player.y));
end;
procedure animateall;
procedure animatelayer(var l :intarray;chsolid:boolean);
var i : longint;P:integer;
begin
 for I := 1 to longint(levelwidth)*longint(levelheight) do begin
  p:= l[i];case p of
  69,86: l[i]:=p+9;
  1221: l[i]:=1257;
  1257: l[i]:=1221;
  78,682: l[i]:=p+8;
  733:l[i]:=p+12;
  95: l[i]:=69;
  741:l[i]:=720;
  224,226,228,255,457,458: l[i]:=p+1;
  225,227,229,256:l[i]:=p-1;
  261,262,269,270,572..577: l[i]:=p+2;
  263,264,265,266,271,272,459: l[i]:=p-2;
  1382,1384:if leveltimer = 8 then begin if chsolid then  backgrounds^[i]:=2;
  if p = 1382 then l[i]:= 1386 else l[i]:=1384 end;
  1381: if leveltimer = 8 then l[i]:=1383;
  1385: if leveltimer = 8 then l[i]:=1387;
  1383:if leveltimer = 8 then l[i]:=1381;
  1387:if leveltimer = 8 then l[i]:=1385;
  1386,1388: if leveltimer = 8 then begin if chsolid then backgrounds^[i]:=0;
  if p = 1386 then l[i]:=1388 else l[i]:= 1388 end;
  723,745: l[i]:=p+10;
  755: l[i]:= 723;
  795: l[i]:=806;
  806: l[i]:=818;
  818: l[i]:=795;
  267,268: l[i]:=p-6;
  328: l[i]:=p+3;
  331: l[i]:=343;
  343: l[i]:=328;
  333: l[i]:= 337;
  337: l[i]:=333;
  446: l[i]:=477;
  477: l[i]:=446;
  519: l[i]:=678;
  678: l[i]:=519;
  695: if leveltimer = 10 then l[i]:=704;
  704: if leveltimer = 10 then l[i]:=695;
  720:l[i]:=740;
  740:l[i]:=741;
  578,579: l[i]:=p-6;
  690: l[i]:=682;
 end
end end;
begin
moveXMS(lay1,0,0,longint(tmplay),2*longint(levelwidth)*levelheight);
animatelayer(tmplay^,false);
moveXMS(0,longint(tmplay),lay1,0,2*longint(levelwidth)*levelheight);
animatelayer(lay3^,true);
moveXMS(lay4,0,0,longint(tmplay),2*longint(levelwidth)*levelheight);
animatelayer(tmplay^,false);
moveXMS(0,longint(tmplay),lay4,0,2*longint(levelwidth)*levelheight);

end;
procedure checkcenter;
begin
if centerptr = 0 then begin x:=player.x - 10;
y:=player.y+ centery end else begin
x:=creatures^[centerptr].x-10;y:=creatures^[centerptr].y-6 end;
if x< 0 then x:=0;
if (x+20)>levelwidth then x:= levelwidth-20;
if (y+12)>levelheight then y:=levelheight-12;
if y<0 then y:=0;
end;
procedure setkeys;
begin
if b then allkeys.start else allkeys.stop;
end;
function pageup;
begin
 pageup := keydata2[73];
end;
function pagedown;
begin
 pagedown := keydata2[81];
end;
function spatiepressed;
begin
 spatiepressed:=keydata1[57];
end;
function readstring(var s:string;x,y:integer):boolean;
const
numbers : array[2..11]of char =
'1234567890';
whatkeys : array[16..25]of char =
'qwertyuiop';
whatkeys2 : array[30..38]of char =
'asdfghjkl';
whatkeys3: array[44..50]of char =
'zxcvbnm';
whatkeys4: array[2..11]of char =
'!@#$%^&*()';
whatkeys5: array[16..25]of char =
'QWERTYUIOP';
whatkeys6: array[30..38]of char =
'ASDFGHJKL';
whatkeys7: array[44..50]of char =
'ZXCVBNM';
var I:integer;t: file of screenbuffer;
begin
 readstring:=true;
 assign(t,'tmpscrn.$$$');
 rewrite(t);
 write(t,double^);
 close(t);
 assign(t,'tmpscrn.$$$');
 reset(t);
 s:='';
 repeat
 delay(100);
 for I:= 1 to $5F do if keydata1[I] then
 if keydata1[42]or keydata1[54] then
 case i of
 2..11 : s := s+whatkeys4[i];
 16..25: s:= s+whatkeys5[i];
 30..38: s:= s+whatkeys6[i];
 44..50: s:= s+whatkeys7[i];
 28:break;
 57: s:= s + ' ';
 14: if s<> '' then s[0]:= chr(length(s)-1)
 end else
 case i of
  2..11 : s:= s + numbers[i];
  14: if s <> '' then s[0] := chr(length(s)-1);
  16..25: s := s+whatkeys[i];
  28: break;
  57: s:=s+' ';
  30..38: s := s+whatkeys2[i];
  44..50: s := s+whatkeys3[i];
 end;
 seek(t,0);
 read(t,double^);
 puttext(s,x,y,7,-1);
 move(double^,current^,64000);
 until keydata1[28]or keydata1[1];
 if keydata1[1] then readstring := false;
 repeat until not enter;
 close(t);
end;

procedure XMS_error(errcode : word);

begin
  if (errcode = 0) or (xms_status = 1) then exit;
  textmode(c80);
  writeln(#7'XMS error ',errcode);
  Free_XMS(images);
  halt;
end;
function enter;
begin
 enter:=keydata1[28];
end;
procedure removeptrimage;
var T : ^timage;I:integer;
begin
 if p = nil then exit;
 t:= p;{$i-}
 freemem(p,3+t^.width*t^.height);
 {$i+}
 i := ioresult;
end;
procedure putimageEMB;
begin
 if (w<1)or(w>1023)or (imageptrs[w] = 0)then exit;
 case w of
 18: Y:= y+8;
 19: y:=y+10;
 39:y:=y-10;
 23..31:y:=y+5;
 85,94..99: y:=y + 7;
 102,115..119: y:=y+4;
 121..123: Y:=y-1;
 120: y:=y+12;
 103..114: y:= y+8;
 124..132:y:= y+ 12;
 196..197,256..264: y :=y+14;
 269..272: y := y+12;
 723,724,729:y:= y+ 3;
 725,726:y:=y-3;
 740,741:y:=y+12;
 742:y:=y+6;
 822,823,827,828,831,832,835,836: y:= y+5
 end;
 XMS_error(moveXMS(images,imageptrs[w],0,longint(@tmpimage),12000));
 lastimage:= w;
 putimage(tmpimage,x,y);
end;
function leestoets : integer;
var reg :registers;
begin
 reg.ax := $0800;
 reg.dx := $00FF;
 msdos(reg);
 leestoets := reg.ax - 2048;
 if reg.ax < 2049 then leestoets := (- leestoets);
end;
function touchpoleground;
var b : boolean;i,k : integer;
begin
 b:= false;
 for I:= c.y to c.y+c.height-1 do
 begin
 k:= getbackground(c.x,i); if (k = 3)or(k=4) then b:= true;
 end;
 touchpoleground := b;
 end;
procedure bigwindow;
var i,j : integer;
begin
 for I:= 55 to 265 do
 for j:= 59 to 141 do
 double^[j,i]:= 15;
 for I:=55 to 265 do begin double^[59,i] := 1;double^[60,i]:= 1;double^[140,i]:=3;double^[141,i]:=3 end;
 for I:= 59 to 141 do begin double^[i,264]:=3;double^[i,265]:= 3;double^[i,55]:=1;double^[i,56]:=1 end;
 for I:= 61 to 139 do begin double^[i,262]:=1;double^[i,263]:=1;double^[i,57]:=3;double^[i,58]:=3 end;
 for I:= 57 to 263 do begin double^[61,i]:=3;double^[62,i]:= 3;double^[138,i]:=1;double^[139,i]:=1 end;
 double^[59,55]:= 15;double^[59,265]:= 15;
 double^[141,55]:= 15;double^[141,265]:= 15;
 double^[61,263]:=3;double^[61,262]:=3;
 double^[62,263]:=1;double^[62,262]:=3;
 double^[139,57]:=1;double^[139,58]:=1;
 double^[138,57]:=3;double^[138,58]:=1;
 double^[59,264]:=1;double^[141,56]:=3;
end;
procedure smallwindow;
var i,j : integer;
begin
 for I:= 105 to 215 do
 for j:= 84 to 116 do
 double^[j,i]:= 15;
 for I:=105 to 215 do begin double^[84,i] := 1;double^[85,i]:= 1;double^[115,i]:=3;double^[116,i]:=3 end;
 for I:= 84 to 116 do begin double^[i,214]:=3;double^[i,215]:= 3;double^[i,105]:=1;double^[i,106]:=1 end;
 for I:= 86 to 114 do begin double^[i,212]:=1;double^[i,213]:=1;double^[i,107]:=3;double^[i,108]:=3 end;
 for I:= 107 to 213 do begin double^[86,i]:=3;double^[87,i]:= 3;double^[113,i]:=1;double^[114,i]:=1 end;
 double^[84,105]:= 15;double^[84,215]:= 15;
 double^[116,105]:= 15;double^[116,215]:= 15;
 double^[86,213]:=3;double^[86,212]:=3;
 double^[87,213]:=1;double^[87,212]:=3;
 double^[114,107]:=1;double^[114,108]:=1;
 double^[113,107]:=3;double^[113,108]:=1;
 double^[84,214]:=1;double^[116,106]:=3;
end;
procedure putmessage;
var i,j,k : integer;
begin
 if (t<14) or(t=20)or(t=21) then smallwindow else bigwindow;
 case t of
 1: if godmode then puttext('God mode ON',116,96,0,15) else puttext('God mode OF',116,96,0,15);
 2: begin puttext('No Clipping',116,92,0,15);
 if noclipping then puttext('Mode ON',132,100,0,15) else puttext('Mode OF',132,100,0,15)
 end;
 3: if jumpcheat then puttext('Jump cheat ON',108,96,0,-1) else puttext('Jump cheat OF',108,96,0,-1);
 4: puttext('Free Items!',116,96,0,15);
 5: begin puttext('Slow Motion',116,92,0,15);
 if slowmotion then puttext('ON',152,100,0,15) else puttext('OF',152,100,0,15) end;
 10: begin puttext('Gamemap file',108,92,0,15);
 puttext('not found',124,100,0,15) end;
 11: puttext('Map to large',108,96,0,15);
 12: puttext('You''ve won!!!!',104,96,0,15);
 13: puttext('Levelwidth: 24-1365',84,96,0,-1);
 14: puttext('Levelheight to big',88,96,0,-1);
 17: begin putimageEMB(870,212,81);
 puttext('Oh no!',60,65,0,-1);
 puttext('It''s a slavering',60,74,0,-1);
 puttext('Grabbiter! He says,',60,83,0,-1);
 puttext('"Get me lunch and',60,92,0,-1);
 puttext('I''ll tell ya a secret!"',60,101,0,-1);
 end;
 16: begin putimageEMB(870,212,81);
 puttext('The Grabbiter grabs',60,65,0,-1);
 puttext('the gigantic sandwich,',60,74,0,-1);
 puttext('downs it in one bite',60,83,0,-1);
 puttext('and says, "Here''s your',60,92,0,-1);
 puttext('secret. Big meals',60,101,0,-1);
 puttext('make me sleepy"',60,110,0,-1);
 end;
 18: begin putimageEMB(870,212,81);
 puttext('This is the second',70,75,0,-1);
 puttext('biggest sandwich',70,84,0,-1);
 puttext('I ever saw',70,93,0,-1)
 end;
 20: begin j:=1;k:=0;
 for I:= 1 to 255 do if (creatures^[i].pic <>0) then
 if (distance(creatures^[i])<distanceplayer)or gamemap then j:= j + 1 else k:= k +1;
 puttext('Active: ',87,59,0,-1);
 puttext('Inactive: ',87,69,0,-1);
 str(j,stri);puttext(stri,151,59,0,-1);
 str(k,stri);puttext(stri,160,69,0,-1)
 end;
 21: puttext('You loose!',120,96,0,-1);
 end;
 move(double^,current^,64000);
 repeat
 until keydata1[28];
 repeat until not keydata1[28];
end;
procedure shootcreature;
begin
addcreature(picture,c.x+x,c.y+y,deg);
end;
function collideplayerbullet;
var i : integer;p1,p2:posi;b:boolean;
begin
 b:= false;
 p1.x1 := c.x;
 p1.y1 := c.y;
 p1.x2 := c.x+c.width-1;
 p1.y2 := c.y+c.height-1;
 for I := 1 to 255 do
 begin
  if bullets^[i].pic = 0 then continue else tmpcreature := bullets^[i];
  p2.x1 := tmpcreature.x;
  p2.y1 := tmpcreature.y;p2.x2 := tmpcreature.x+tmpcreature.width-1;
  p2.y2 := tmpcreature.y+tmpcreature.height-1;
  if overlapping(p1,p2) then begin b := true; bullets^[i].pic:=46 end;
end;
collideplayerbullet:=b;
end;
procedure destroyplayerbullet;
var i : integer;p1,p2:posi;
begin
 p1.x1 := c.x;
 p1.y1 := c.y;
 p1.x2 := c.x+c.width-1;
 p1.y2 := c.y+c.height-1;
 for I := 1 to 255 do
 begin
 if bullets^[i].pic = 0 then continue else tmpcreature := bullets^[i];
  p2.x1 := tmpcreature.x;
  p2.y1 := tmpcreature.y;p2.x2 := tmpcreature.x+tmpcreature.width-1;
  p2.y2 := tmpcreature.y+tmpcreature.height-1;
  if overlapping(p1,p2) then
   bullets^[i].delete := true;
end;
end;
function goforward;
label 1;
var i,newx,newy : integer;b:boolean;p:posi;
begin
 newx:=c.x;newy:=c.y;
 if speed = 1 then begin
  case c.degrees of
  0: begin newx:= c.x; newy:=c.y-1 end;
  45: begin newx:= c.x+1;newy:= c.y-1 end;
  90: begin newy:= c.y; newx:=c.x+1 end;
  135: begin newx:= c.x+1;newy:=c.y+1 end;
  180: begin newx := c.x; newy:= c.y+1 end;
  225: begin newx:= c.x-1;newy:= c.y+1 end;
  270: begin newx:= c.x -1; newy:=c.y end;
  315: begin newx:= c.x-1;newy:=c.y-1 end;
  end;
  {newx:=c.x+round(sin(c.degrees));
  newy:=c.y-round(cos(c.degrees));}
  p.x1 := newx;
  p.y1 := newy;
  p.x2 := newx+c.width-1;
  p.y2 := newy+c.height-1;
  if c.pic < 84 then b:=possible(p.x1,p.y1,p.x1,p.y1) else
  b:= possible(p.x1,p.y1,p.x2,p.y2);
  end
  else
  for I:= 1 to speed do
   begin
    b:=goforward(c,1);
    if b then goto 1;
   end;
 1: if b and (speed=1)then begin c.x := newx;c.y := newy end;
 goforward := b;
end;
procedure shootplayerbullet;
label 1;
var i,d : integer;
begin
 d:= 0;
 for I:= 1 to 255 do
 if bullets^[i].pic = 0 then begin d:= i; goto 1 end;
  1: if d = 0 then begin exit;write(chr(7)) end;
 with bullets^[d] do
 begin
 pic := 42;
 degrees := degr;
 x:= c.x;
 if c.pic < 90 then y:= c.y else y:=c.y+1;
 width := 1;
 height := 1;
 delete:= false;
 end;
end;
procedure restoreint9;
begin
 allkeys.stop;
end;

procedure checkkeys;
const b1: set of byte = [11,12,13];
      b2:set of byte = [14,15,16];
var i,j : integer;
begin
 ctrl:=keydata1[29]or keydata2[29];
 escape:=keydata1[1];
 alt:=keydata1[56]or keydata2[56];
 alt := alt and not oudalt;
 oudalt := keydata1[56];
 up:=keydata2[72];
 le:=keydata2[75];
 ri:=keydata2[77];
 down:=keydata2[80];
 spatie:=keydata1[57];
 spatie := spatie and not oudspatie;
 oudspatie := keydata1[57];
 if keydata1[68] and keydata1[34] then begin godmode := not godmode; putmessage(1) end;
 if keydata1[68] and keydata1[49] then begin noclipping := not noclipping; putmessage(2) end;
 if keydata1[68] and keydata1[36] then begin jumpcheat := not jumpcheat; putmessage(3) end;
 if keydata1[68] and keydata1[23] then begin points := points + 10;allbullets := 99;lives := lives + 1;sandwich := true;
  putmessage(4) end;
 if keydata1[68] and keydata1[31] then begin slowmotion := not slowmotion; putmessage(5) end;
 if keydata1[68] and keydata1[46] then putmessage(20);
 if keydata1[68] and keydata1[37] then begin centerptr:=centerptr+1;
 if (centerptr=256)or(creatures^[centerptr].pic=0) then centerptr:=0 end;
 if keydata1[68] and keydata1[38] then centerptr:=0;
 if keydata1[68]and keydata1[47] then begin j:=1;fillchar(double^,64000,0);
 for i:=1 to 255 do if levelexist[i] and not reachlevel[i] then begin
 str(i,stri);puttext(stri,1,j,15,-1); j:= j+8 end; move(double^,current^,64000);
 repeat until enter;
  end;
 editormode:= (keydata1[54]or keydata1[42])and keydata1[15] and not oldeditormode;
 oldeditormode:= (keydata1[54] or keydata1[42]) and keydata1[15];
 if slowmotion then delay(500);
 if ctrl and jumpcheat and (not alt) and not gamemap then if le or ri then
 if le then player.pic := 14 else player.pic := 11 else
 if player.pic in b1 then player.pic := 11 else if player.pic in b2 then player.pic := 12;
 for I:= 1 to 10 do fkeys[i] := keydata1[i+58];
 fkeys[11]:=keydata1[87];
 fkeys[12]:=keydata2[88];
end;
function overlapping;
begin
 if (p1.x1 <= p2.x1)and(p1.x2>=p2.x1) and
 (p1.y1 >= p2.y1)and(p1.y2<=p2.y1) then overlapping := true else
 if (p1.x1 <= p2.x2)and(p1.x2 >= p2.x2) and
 (p1.y1 >= p2.y1) and (p1.y2 <= p2.y1) then overlapping := true else
 if (p1.x1 <= p2.x1)and(p1.x2 >= p2.x1) and
 (p1.y1 >= p2.y2)and(p1.y2<=p2.y2) then overlapping := true else
 overlapping := (p1.x1 <= p2.x2)and(p1.x2 >= p2.x2)and
 (p1.y1 >= p2.y1)and(p1.y2 <= p2.y2);
end;
function collideplayer;
var p1,p2 : posi;
begin
 if (c.width=6)and(c.height=6) then begin
 collideplayer:= (c.x<=player.x)and((c.x+5)>=player.x)and(c.y<=player.y)and((c.y+5)>=player.y);
 exit end;
 if(c.width=3)and(c.height=3) then begin
 collideplayer:= (c.x<=player.x)and((c.x+1)>=player.x)and(c.y<=player.y)and((c.y+2)>=player.y);
 exit end;
 p1.x1 := c.x;p1.x2 := c.x + c.width-1;
 p1.y1 := c.y;p1.y2 := c.y + c.height-1;
 p2.x1 := player.x; p2.x2 := player.x + player.width - 1;
 p2.y1 := player.y; p2.y2 := player.y + player.height;
 if gamemap then collideplayer := (player.x>=p1.x1)and(player.x<=p1.x2)and
 (player.y>=p1.y1)and(player.y<=p1.y2) else
 collideplayer := overlapping(p1,p2);
end;
function possible;
var i,j:integer;
begin
 if noclipping then begin possible := true;exit end;
 possible := true;
  if x2 < x1 then begin I:=x1;x1:=x2;x2:=i end;
  if y2<y1 then begin I:=y1;y1:=y2;y2:=i end;
  for I:= x1-1 to x2-1 do for j := y1 to y2 do
  if getbackground(i,j)= 1 then possible := false;
end;

function fall;
var i,j: integer;
begin
 if noclipping then begin fall := true; exit end;
 fall:=true;
if c.y > levelheight then begin fall:=false; exit end;
 if c.y < 1 then begin fall:= true;exit end;
 if c.x <1 then c.x := 1;
 if c.x > levelwidth then c.x := levelwidth;
for I:= c.x-1 to c.x - 2 + c.width do
  begin
  j:= getbackground(i,c.y+c.height);
  if ((j>0)and(j<4))then fall := false
end;
end;
procedure removestatement(var str : string128);
var c : byte;
begin
 c:= ord(str[1]);delete(str,1,1);
 case types[c] of
 1: removestatement(str);
 2: begin delete(str,1,1);removestatement(str) end;
 3: begin delete(str,1,2);removestatement(str) end;
 4: delete(str,1,1+ord(str[1]));
 5: delete(str,1,3+ord(str[3]));
 6: delete(str,1,2);
 7: delete(str,1,8);
 8: delete(str,1,6);
 9: delete(str,1,1);
 10: delete(str,1,4);
 11: delete(str,1,3);
 12: delete(str,1,5)
 end;


end;
function touchborderplatform1;
var b : boolean;I:integer;
begin
 b:= false;
 for I:= c.x to c.x+c.width-1 do
  if getbackground(i,c.y-1)<>1 then b := true;
  if not b then begin touchborderplatform1 := false;exit end;
  if getbackground(c.x+c.width,c.y-1)=1 then touchborderplatform1 := false else
  touchborderplatform1:= getbackground(c.x+c.width,c.y)=1;
end;
function touchborderplatform2;
var b : boolean;I:integer;
begin
 b:= true;
 for I:= c.x-1 to c.x+c.width-2 do
  if getbackground(i,c.y-1)<>1 then b := false;
  if b then begin touchborderplatform2 := false;exit end;
  if getbackground(c.x-2,c.y-1)=1 then touchborderplatform2 := false else
  touchborderplatform2:= getbackground(c.x-2,c.y)=1;
end;
function fallwhenleft(c: creature):boolean;
begin
 c.x := c.x - 1;
 fallwhenleft:= fall(c);
end;
procedure runinteractive(var c : creature;i:integer);
begin
case i of
1: begin
 backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x]:=1;
 backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x+1]:=1;
 backgrounds^[longint(levelwidth)*c.y+c.x]:=1;
 backgrounds^[longint(levelwidth)*c.y+c.x+1]:=1;
c.x:=c.x-1;c.y:=c.y-1;c.width:=4;c.height:=4;
if not collideplayer(c) then c.varA:=1;
if sandwich and collideplayer(c) and (c.varA = 1)then begin putmessage(16);c.pic := 903;sandwich:= false; end else
if collideplayer(c) and not sandwich and (c.varA=1)then putmessage(17);
if c.pic = 901 then c.pic := 902 else if c.pic = 902 then c.pic := 901;
if collideplayer(c) then c.varA := 0;
c.x:=c.x+1;c.y:=c.y+1;
 end;
2: begin
 backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x]:=0;
 backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x+1]:=0;
 backgrounds^[longint(levelwidth)*c.y+c.x]:=0;
 backgrounds^[longint(levelwidth)*c.y+c.x+1]:=0;
end;
3: if (c.x<=player.x)and((c.x+3)>=player.x)and(c.y<=player.y)and((c.y+3)>=player.y) then levelfinished:=true;

4: if (c.x<=player.x)and((c.x+3)>=player.x)and(c.y<=player.y)and((c.y+2)>=player.y) then begin putmessage(18);
sandwich := true;levelfinished:=true end;
5: if reachlevel[c.varC] and (c.varB <> 243) then begin addcreature(952,c.x,c.y-2,0);c.varB:= 243 end;
6: begin
if (c.x<=player.x)and((c.x+5)>=player.x)and(c.y<=player.y)and((c.y+4)>=player.y)and ctrl then gotolevel:=c.varC;
fillchar(backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x],6,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+c.x],6,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+levelwidth+c.x],6,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+2*longint(levelwidth)+c.x],6,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+3*longint(levelwidth)+c.x],6,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+c.x+2],2,0);
fillchar(backgrounds^[longint(levelwidth)*c.y+levelwidth+c.x+2],2,0);
fillchar(backgrounds^[longint(levelwidth)*c.y+2*longint(levelwidth)+c.x+2],2,0);
fillchar(backgrounds^[longint(levelwidth)*c.y+3*longint(levelwidth)+c.x+2],2,0);
if reachlevel[c.varC] then begin c.pic := 919;
fillchar(backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x+2],2,0)
end
end;
7:begin
if (c.x<=player.x)and((c.x+2)>=player.x)and((c.y+3)<=player.y)and((c.y+5)>=player.y)and ctrl then gotolevel:=c.varC;
fillchar(backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x],4,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+c.x],5,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+levelwidth+c.x],5,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+2*longint(levelwidth)+c.x],5,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+3*longint(levelwidth)+c.x+2],3,1);
fillchar(backgrounds^[longint(levelwidth)*c.y+4*longint(levelwidth)+c.x],5,0);
backgrounds^[longint(levelwidth)*c.y-longint(levelwidth)+c.x+2]:=0;
backgrounds^[longint(levelwidth)*c.y+4*longint(levelwidth)+c.x+2]:=1;
end;
8:if collideplayer(c) and((switch1 and 1)=1) then begin switch2:=switch2 or 1;c.pic:=c.pic+1 end;
9:if collideplayer(c) and((switch1 and 2)=2) then begin switch2:=switch2 or 2;c.pic:=c.pic+1 end;
10:if collideplayer(c) and ((switch1 and 4)=4) then begin switch2:= switch2 or 4;c.pic:=c.pic+1 end;
11:if collideplayer(c) and ((switch1 and 8)=8) then begin switch2:=switch2 or 8;c.pic:=c.pic+1 end;
end end;
function fallwhenright(c:creature):boolean;
begin
 c.x:= c.x+1;
 fallwhenright:=fall(c);
end;
procedure looktoplayer(var c : creature);
var y:integer;
begin
 y:= c.y+c.height-1;
 if (c.x>player.x)and(y=player.y) then c.degrees := 270;
 if (c.x>player.x)and(y<player.y) then c.degrees := 225;
 if (c.x>player.x)and(y>player.y) then c.degrees := 315;
 if (c.x=player.x)and(y<player.y) then c.degrees := 180;
 if (c.x=player.y)and(y>player.y) then c.degrees := 0;
 if (c.x<player.x)and(y=player.y) then c.degrees := 90;
 if (c.x<player.x)and(y<player.y) then c.degrees := 135;
 if (c.x<player.x)and(y>player.y) then c.degrees := 45;
end;
function playerabove(c:creature):boolean;
begin
 playerabove:= ((player.y+player.height)=c.y) and (player.x>=c.x) and(player.x<=(c.x+c.width-1));
end;
function deletecollidingschoolfish(var c: creature):boolean;
var i : integer;p1:posi;b:boolean;
begin
 b:= false;
 p1.x1 := c.x;
 p1.y1 := c.y;
 p1.x2 := c.x+c.width;
 p1.y2 := c.y+c.height;
 for I := 1 to 255 do
 begin
  if (creatures^[schoolfishes[i]].pic = 0)or(schoolfishes[i]=0) then continue else tmpcreature := creatures^[schoolfishes[i]];
  if (p1.x1<=tmpcreature.x)and(p1.x2>tmpcreature.x)and(p1.y1<=tmpcreature.y)and
  (p1.y2>tmpcreature.y) then begin b := true; creatures^[schoolfishes[i]].delete:=true;
  schoolfishes[i]:=0;break end;
end;
deletecollidingschoolfish:=b;
end;
procedure checkschoolfishes;
var I:integer;ptr:integer;
begin
ptr:=1;fillchar(schoolfishes,sizeof(creatures),0);
for I:= 1 to 255 do if creatures^[i].pic = 351 then begin schoolfishes[ptr]:=i;ptr:=ptr+1 end;
end;

procedure runcreature;
label 1;
var b : byte;s: ^string128;d:^byte;I1,i2,i3,i4 : ^integer;deletemode : boolean;
strtmp : string128 absolute stri;oldpicture : integer;
u:string128;
begin
if c.delay > 0 then begin c.delay:= c.delay-1;exit end;
if (c.pic > 1023)or(c.pic<1) then exit;
moveXMS(programmings,129*longint(c.pic),0,longint(@strtmp),129);
oldpicture := c.pic;
while strtmp <> '' do begin b:= ord(strtmp[1]);
deletemode := true;
i1:= addr(strtmp[2]);
case types[b] of
1: s:=addr(strtmp[2]);
2: begin d:= addr(strtmp[2]);s := addr(strtmp[3]) end;
3,5: begin I1 := addr(strtmp[2]);s:= addr(strtmp[4]) end;
6 : I1 := addr(strtmp[2]);
7: begin I1 := addr(strtmp[2]);I2 := addr(strtmp[4]);
 I3:=addr(strtmp[6]);I4:=addr(strtmp[8]) end;
8: begin I1 := addr(strtmp[2]);I2 := addr(strtmp[4]);
I3 := addr(strtmp[8]); end;
9: d:= addr(strtmp[2]);
10: begin I1 := addr(strtmp[2]);I2 := addr(strtmp[4]) end;
11: begin d := addr(strtmp[2]);I1 := addr(strtmp[3]) end;
12: begin d:= addr(strtmp[2]);I1 := addr(strtmp[3]); I2 := addr(strtmp[5]) end;
{$i+}
end;
case b of
1: deletemode := not le;
2: deletemode := not ctrl;
3: deletemode := not ri;
4: deletemode := not up;
5: deletemode := not down;
{6: loadpicture(s^,i1^);}
7: deletemode := not alt;
8: deletemode := not collideplayer(c);
9: deletemode:= (c.y+c.height)<>(player.y+player.height);
10: deletemode:= (distance(c)>=d^)or (distance(c)>255.0);
11: deletemode := c.samepicture < (I1^div timescreens);
12: deletemode := c.varA <> I1^;
13: c.varA := random(I1^);
14: c.varA := I1^;
15:shootcreature(c,i1^,i2^,i3^,i4^);
17: begin c.pic := I1^;
sizeimage(c.pic,c.width,c.height) end;
18: deletemode := (not fall(c));
19: deletemode := c.varB <= I1^;
20: c.varB := I1^;
21: c.varB := c.varB + I1^;
22: deletemode := not playerkilled;
23: shootplayerbullet(c,I1^,I2^,I3^);
24: deletemode := not collideplayerbullet(c);
25: deletemode := not spatie;
26: c.delay := I1^;
27: c.delete := true;
28: deletemode:= not fallwhenleft(c);
29: if possible(c.x-1,c.y,c.x+c.width-2,c.y+c.height-1) then c.x := c.x -1;
30: if possible(c.x+1,c.y,c.x+c.width,c.y+c.height-1) then c.x := c.x + 1;
32: if possible(c.x,c.y+1,c.x+c.width-1,c.y+c.height) then c.y := c.y + 1;
31: if possible(c.x,c.y-1,c.x+c.width-1,c.y+c.height-2) then c.y := c.y -1;
33: if noclipping then deletemode:= false else if gamemap then deletemode := 1 = getbackground(c.x-2,c.y) else
deletemode := not possible(c.x-1,c.y,c.x+c.width-2,c.y+c.height-1);
34: if noclipping then deletemode:=false else if gamemap then deletemode := 1 = getbackground(c.x,c.y) else
deletemode := not possible(c.x+1,c.y,c.x+c.width,c.y+c.height-1);
35: if noclipping then deletemode:=false else if gamemap then deletemode:= 1 = getbackground(c.x-1,c.y-1) else
deletemode := not possible(c.x,c.y-1,c.x+c.width-1,c.y+c.height-2);
36: if noclipping then deletemode:= false else if gamemap then deletemode:= 1 = getbackground(c.x-1,c.y+1) else
deletemode:= not possible(c.x,c.y+1,c.x+c.width-1,c.y+c.height);
37: c.x := c.x-1;
38: c.x := c.x+1;
39:c.y := c.y-1;
40:c.y := c.y+1;
41: deletemode := not touchpoleground(c);
42: deletemode := not fallwhenright(c);
45: looktoplayer(c);
46:begin c.x := c.x+I1^;c.y := c.y+I2^ end;
49: points := points + I1^;
50: lives := lives + I1^;
51: allbullets := allbullets + I1^;
52: deletemode := player.x >= c.x;
53: deletemode := player.x <= c.x;
54: deletemode := not((player.y>=c.y)and(player.y < c.y+c.height));
55: deletemode:= not deletecollidingschoolfish(c);
56: if not godmode then begin playerkilled := true;playervisibility := false end;
57: if not godmode then playerkilled := true;
59: begin c.degrees := c.degrees + I1^;
if c.degrees>=360 then c.degrees := c.degrees - 360 end;
60: begin c.degrees := c.degrees - I1^;
if c.degrees < 0 then c.degrees := c.degrees + 360 end;
61: c.degrees := I1^;
62: deletemode := c.degrees <> I1^;
63: deletemode := c.pic <> I1^;
64: goto 1;
65: c.varC := I1^;
66: deletemode := c.varC <> I1^;
67: goforward(c,I1^);
68: deletemode := allbullets > 0;
69: deletemode := points <= I1^;
70: deletemode := le;
71: deletemode := up;
72: deletemode := ri;
73: deletemode := down;
74: deletemode := touchpoleground(c);
75: deletemode := not playerabove(c);
76: switch1 := switch1 or d^;
83: levelfinished := true;
84: deletemode := alt;
85: deletemode := ctrl;
87: destroyplayerbullet(c);
88: if d^ = 2 then deletemode:= not touchborderplatform1(c)
else deletemode := not touchborderplatform2(c);
92: deletemode := fall(c);
94: begin player.pic := I1^;
player.samepicture:=0 end;
95: deletemode := player.pic <> I1^;
96: player.varC := I1^;
97: deletemode := player.pic = I1^;
102: deletemode:= c.samepicture <i1^;
103: oldpicture := c.pic;
104: if soundblaster and (38> distance (c)) then begin soundlib.closesound(0);
str(I1^,u);if opensound(0,'sound\'+u+'.wav') then startplay(0) else
opensound(0,'sound\1.wav')end;
105: deletemode := not play.stopped;
106: deletemode := goforward(c,1);
107: begin c.pic:=c.pic+1;sizeimage(c.pic,c.width,c.height); end;
108: gotolevel := c.varC;
109: if possible(c.x+i1^,c.y,c.x+i1^+c.width-1,c.y+c.height-1) then player.x:=c.x+i1^;
110: runinteractive(c,i1^);
111: centery:=i1^;
112: oldpicture:=0;
113: if c.degrees<180 then c.varA:=2 else c.varA := 1;
114: deletemode:=c.varB<> i1^;
end;
if not deletemode then
 case types[b] of
 1:delete(strtmp,1,1);
 2:delete(strtmp,1,2);
 else delete(strtmp,1,3)
 end
 else removestatement(strtmp);
end;
1: if c.pic = oldpicture then
begin if c.samepicture <> maxint then c.samepicture := c.samepicture + 1 end
else c.samepicture := 0;
end;

procedure playsoundnr(i:integer);
var s:string[6];
begin
if soundblaster then begin soundlib.closesound(0);
str(I,s);if opensound(0,'sound\'+s+'.wav') then startplay(0) else
opensound(0,'sound\1.wav')end;
end;
procedure playendsound;
begin
soundlib.closesound(0);
if opensound(0,'sound\2.wav')then begin startplay(0);
repeat until play.stopped end
end;
procedure playkillsound;
begin
soundlib.closesound(0);
if opensound(0,'sound\11.wav') then begin startplay(0);
repeat until play.stopped end
end;
procedure loadimage;
var f : file;i : integer;
begin
 ok := 0;{$i-}
 {if (path[length(path)] <> '\')and(path <> '') then path := path + '\';}
 assign(f,path+filename);
 reset(f){$i+};
 i := ioresult;
 if i <> 0 then begin ok := 1;p := nil; exit end;
 if maxavail < (128 * filesize(f)) then begin ok := 2; p := nil; exit end;
 if filesize(f) = 0 then begin close(f);p := nil; exit end;
 getmem(p,128 * filesize(f));

 blockread(f,p^,filesize(f));
 close(f);
end;
procedure removeimage;
var T : ^timage;I:integer;
begin
 if p = 0 then exit;
 {free_XMS(p);}
end;
procedure puttext;
var letterfile : file of letter;
begin
 assign(letterfile,'letters.cke');
 reset(letterfile);
 while s<> '' do begin
  seek(letterfile,ord(s[1]));read(letterfile,l);
  putletter(l,x,y,fc,bc);
  delete(s,1,1);x:=x+8;
 end;
 close(letterfile);{$i+}
end;
procedure loadstring;
begin
 getmem(p,1+length(s));
 p^:= s;
end;
procedure removeallfrommem;
var I : integer;
begin
 {$i-}free_XMS(lay1);
 free_XMS(lay4);
 if lay3 <> nil then dispose(lay3);
 lay3 := nil;
 free_xms(programmings);
 if palet <> 0 then begin
 free_xms(palet);palet:=0; end;
 XMS_error(free_xms(images));
 {dispose(creatures);
 dispose(schoolfishes);
 dispose(bullets);}
 imagecount := -1;
 restoreint9;{$i+}
end;
procedure putlay2;
begin
end;
procedure putlay4;
begin
end;
procedure putlay1;
begin
end;
procedure loadpicture;
var f : file;j:longint;
begin
 if s = '' then imageptrs[i]:= 0 else begin
 assign(f,s);{$i-}reset(f){$i+};
 if ioresult = 0 then begin
 j:= 128*filesize(f);
  blockread(f,tmpimage,filesize(f));
  imageptrs[i] := imageptr;
  imageptr := imageptr+j;
  XMS_error(MoveXMS(0,longint(@tmpimage),images,imageptrs[i],128*filesize(f)));
  close(f) end end;
end;
procedure putletter;
var i,j,b : integer;
begin
 for I := 1 to 8 do for J:= 1 to 8 do
  begin if l[i,j]= 14 then b := fc else b:= bc;
  if b >= 0 then putpixel(i+x-1,j+y-1,b);
  end;
end;
procedure putscorebox;
var I,x : integer;s: string12;
begin
 i := 111;
 if scorebox <> nil then putimage(scorebox^,1,1);
  str(points,s);x:= 69;if points <> 0 then s:=s+'00';
 for I:= length(s) downto 1 do begin putletter(numbers[s[i]],x,10,12,-1);x := x - 8 end;
 str(allbullets,s);x := 69;
 for I:= length(s) downto 1 do begin putletter(numbers[s[i]],x,25,12,-1);x := x - 8 end;
 str(lives,s);x := 29;
 for I := length(s) downto 1 do begin putletter(numbers[s[i]],x,25,12,-1);x := x - 8 end;
end;
function between(c,c1,c2:byte):byte;
begin
 if c< c1 then c:=c+c1;
 if c> c2 then c:= c-c2;
 between:= c;
end;
procedure putbackground;
var i,j : integer;
begin
 x:=x*16-16;y:=y*16-16;
 if(x<0)or(x>304)or(y<0)or(y>184) then exit;
 if b = 0 then exit;
 moveXMS(palet,longint(b-1)*256,0,longint(@tmpbackground),256);
 case crazymode of
 0: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,i+x] := tmpbackground[i,j];
 1: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[201-(j+y),i+x] := tmpbackground[i,j];
 2: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,321-(i+x)] := tmpbackground[i,j];
 3: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[201-(j+y),321-(i+x)] := tmpbackground[i,j];
 4: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,i+x] := not tmpbackground[i,j];
 5: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then putpixel(i+x,j+y,tmpbackground[i,j]);
 6: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,i+x] := tmpbackground[i,j]-1;
 7: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,i+x] := tmpbackground[i,j]+random(10);
 8: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[50+(j+y) div 2,i+x] := tmpbackground[i,j];
 9: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then
  double^[j+y,i+x] := between(tmpbackground[i,j],15,32);
 10: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,i+x] := tmpbackground[i,j]and $20;
 11: for I:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then double^[j+y,80+(i+x)div 2] := tmpbackground[i,j];
 12: for i:= 1 to 16 do for J:= 1 to 16 do if tmpbackground[i,j] <> 128 then
 double^[50+(j+y)div 2,80+(i+x)div 2]:= tmpbackground[i,j];
 end
 end;
procedure putimage;
var a : Timage absolute doelwit;I,j,teller :integer;
begin
 teller := 1;
 for I := x to x + a.width - 1 do
  for J:= y to y + a.height - 1 do
   begin
     if (I < x + a.width - 2) and not (128=a.afb[teller]) then
      putpixel(I+1,J,a.afb[teller]);teller := teller + 1;
   end;
end;
procedure putpixel;
begin
 if (y>200)or(y<1)or(x>320)or(x<1) then exit;
 case crazymode of
 1: y:=201-y;
 2: x:=321-x;
 3: begin x:=321-x;y:=201-y end;
 4: b:=not b;
 5: x:= x + y mod 10;
 6: b:= b-1;
 7: b:= b+random(10);
 8: y:= 50+y div 2;
 9: b:=between(b,15,32);
 10: b:= b and 32;
 11: x:= 80+x div 2;
 12: begin x:= 80+x div 2;y:= 50+y div 2 end;
 end;
 if (y>200)or(y<1)or(x>320)or(x<1) then exit;
 double^[y,x]:= b
end;
procedure makeerror;
begin
 removeallfrommem;
 textmode(c80);
 writeln('An error occur. Mail to M.jordaan@kabelfoon.nl for report');
 writeln(s);
end;
procedure sizeimage;
var t : ^timage;
begin
 if (imageptrs[i] = 0) then
 begin w:= 1; h:=1 end else
 case i of
 1..84: begin w:= 2;h:=2 end;
 86..93: begin w:= 6;h:=6 end;
 135..140: begin w:= 2; h:=1 end;
 else begin
  t:= addr(tmpimage);
  XMS_error(moveXMS(images,imageptrs[i],0,longint(@tmpimage),4));
  w := round(t^.width /16.0+0.5);h:= round(t^.height / 16+0.5);
end end;
 if w < 1 then w:= 1;if h<1 then h:=1;
 end;
function getbackground;
begin
if (x<0)or(x>levelwidth)or(y<1) then getbackground:= 1 else
if y>levelheight then getbackground:=5 else
getbackground := backgrounds^[longint(levelwidth)*y-longint(levelwidth)+x+1];
end;
procedure setbackground;
begin
 backgrounds^[longint(levelwidth)*y-longint(levelwidth)+x+1]:=b;
end;
procedure setlay1;
begin
 if (x<0)or(x>levelwidth)or(y<1)or(y>levelheight) then exit;
 moveXMS(0,longint(@b),lay1,2*(longint(levelwidth)*y-longint(levelwidth)+x),2);
 {lay1^[longint(levelwidth)*y-longint(levelwidth)+x+1]:= b;}
end;
procedure setlay4;
begin
 if (x<0)or(x>levelwidth)or(y<1)or(y>levelheight) then exit;
 moveXMS(0,longint(@b),lay4,2*(longint(levelwidth)*y-longint(levelwidth)+x),2);
 {lay4^[longint(levelwidth)*y-longint(levelwidth)+x+1]:= b;}
end;
procedure setlay3;
begin
 if (x<0)or(x>levelwidth)or(y<1)or(y>levelheight) then exit;
 lay3^[longint(levelwidth)*y-longint(levelwidth)+x+1]:=b;
 {if b = 0 then setbackground(x,y,0) else
 begin moveXMS(bgtype,-1+b,0,longint(@pos),1);setbackground(x,y,pos) end;}
end;
function getlay4;
var b: integer;
begin
 moveXMS(lay4,longint(2)*(longint(levelwidth)*y-longint(levelwidth)+x),0,longint(@b),2);
 getlay4:=b;
 {getlay4 := lay4^[longint(levelwidth)*y-longint(levelwidth)+x+1]}
end;
function getlay3;
begin
 getlay3 := lay3^[longint(levelwidth)*y-longint(levelwidth)+x+1]
end;

function getlay1;
var b : integer;
begin
 moveXMS(lay1,longint(2)*(longint(levelwidth)*y-longint(levelwidth)+x),0,longint(@b),2);
 getlay1:=b;
 {getlay1 := lay1^[longint(levelwidth)*y-longint(levelwidth)+x+1]}
end;
procedure destroybullets;
var I : integer;
begin
 for I:= 1 to 255 do
  begin
  tmpcreature:= bullets^[i];
  if tmpcreature.delete  or ((tmpcreature.x<1)or(tmpcreature.x>levelwidth)or(tmpcreature.y<1)or
 (tmpcreature.y>levelheight))then
                             if tmpcreature.pic = 46 then
                               begin
                               bullets^[i].pic := 0;
                               bullets^[i].delete:=false
                               end
                               else tmpcreature.pic := 46;
end
end;
procedure destroyschoolfishes;
var I : integer;
begin
 for I:= 1 to 255 do
  if creatures^[schoolfishes[i]].delete and (creatures^[schoolfishes[i]].pic <> 0) then
   schoolfishes[i]:= 0;
end;
procedure destroycreatures;
var I : integer;
begin
 for I:= 1 to 255 do
  if creatures^[i].delete and(creatures^[i].pic<>0) then creatures^[i].pic:=0;
end;
function availablecreature(I : integer): boolean;
begin
 availablecreature := creatures^[i].pic <> 0;
end;
function addcreature;
var I,j : Integer;
begin
 I := 1;
 for I:= 1 to 256
 do
 if not availablecreature(i) then begin j:= i;break end;
 if I > 255 then exit;
 fillchar(tmpcreature,sizeof(creature),chr(0));
 tmpcreature.x := x;
 tmpcreature.y := y;
 tmpcreature.pic := picture;
 sizeimage(tmpcreature.pic,tmpcreature.width,tmpcreature.height);
 tmpcreature.degrees := degrees;
 creatures^[i] := tmpcreature;
 addcreature:=i;
end;


procedure drawscreen;
begin
 putlay4(toscreen);
 putlay2(toscreen);
 putlay1(toscreen);
 putscorebox;
end;
procedure setplayer;
begin
 if b = 1 then defaultplayer(player) else
 defaultswimplayer(player);

end;
{procedure makespaceforschoolfishes;
var J :integer;
begin
 if schoolfishcount = -1 then begin
  schoolfishcount := I;
 end else begin
 for J := 1 to schoolfishcount do if schoolfishes[j].c <> nil then dispose(schoolfishes[j].c);
 schoolfishcount := I;
 schoolfishptr := 0;
 end
 end;
procedure makespaceforbullets;
var J :integer;
begin
 if bulletscount = -1 then begin
  bulletscount := I; end else begin
 for J := 1 to bulletscount do if bullets[j].c <> nil then dispose(bullets[j].c);
 bulletscount := I;
 bulletptr := 0;
 end
 end;
procedure makespaceforcreatures;
var J :integer;
begin
 if creaturescount = -1 then begin
  creaturescount := I;
 end else begin
 for J := 1 to creaturescount do if (creatures[j].c <> nil)and not creatures[j].b then dispose(creatures[j].c);
 creaturescount := I;end;
 creatureptr := 0;
 for J:= 1 to i do
 begin
 creatures[i].b:=false;
 creatures[i].c := nil
end
end;}
{procedure makespaceforimages;
var J :integer;
begin
 if imagecount = -1 then begin
  imagecount := I;getmem(images,I*4);
  getmem(programmings,i*4);
 end else begin
 for J := 1 to imagecount do begin if images^[j] <> 0 then removeimage(images^[j]);
 if programmings^[j]<> nil then freemem(programmings^[j],1+ length(programmings^[j]^))
 end;
 if imagecount <> 0 then begin freemem(images,imagecount*4);freemem(programmings,imagecount*4) end;
 imagecount := I;getmem(images,I*4);getmem(programmings,i*4);
 end;
 fillchar(images^,4*i,chr(0));
 fillchar(programmings^,4*i,chr(0));
 end;}
procedure defaultplayer;
begin
 fillchar(tmpcreature,sizeof(creature),chr(0));
 with tmpcreature do begin
  x := 15;y := 20; pic := 1;
  width := 1; height := 2;
 end
end;
procedure defaultswimplayer;
begin
 fillchar(tmpcreature,sizeof(creature),chr(0));
 with tmpcreature do begin
  x:= 15; y:= 20;pic := 135;
  width := 2; height := 1;
  end;
  end;
function maxhigh;
var I,max : integer;
begin
 seek(neededfile,c.pic);
 read(neededfile,tmp);
 max := c.pic;I:=1024;
 while I > max do
  begin
   if tmp[i] then max := i;
   I := I + 1;
  end;
 maxhigh := max
end;
procedure closesound;
begin
soundlib.closesound(0);
end;
procedure initfiles;
begin
 assign(neededfile,'whichpic.cfg');
 assign(filenames,'filename.cfg');
 assign(programmingfile,'program.cke');
 reset(programmingfile);
 reset(filenames);reset(neededfile);
end;
procedure loadimages;
type t = array[1..1024]of byte;
var I:integer;s:string[15];xmsmemavail,k : word;
a:t;filename:string12;
begin
 XMS_error(Query_free_XMS(k,XMSmemavail));
 seek(filenames,1);
 for I:= 1 to 900 do begin
 fillchar(tmpimage,3,0);
 read(filenames,filename);
 loadpicture(filename,I);
 end;
 for I:= 901 to 1023 do begin
 fillchar(tmpimage,3,0);
 read(filenames,filename);
 if filename = '' then imageptrs[i]:=0 else loadpicture('gm\'+filename,I);
 end;
end;
procedure restorescreen;
begin
r.ax := 19; intr(16,r);
end;
procedure fillimage;
var w,h,a,b : integer;
begin
 sizeimage(i,w,h);
 w:=16*w;h:=h*16;
 for a:= 0 to 1+320 div w do for B:= 0 to 1+200 div h do
 putimageEMB(i,1+a*w,1+b*h);
end;
procedure restorebackgrounds;
var I:longint;
begin
for I:= 1 to longint(levelwidth)*longint(levelheight) do
if lay3^[i] = 0 then backgrounds^[i]:= 0 else moveXMS(bgtype,lay3^[i]-1,0,longint(@backgrounds^[i]),1);
end;
procedure loadpalet;
var paletinf:file;i:integer;
t:longint;
begin
 E_allocate_XMS(2048,palet);
 assign(paletinf,filename+'inf.cke');
 reset(paletinf,1);
 allocate_XMS(1+filesize(paletinf)div 1024,bgtype);
 blockread(paletinf,tmpimage,filesize(paletinf));
 moveXMS(0,longint(@tmpimage),bgtype,0,filesize(paletinf));
 paletinfsize:= filesize(paletinf);
 close(paletinf);
 assign(paletinf,filename+'.cke');
 reset(paletinf,1);
 paletsize:=filesize(paletinf);
 t:=0;
 while not eof(paletinf) do begin if filesize(paletinf)-filepos(paletinf)<12000
 then begin i:= filesize(paletinf)-filepos(paletinf);blockread(paletinf,tmpimage,i) end else begin
 i:=12000;
 blockread(paletinf,tmpimage,12000) end;
 moveXMS(0,longint(@tmpimage),palet,t,i);
 t:= t+i;
 end;
 close(paletinf);
end;
procedure loadprogrammings;
var i:longint;
begin
 for I:= 1 to 1023 do begin read(programmingfile,stri);
 XMS_error(moveXMS(0,longint(@stri),programmings,129*i,129)) end
end;
begin
 soundblaster := initblaster;
 if not xms_flag then begin writeln('NO XMS-MEMORY FOUND');exit end;
 writeln ('XMS memory:');
 XMS_error(query_free_XMS(k,xmsmemavail));
 writeln ('total available = ',xmsmemavail,' kB');
 writeln ('largest block   = ',k,' kB');
 testspeed;
 allkeys.start;
 if soundblaster then if opensound(0,'sound\1.wav') then begin
 startplay(0);
 repeat until play.stopped
 end else soundblaster := false;
 lastimage := -1;switch1 := 0;
 palet:=0;
 assign(letterfile,'letters.cke');
 reset(letterfile);
 seek(letterfile,48);
 for I := '0' to '9' do read(letterfile,numbers[I]);
 close(letterfile);
 imagecount := -1;
 maxloaded := 0;levelwidth := 0;levelheight := 0;
 backgrounds :=  nil;current := ptr($A000,$0);new(tmplay);
 double:=@tmplay^;
 fillchar(double^,64000,chr(0));
 fillchar(current^,64000,chr(0));
 r.ax := 19; intr(16,r);
 playerkilled :=false;playervisibility := false;
 levelfinished := false;
 fillchar(player,sizeof(player),chr(0));
 loadimage(scorebox,'scorebox.pic','',lastimage);
 timescreens:=100;lastimage := -1;
 assign(tmpcrefile,'tmpcrt.$$$');
 rewrite(tmpcrefile);
 close(tmpcrefile);
 assign(tmpcrefile,'tmpcrt.$$$');
 reset(tmpcrefile);
 godmode := false;
 noclipping := false;
 oudspatie := false;
 oldeditormode:=false;
 oudalt := false;
 jumpcheat := false;
 slowmotion := false;
 imageptr := 1;
 gotolevel:= 0;
 gamemap:=false;
 sandwich:=false;
 centerptr:=0;
 ticeblock:=nonepl;
 tsemiblock:=nonepl;
 new(lay3);
 new(backgrounds);
 new(creatures);
 new(bullets);
 XMS_error(E_allocate_XMS(1024,images));
 XMS_error(E_allocate_XMS(129,programmings));
 XMS_error(E_allocate_XMS(65,lay1));
 XMS_error(E_allocate_XMS(65,lay4));
end.