#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#if defined(unix) && !defined(GO32)
#include <unistd.h>
#define SEPARATOR '/'
#else
#define SEPARATOR '\\'
#endif

#define NUM 56

unsigned long read_long (FILE *fp);
void write_long (unsigned long r, FILE *fp);
void write_sfx (char *name, long start, long len, FILE *in);

long start[256];
long len[256];

    char *sfxnames[NUM]={"amazing.wav", "boring.wav", "brilliant.wav", 
	"bummer.wav", "bungee.wav", "byebye.wav", "collect.wav",
	"comeonthen.wav", "coward.wav", "dragonpunch.wav", "drop.wav", 
	"excellent.wav", "fatality.wav", "fire.wav", "fireball.wav", 
	"firstblood.wav", "flawless.wav", "goaway.wav", "grenade.wav",
	"hello.wav", "hmm.wav", "hurry.wav", "illgetyou.wav", "incoming.wav", 
	"jump1.wav", "jump2.wav", "justyouwait.wav", "kamikaze.wav", 
	"laugh.wav", "leavemealone.wav", "missed.wav", "nooo.wav", 
	"ohdear.wav", "oinutter.wav", "ooff1.wav", "ooff2.wav", "ooff3.wav", 
	"oops.wav", "orders.wav", "ouch.wav", "ow1.wav", "ow2.wav", 
	"ow3.wav", "perfect.wav", "revenge.wav", "runaway.wav", 
	"stupid.wav", "takecover.wav", "traitor.wav", "uh-oh.wav", 
	"victory.wav", "watchthis.wav",	"whatthe.wav", "wobble.wav",
	"yessir.wav", "youllregretthat.wav"};
    int sfxnums[NUM]={-1,45, 54,
	24,46,47,67,
	48,50,59,-1, /* drop */
	54,57,58,52,
	60,61,39,31,
	28,-1,34,35,-1, /* incoming */
	32,33,36,37,
	38,39,41,42, /* nooo */
	1,2,3,4,5,
	24,-1,6,6,7,
	8,9,0,16, /* runaway */
	15,16,19,-1,
	68,22,23,25,
	26,27};

int main (int argc, char **argv)
{
    FILE *fp;

    char *name;
    static char dname [512]; /* This damned well should be enough! */
    int i;
    
    if (argc != 2)
    {
	fprintf (stderr, "Usage: sfxconv <filename>\n");
	return 1;
    }
    
    fp = fopen (argv[1], "rb");
    if (!fp)
    {
	fprintf (stderr, "Can't open %s. Aborting.\n", argv[1]);
	return 1;
    }

    name = strrchr (argv[1], SEPARATOR);
    if (!name)
	name=argv[1]-1;
    name++;
    if (strchr (name, '.')) /* Should be! */
	*strchr (name, '.')=0;
    
    sprintf (dname, "data%cwav%cspeech%c%s", SEPARATOR, SEPARATOR,
	     SEPARATOR, name);
    if (mkdir (dname, 777))
    {
	perror ("Error creating directory");
	fprintf (stderr, "Aborting.\n");
	return 1;
    }
    if (chdir (dname))
    {
	perror ("Error changing directory");
	fprintf (stderr, "Aborting.\n");
	return 1;
    }
    
    for (i = 0; i < 256; i++)
	start[i]=read_long (fp);
    for (i = 0; i < 256; i++)
	len[i]=read_long (fp)-start[i];
    for (i=0; i < NUM; i++)
	if (sfxnums[i] != -1)
	    write_sfx (sfxnames[i], start[sfxnums[i]], len [sfxnums[i]], fp);
    sprintf (dname, "..%c..%c..%c..", SEPARATOR, SEPARATOR, SEPARATOR);
    chdir (dname);
    printf ("Complete.");
}

void write_sfx (char *name, long start, long len, FILE *in)
{
    FILE *out;
    long i, j;
    char g;

    out = fopen (name, "wb");
    if (!out)
    {
	printf ("Can't open file %s for writing.\n", name);
	return;
    }
    fseek (in, start+2048, SEEK_SET);

    fprintf (out, "RIFF");
    write_long (len+0x24, out);
    fprintf (out, "WAVE");
    fprintf (out, "fmt ");
    write_long ((long)16, out);
    write_long ((long)(1+65536), out); /* wFormatTag, nChannels */
    write_long ((long)15000, out); /* nSamplesPerSec */
    write_long ((long)15000, out); /* nAvgBytesPerSec */
    write_long ((long)1+8*65536, out); /* nBlockAlign, FormatSpecific */
    fprintf (out, "data");
    write_long ((long)len, out);
    for (j=0; j < len; j++)
    {
	g = fgetc (in) ^ 128;
	fputc (g, out);
    }
    fclose (out);
}

unsigned long read_long (FILE *fp)
{
    unsigned long r;
    unsigned char g;

    g = fgetc (fp);
    r = g;
    g = fgetc (fp);
    r+= ((unsigned long) g) << 8;
    g = fgetc (fp);
    r+= ((unsigned long) g) << 16;
    g = fgetc (fp);
    r+= ((unsigned long) g) << 24;
    r+= g;
    return r;
}

void write_long (unsigned long r, FILE *fp)
{
    fputc (r & 0xff, fp);
    fputc ((r >> 8) & 0xff, fp);
    fputc ((r >> 16) & 0xff, fp);
    fputc ((r >> 24), fp);
}
