/***************************************************************************
 *
 *                                Quake Admin v3.0
 *			Created By: MHacker (mhacker@HToC.com)
 *
 **************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include "../include/qadmin.h"

void is_running(void) {
   int fd, qpid;

   char tmp[25];
   bzero(tmp, sizeof(tmp));
   fd = open(PIDFILE, O_RDONLY);
   if (fd == -1) return;

   read(fd, tmp, 19);
   qpid = atoi(tmp);
   if (kill(qpid, SIGUSR1) != -1) {
      fprintf(stderr, "Quake Admin is already running under pid %d\n", qpid);
      close(fd);
      exit(1);
   }
   close(fd);
}

void save_pid() {
   int fd;
   char tmp[25];
   
   bzero(tmp, sizeof(tmp));
   unlink(PIDFILE);
   if ((fd = open(PIDFILE, O_WRONLY | O_CREAT | O_APPEND, (mode_t)0600)) == -1) {
      fprintf(stderr, "Can't open pid for writing: %s\n", strerror(errno));
      close(fd);
      exit(-1);
   }
   sprintf(tmp, "%d", getpid());
   if (write(fd, tmp, strlen(tmp)) == -1) {
      fprintf(stderr, "Cannot write to file: %s\n", strerror(errno));
      close(fd);
      exit(-1);
   }
}

void log (char *filename, char *format, ...)
{
   va_list arglist;
   char *doit;
   FILE *fp;
   if (!(fp = fopen(filename, "a"))) {
      fprintf(stderr, "Can't write logfile: %s\n", strerror(errno));
      exit(1);
   }
   va_start(arglist, format);
   vfprintf(fp, format, arglist);
   va_end(arglist);
   fclose(fp);
}

int serveractive(void)
{
   FILE *server;
   char temp[100];
   char test[300];
   
   sprintf(temp, "/bin/ps auxww |grep qwsv |grep -v \"grep qwsv\" > /tmp/tmp.%d\n", getpid());
   system(temp);
   sprintf(temp, "/tmp/tmp.%d", getpid());
   server = fopen(temp, "r");
   if (!server) {
        unlink(temp);
        return 1;
   }
   if (!fgets(test, sizeof(test), server)) {
        unlink(temp);
	return 1;
   }
   unlink(temp);
   return 0;
}
   
int checkserv(void) {
   FILE *server;
   char temp[100];
   char test[300];
   int spid;

   sprintf(temp, "/bin/ps ax | grep qwsv | grep -v grep | cut -c1-5 > /tmp/tmp.%d\n", getpid());
   system(temp);
   sprintf(temp, "/tmp/tmp.%d", getpid());
   server = fopen(temp, "r");

   fgets(test, sizeof(test), server);
   unlink(temp);
   fclose(server);
   spid = atoi(test);
   return spid;
}
