/***************************************************************************
 *
 *                                Quake Admin v3.0
 *			Created By: MHacker (mhacker@HToC.com)
 *
 **************************************************************************/

#include <sys/wait.h>
#include <strings.h>
#include <signal.h>
#include "../include/qadmin.h"

struct sockaddr_in client_addr;
static Admin *adminlist = NULL;

void main() {
   fd_set listen_fdset;
   fd_set result_fdset;
   int total_fds = 0, one = 1;
   int fs, fd;
   FILE *name;
   struct sockaddr_in serv_addr;
   
   signal(SIGINT, sighandler);
   signal(SIGTERM, sighandler);
   signal(SIGPIPE, SIG_IGN);
   signal(SIGQUIT, sighandler);
/*   signal(SIGSEGV, sighandler); */
   signal(SIGBUS, sighandler);
   signal(SIGUSR1, SIG_IGN);
   signal(SIGQUIT, sighandler);
   signal(SIGHUP, rehash);
   signal(SIGILL, sighandler);
   signal(SIGTRAP, sighandler);
   signal(SIGIOT, sighandler);
   signal(SIGFPE, sighandler);
   signal(SIGALRM, SIG_IGN);
   signal(SIGUSR2, SIG_IGN);
   signal(SIGCHLD, sighandler);
   signal(SIGWINCH, SIG_IGN);
   signal(SIGTTIN, SIG_IGN);
   signal(SIGTTOU, SIG_IGN);
   signal(SIGTSTP, SIG_IGN);

   bzero(nick, sizeof(nick));
   
   check_conf();
   load_conf();
   is_running();
   printf("[2J[1;1H[15C[0;1;34m-[0;34m=[0m Quake Administration v%s by Warren Rees [HToC] [34m=[1m-\n", VERSION);
   printf("  [0;34m.--------------------------------------------------------------------------.\n");
   printf("  | [1;37mS[0merver [1mN[0mame [1m-[60C[0;34m|\n");
   printf("  `--------------------------------------------------------------------------'\n");
   printf("  .--------------------------.--- [1;37mS[0merver [1mS[0mettings [34m----.----------------------.\n");
   printf("  |[5C[1;37mU[0mserfile [1m-[36C[0;34m|[8C[1;37mP[0mort [1m- [0m       [34m|\n");
   printf("  | [1;37mR[0memote [1mA[0mdmin [1m-[11C[0;34m|[24C| [1;37mI[0mp [1mC[0mhecking [1m- [0m       [34m|\n");
   printf("  |[7C[1;37mR[0memote [1mA[0mdd [1m- [0m      [34m|  [1;37mR[0memote [1mR[0memove [1m- [0m      [34m| [1;37mR[0memote [1mE[0mdit [1m- [0m       [34m|\n");
   printf("  | [1;37mE[0mncrypt [1mP[0mwds [1m- [0m   [7C[34m|  [1;37mA[0mllow [1mP[0mChange [1m- [0m      [34m|[22C|\n");
   printf("  `--------------------------'------------------------`----------------------'\n");
   printf("\n");
   printf("  .--------------------------------------------------------------------------.\n");
   printf("  | [1;37mS[0mtatus [1m-[65C[0;34m|\n");
   printf("  `--------------------------------------------------------------------------'\n");
   printf("[0m\n");
   printf("[13;14H                             \n");
   printf("[13;14HLoading Configuration File... \n");
   sleep(1);
   printf("[3;19H%.60s\n", sname);
   printf("[6;20H%.34s\n", userfile);
   printf("[6;71H%d\n", port);
   printf("[7;71H%.3s\n", ipcheck?"Yes":"No");
   printf("[7;20H%.3s\n", radmin?"Yes":"No");
   if (radmin) {
      printf("[8;24H%.3s\n", r_add?"Yes":"No");
      printf("[8;49H%.3s\n", r_remove?"Yes":"No");
      printf("[8;71H%.3s\n", r_edit?"Yes":"No");
   } else {
      printf("[8;24HN/A\n");
      printf("[8;49HN/A\n");
      printf("[8;71HN/A\n");
   }
   printf("[9;20H%.3s\n", u_encrypt?"Yes":"No");
   printf("[9;49H%.3s\n", u_pchange?"Yes":"No");
   printf("[13;14H                             \n");
   printf("[13;14HLoading User File... \n");
   sleep(1);
   load_userfile(userfile);
   printf("[13;14H                             \n");
   printf("[13;14HForking as pid: %d\n", getpid()+1);
   printf("[15;1H[0m\n");

   if ((fs = fork()) == -1) {
      log(LOGFILE, "Error daemonizing fork: %s\n", strerror(errno));
      exit(-1);
   } else if (fs == 0) {
      setsid();
      umask(0);
   } else {
      exit(0);
   }
   log(LOGFILE, "[%s] <%d> +++ Quake Admin Booting Up\n", date(), getpid());
   save_pid();
   if ((socketfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
      log(LOGFILE, "Failed to allocate socket\n");
      exit(-1);
   }
   if ((setsockopt(socketfd, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(int))) == -1) {
      log(LOGFILE, "failed to set SO_REUSEADDR\n");
      exit(-1);
   }
   memset((void *)&serv_addr, 0, sizeof(struct sockaddr_in));
   serv_addr.sin_family = PF_INET;
   serv_addr.sin_port = htons(port);
   serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

   if (bind(socketfd, (struct sockaddr *)&serv_addr, sizeof (struct sockaddr_in)) == -1) {
      log(LOGFILE, "failed to bind port %d - %s\n", port, strerror(errno));
      exit(-1);
   }
   if (listen(socketfd, 5) == -1) {
      log(LOGFILE, "Listen failed for port %d - %s\n", port, strerror(errno));
      exit(-1);
   }
   
   FD_ZERO(&listen_fdset);
   FD_SET(socketfd, &listen_fdset);
   if (socketfd > total_fds)
      total_fds = socketfd;
   total_fds++;

   while (1) {
      if (arehash) {
         total_fds = 0;
         FD_ZERO(&listen_fdset);
         FD_SET(socketfd, &listen_fdset);
         if (socketfd > total_fds)
            total_fds = socketfd;
         total_fds++;
         arehash = 0;
      }
      result_fdset = listen_fdset;

      if (select(total_fds, &result_fdset, NULL, NULL, NULL) == -1) {
         if (errno != EINTR) {
            log(LOGFILE, "Select Failed: %s\n", strerror(errno));
         }
      } else {
         if (FD_ISSET(socketfd, &result_fdset)) {
            int client_fd, address_size;
            char *ip, *ipname, *luser;
            struct sockaddr_in client_addr;
            struct hostent *he;
            
            address_size = sizeof(struct sockaddr_in);
            client_fd = accept(socketfd, (struct sockaddr *)&client_addr, &address_size);

            if (client_fd == -1) {
               log(LOGFILE, "Accept error: %s\n", strerror(errno));
            } else {
               if ((fs = fork()) == 0) {
                  rehash(2);
                  ip = inet_ntoa(((struct sockaddr_in *)&client_addr)->sin_addr);

                  if ((he = gethostbyaddr((char *)&((struct sockaddr_in *)&client_addr)->sin_addr, sizeof(client_addr), PF_INET)))
                     ipname = strdup(he->h_name);

                  luser = checkident(ip, ntohs(client_addr.sin_port), port);

                  if (!ipname)
                     log(LOGFILE, "[%s] +++ Telnet connection from %s@%s fd: %d\n", date(), luser, ip, client_fd);
                  else
                     log(LOGFILE, "[%s] +++ Telnet connection from %s@%s fd: %d\n", date(), luser, ipname, client_fd);

                  accept_conn(client_fd, ip, luser);

               } else if (fs > 0) {
                  close(client_fd);
               } else {
                  log(LOGFILE, "fork for connection %s failed: %s\n", strerror(errno));
               }
            }
         }
      }
   }
}

void sighandler(int signal)
{
   int status, pid;
   if (signal == SIGCHLD) {
      while ((pid = wait3(&status, WNOHANG, (struct rusage *) 0)) > 0) {
         ;
      }
   } else {
      sprintf(temp, "Quake Admin Terminating: %s\n", sys_siglist[signal]);
      log(LOGFILE, "[%s] <%d> --- %s", date(), getpid(), temp);
      exit(1);
   }
}

void rehash(int x) {
   int ppid, one = 1;
   Admin *admin = adminlist;
   struct sockaddr_in serv_addr;

   osfd = socketfd;
   check_conf();
   oport = port;
   load_conf();
   while (admin) {
      del_admin(admin);
      admin = admin->next;
   }
   free(admin);
   adminlist = NULL;
   load_userfile(userfile);
   if (x != 2)
      log(LOGFILE, "[%s] *** Rehashing Configuration files.\n", date());
   opid = getpid();
   if (oport != port) {
      close(osfd);
      if ((socketfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
         log(LOGFILE, "[%s] --- Failed to allocate a socket: %s\n", date(), strerror(errno));
         exit(1);
      }
      if ((setsockopt(socketfd, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(int))) == -1) {
         log(LOGFILE, "[%s] --- Failed to set SO_REUSEADDR\n");
         exit(1);
      }
      memset((void *)&serv_addr, 0, sizeof (struct sockaddr_in));
      serv_addr.sin_family = PF_INET;
      serv_addr.sin_port = htons(port);
      serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

      if (bind (socketfd, (struct sockaddr *)&serv_addr, sizeof(struct sockaddr_in)) == -1) {
         log(LOGFILE, "[%s] --- Failed to bind on port %d - %s\n", date(), port, strerror(errno));
         exit(1);
      }
      if (listen(socketfd, 5) == -1) {
         log(LOGFILE, "[%s] --- Failed to listen on port %d - %s\n", date(), port, strerror(errno));
         exit(1);
      }
      log(LOGFILE, "[%s] +++ Rebound port %d to port %d fd: %d\n", date(), oport, port, socketfd);
      arehash = 1;
   }
}
