/***************************************************************************
 *
 *                                Quake Admin v3.0
 *			Created By: MHacker (mhacker@HToC.com)
 *
 **************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include "../include/qadmin.h"

int make_connection(int port)
{
   int soc_des, soc_cli, soc_rc, soc_len, server_pid, cli_pid;
   struct sockaddr_in serv_addr;

   soc_des = socket(AF_INET, SOCK_STREAM, 0);
   if (soc_des == -1)
      return(-1);
#ifdef BSDSYS
   setsockopt(soc_des, SOL_SOCKET, SO_REUSEPORT, 0, 0);
#endif
   setsockopt(soc_des, SOL_SOCKET, SO_KEEPALIVE, 0, 0);
   bzero((char *) &serv_addr, sizeof(serv_addr));
   serv_addr.sin_family = AF_INET;
   serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
   serv_addr.sin_port = htons(port);
   soc_rc = bind(soc_des, (struct sockaddr *) &serv_addr, sizeof(serv_addr));
   if (soc_rc != 0)
      return (-1);
   soc_rc = listen(soc_des, 64);
   if (soc_rc != 0) 
      return (-1);

   return soc_des;
}   

int readln2(int fd2) {
   char ch;
   int i = 0;
   line[0] = '\0';
   do {
      if (read(fd2, &ch, 1) < 1) return(0);
      if (ch >= 32 && ch <= 126)
         if (i < MAXLEN -1) line[i++] = ch;
   } while(ch != '\n');
   line[i] = '\0';
   return 1;  }

int writeln2(int sock, char *buffer) {
   if (write(sock, buffer, strlen(buffer)) < 0) return(0);
   return 1;
}

char *checkident(char *ip, int sinp, int rport)
{
   char *user;
   int lame, lport, fport;
   char buffer[8192];
   char *cp;
   FILE *fp_in, *fp_out;
   char reply_type[81];
   char opsys_or_error[81];
   char identifier[1024];

   int fd2, port, addrlen;
   struct sockaddr_in addr;
   user = "unknown";

   fd2 = socket(AF_INET, SOCK_STREAM, 0);
   if (fd2 == -1)
      return user;

   addr.sin_family = AF_INET;
   addr.sin_addr.s_addr = inet_addr(ip);
   port = 113;
   addr.sin_port = htons(port);
   addrlen = sizeof(addr);  
   if (connect(fd2, (struct sockaddr *) &addr, addrlen) == -1)
      return user;

   addrlen = sizeof(addr);

   if (getsockname(fd2, (struct sockaddr *) &addr, &addrlen) == -1)
      return user;

   fp_in = fdopen(fd2, "r");
   fp_out = fdopen(fd2, "w");

   if (!fp_in || !fp_out)
      return user;

   fprintf(fp_out, "%d , %d\n", sinp, rport);
   fflush(fp_out);

   if (!fgets(buffer, sizeof(buffer)-1, fp_in))
      return user;

   fclose(fp_out);
   fclose(fp_in);

   shutdown(fd2, 1);
   cp = buffer;
   while (*cp != 0 && (*cp < ' ' || isspace(*cp)))
     ++cp;

   lame = sscanf(cp, "%d , %d : %[^ \t\n\r:] : %[^\t\n\r:] : %[^\n\r]", 
                 &lport, &fport, reply_type, opsys_or_error, identifier);

   if (Stricmp(reply_type, "ERROR") == 0)
      return user;
   else if (Stricmp(reply_type, "USERID") != 0)
      return user;
   else {
      user = sstrdup(identifier);
      return user;
   }
}

int stou(int fd, char *format, ...) {
   va_list arglist;
   char buffer[MAXBUF];
   va_start(arglist, format);
   vsprintf(buffer, format, arglist);
   va_end(arglist);
   return(writeln2(fd, buffer));
}
