indexing
    description    : "Allegro con Eiffel: midi objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : midi
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class MIDI


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    load

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    load(filename : STRING) is
    -- Create a new midi from the specified file
    require
        ace_initialised   : info.ace_initialised
        filename_is_valid : filename /= Void and then
                            ace_file_tools.exists(filename) and then
                            ace_file_tools.extension(filename).same_as("MID")
    local
        p : POINTER
    do
        if is_valid then
            discard
        end  -- if

        p := filename.to_external
        c_inline_c("C->_data=load_midi(_p);")
    ensure
        is_valid : is_valid
    end  -- feature load


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a midi from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid : is_valid
    end  -- feature make_from_external


------------------------------------------------------ Internal features (MIDI)
feature { MIDI }

    data : POINTER


------------------------------------------------------ Internal features (NONE)
feature { NONE }

    ace_file_tools : ACE_FILE_TOOLS


------------------------------------------------------ Midi features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this midi is valid or not
    do
        Result := data.is_not_void
    end  -- feature is_valid


    discard is
    -- Discard this midi
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("destroy_midi(C->_data);C->_data=NULL;")
    ensure
        not_valid : not is_valid
    end  -- feature discard


    play(looped : BOOLEAN) is
    -- Play this midi
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
    do
        c_inline_c("play_midi(C->_data,a1);")
    end  -- feature play


    stop is
    -- Stop playing this midi
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
    do
        c_inline_c("stop_midi();")
    end  -- feature stop


    beat : INTEGER is
    -- The current beat number in this midi file
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
    do
        c_inline_c("R=midi_pos;")
    end  -- feature beat


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies data.is_not_void and
                  not is_valid implies data.is_void


end  -- class MIDI
