indexing
    description    : "Allegro con Eiffel: mouse_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : mouse_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class MOUSE_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        mode_set_success : BOOLEAN
    do

--------------------------------------------------- Allegro initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("Allegro initialisation error: ")
        end  -- if

        -- Check whether the mouse is installed
        if not mouse.is_installed then
            crash_with_message("No mouse detected.")
        end  -- if

        -- Initialise the timer
        if not timer.init_success then
            crash_with_message("Timer initialisation failed.")
        end  -- if


--------------------------------------------------- Set a graphics mode

        -- Set a graphics mode
        wait_for_key("%NAbout to set 320x200x256 mode...")
        mode_set_success := screen.auto_init(320, 200, 0, 0)

        -- Check for mode set success
        if not mode_set_success then
            crash_with_message("Mode set failed: ")
        end  -- if

        -- Set the desktop palette so we can actually see something
        c_inline_c("set_palette(desktop_palette);")

--------------------------------------------------- Mouse routines

        -- Draw some text onto the screen
        screen.put_string(2,  2, 15, default_font, screen.driver_name)
        screen.put_string(2, 12, 15, default_font, screen.driver_description)
        screen.put_string(2, 22, 15, default_font, "Press ENTER to exit.")

        -- Show the mouse cursor
        mouse.show

        -- Wait for a keypress
        io.read_character

        -- Return to text mode
        screen.shutdown
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the allegro error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class MOUSE_TEST
