indexing
    description    : "Allegro con Eiffel: packed file objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : pack_file
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


deferred class PACK_FILE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON

    STD_FILE                   -- redefine inheritance
        redefine
            connect_to,
            disconnect,
            is_connected,
            fopen,
            fclose,
            fputc,
            fgetc,
            feof
    end                        -- inherit STD_FILE


------------------------------------------------------ Creation features
feature { ANY }

    connect_to(new_path : STRING) is
    -- Connect to the given file
    require
        ace_initialised   : info.ace_initialised
        not_connected     : not is_connected
        path_is_void      : path = Void
        new_path_is_valid : not new_path.empty
    deferred
    end  -- feature connect_to


    disconnect is
    -- Disconnect from the currently connected file
    require
        ace_initialised : info.ace_initialised
        connected       : is_connected
    deferred
    end  -- feature disconnect


    is_connected: BOOLEAN is
    -- Are we currently connected to a file?
    require
        ace_initialised : info.ace_initialised
    do
        Result := path /= Void
    end  -- feature is_connected


------------------------------------------------------ Internal features
feature { NONE }

    -- The access mode of the file ("r"=read, "w"=write, "p"=packed (modifier),
    -- "!"=write unpacked with magic marker at the front of the file)
    -- NOTE: These routines CANNOT be used to read normal files, use
    -- class STD_FILE instead.
--    mode : STRING


    fopen(f : STRING; m : STRING) : POINTER is
    -- Open a packed file
    require
        ace_initialised   : info.ace_initialised
        filename_is_valid : f /= Void
        mode_is_valid     : m /= Void
    local
        pf : POINTER
        pm : POINTER
    do
        pf := f.to_external
        pm := m.to_external
        c_inline_c("R=(void*)pack_fopen(((char*)_pf),((char*)_pm));")
    end  -- feature fopen


    fclose(stream_pointer : POINTER) : INTEGER is
    -- Close a packed file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_fclose"
    end  -- feature fclose


    fputc(c : CHARACTER; stream_pointer : POINTER) : CHARACTER is
    -- Write a single character to the given packed file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_putc"
    end  -- feature fputc


    fgetc(stream_pointer : POINTER) : CHARACTER is
    -- Read the next character from the given packed file.
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_getc"
    end  -- feature fgetc


    feof(stream_pointer : POINTER) : BOOLEAN is
     -- Have we reached the end of the pack file?
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    do
        c_inline_c("R=pack_feof((PACKFILE *)a1);")
--    external
--        "IC"
--    alias
--        "pack_feof"
    end  -- feature feof


-- These features don't have a counterpart in STD_FILE.E.  Don't use them
-- if you want any semblance of portability.

    fseek(stream_pointer : POINTER; offset : INTEGER) : INTEGER is
    -- Seek forward (backward not supported by Allegro) by the specified
    -- offset from the current position (very slow for packed files)
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
        offset_is_valid         : offset > 0
    external
        "IC"
    alias
        "pack_fseek"
    end  -- feature fseek


    ferror(stream_pointer : POINTER) : INTEGER is
    -- Return the result of the last pack file operation
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_ferror"
    end  -- feature ferror


    fgetwi(stream_pointer : POINTER) : INTEGER is
    -- Read a 16 bit word in Intel format from the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_igetw"
    end  -- feature fgetwi


    fgetli(stream_pointer : POINTER) : INTEGER is
    -- Read a 32 bit integer in Intel format from the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_igetl"
    end  -- feature fgetli


    fputwi(w : INTEGER; stream_pointer : POINTER) : INTEGER is
    -- Write a 16 bit word in Intel format to the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
        word_is_valid           : w >= -32768 and w <= 32767
    external
        "IC"
    alias
        "pack_iputw"
    end  -- feature fputwi


    fputli(l : INTEGER; stream_pointer : POINTER) : INTEGER is
    -- Write a 32 bit integer in Intel format to the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_iputl"
    end  -- feature fputli


    fgetwm(stream_pointer : POINTER) : INTEGER is
    -- Read a 16 bit word in Motorola format from the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_mgetw"
    end  -- feature fgetwm


    fgetlm(stream_pointer : POINTER) : INTEGER is
    -- Read a 32 bit integer in Motorola format from the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_mgetl"
    end  -- feature fgetlm


    fputwm(w : INTEGER; stream_pointer : POINTER) : INTEGER is
    -- Write a 16 bit word in Motorola format to the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
        word_is_valid           : w >= -32768 and w <= 32767
    external
        "IC"
    alias
        "pack_mputw"
    end  -- feature fputwm


    fputlm(l : INTEGER; stream_pointer : POINTER) : INTEGER is
    -- Write a 32 bit integer in Motorola format to the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    external
        "IC"
    alias
        "pack_mputl"
    end  -- feature fputlm


    fgets(max_length : INTEGER; stream_pointer : POINTER) : STRING is
    -- Read up to max_lengths characters from the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    local
        p : POINTER
    do
        !!Result.make(max_length)
        p := Result.to_external
        c_inline_c("pack_fgets(_p,a1,a2);")
    end  -- feature fgets


    fputs(s : STRING; stream_pointer : POINTER) : INTEGER is
    -- Write the string into the pack file
    require
        ace_initialised         : info.ace_initialised
        stream_pointer_is_valid : stream_pointer.is_not_void
    local
        p : POINTER
    do
        p := s.to_external
        c_inline_c("R=pack_fputs(_p,a2);")
    end  -- feature fputs


end  -- class PACK_FILE
