indexing
    description    : "Allegro con Eiffel: retrace simulator objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : retrace_simulator
    date_started   : "30th January, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class RETRACE_SIMULATOR


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ACE }
    make


------------------------------------------------------ Creation features
feature { ACE }

    make is
    -- Create a retrace_simulator
    require
        ace_initialised         : info.ace_initialised
        graphics_initialised    : info.graphics_initialised
        timer_initialised       : info.timer_initialised
        retrace_simulator_not_initialised : not info.retrace_simulator_initialised
        simulation_is_available : (info.graphics_driver = info.graphics_modex
                                   or
                                   info.graphics_driver = info.graphics_vga)
                                  and not
                                  (info.windows_version = 4
                                   and
                                   info.windows_sub_version = 0)
    do
        info.set_retrace_simulator_flag(TRUE)
        running := FALSE
    ensure
        retrace_simulator_initialised : info.retrace_simulator_initialised
        retrace_simulator_not_running : not running
    end  -- feature make


------------------------------------------------------ Timer features
feature { ANY }

    -- Is the retrace simulator currently running?
    running : BOOLEAN


    start is
    -- Start retrace simulation
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        retrace_simulator_not_running : not running
        simulation_is_available : (info.graphics_driver = info.graphics_modex
                                   or
                                   info.graphics_driver = info.graphics_vga)
                                  and not
                                  (info.windows_version = 4
                                   and
                                   info.windows_sub_version = 0)
    do
        c_inline_c("timer_simulate_retrace(-1);")
        running := TRUE
    ensure
        retrace_simulator_running : running
    end  -- feature start


    stop is
    -- Stop retrace simulation
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        retrace_simulator_running : running
        simulation_is_available : (info.graphics_driver = info.graphics_modex
                                   or
                                   info.graphics_driver = info.graphics_vga)
                                  and not
                                  (info.windows_version = 4
                                   and
                                   info.windows_sub_version = 0)
    do
        c_inline_c("timer_simulate_retrace(0);")
        running := FALSE
    ensure
        retrace_simulator_not_running : not running
    end  -- feature stop


end  -- class RETRACE_SIMULATOR
