indexing
    description    : "Allegro con Eiffel: sample objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : sample
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class SAMPLE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    load

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    load(filename : STRING) is
    -- Create a new sample from the specified file
    require
        ace_initialised   : info.ace_initialised
        filename_is_valid : filename /= Void and then
                            ace_file_tools.exists(filename) and then
                            ace_file_tools.extension(filename).same_as("WAV")
    local
        p : POINTER
    do
        if is_valid then
            discard
        end  -- if

        p := filename.to_external
        c_inline_c("C->_data=load_sample(_p);")
    ensure
        is_valid : is_valid
    end  -- feature load


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a sample from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid : is_valid
    end  -- feature make_from_external


------------------------------------------------------ Internal features (SAMPLE)
feature { SAMPLE }

    data : POINTER


------------------------------------------------------ Internal features (NONE)
feature { NONE }

    ace_file_tools : ACE_FILE_TOOLS


------------------------------------------------------ Sample features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this sample is valid or not
    do
        Result := data.is_not_void
    end  -- feature is_valid


    discard is
    -- Discard this sample
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("destroy_sample(C->_data);C->_data=NULL;")
    ensure
        not_valid : not is_valid
    end  -- feature discard


    play(volume, pan, frequency : INTEGER; looped : BOOLEAN) is
    -- Play this sample
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
        volume_is_valid       : volume >= 0 and volume <= 255
        pan_is_valid          : pan >= 0 and pan <= 255
        frequency_is_valid    : frequency >= 0
    do
        c_inline_c("play_sample(C->_data,a1,a2,a3,a4);")
    end  -- feature play


    stop is
    -- Stop playing this sample
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
    do
        c_inline_c("stop_sample(C->_data);")
    end  -- feature stop


    adjust(volume, pan, frequency : INTEGER; looped : BOOLEAN) is
    -- Adjust a playing sample
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        is_valid              : is_valid
        volume_is_valid       : volume >= 0 and volume <= 255
        pan_is_valid          : pan >= 0 and pan <= 255
        frequency_is_valid    : frequency >= 0
    do
        c_inline_c("adjust_sample(C->_data,a1,a2,a3,a4);")
    end  -- feature adjust


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies data.is_not_void and
                  not is_valid implies data.is_void


end  -- class SAMPLE
