/******************
* Name: KEYBOARD.C
* Type: Linkable module (either library or object file)
* Does: Provides keyboard related routines for the ACE package.
* Author: Peter Monks (pmonks@iname.com)
* Refer: Classes KEYBOARD in KEYBOARD.E,
*                KEYPRESS in KEYPRESS.E,
*                SCANCODE in SCANCODE.E
*******************/

#include "allegro.h"
#include "common.h"
#include "keyboard.h"


/* Returns whether the given scancode is an "action" key or not. */
inline int eiffel_is_action(int scancode)
{
    if(scancode == KEY_CONTROL  ||
       scancode == KEY_LSHIFT   ||
       scancode == KEY_RSHIFT   ||
       scancode == KEY_ALT      ||
       scancode == KEY_CAPSLOCK ||
       scancode == KEY_NUMLOCK  ||
       scancode == KEY_SCRLOCK)
    {
        return(EIFFEL_FALSE);
    }

    return(EIFFEL_TRUE);
}
