//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for radio buttons
//----------------------------------------------------------------------------
// Tell the radio button to draw
void _draw_radio_button_object (const char *text,
                                const int x, const int y, const int h,
                                const int square,
                                const int selected,
                                const int disabled, const int has_focus,
                                const int fore, const int back,
                                const int select, const int deselect,
                                const int disable,
                                const int light_shad, const int dark_shad)
   {
   int y2;
   int boxsize;
   int box_x;
   int box_y;
   int box_x2;
   int box_y2;
   int txtlen;
   int text_x;
   int text_y;
   int fg;
   int c_inside;

   y2 = y+h-1;
   boxsize = text_height(font);
   if(boxsize<12) boxsize = 12;
   box_x  = x+4;
   box_y  = (y+y2+1)/2-boxsize/2;
   box_x2  = box_x+boxsize;
   box_y2  = box_y+boxsize-1;
   txtlen  = degui_strlen((char*)text);
   text_x  = (box_x2+4);
   text_y  = (y+y2+1)/2-text_height(font)/2;

   // Is the radio button disabled
   fg = fore;
   if(disabled) fg = disable;

   // Should the radio button be displayed highlighted
   c_inside = deselect;
   if(selected) c_inside = select;

   if(square)
      {
      draw_3d_frame(screen,box_x,box_y,box_x2,box_y2,c_inside,dark_shad,light_shad);
      if(selected) draw_3d_frame(screen,box_x+boxsize*1/4,box_y+boxsize*1/4,box_x2-boxsize*1/4,box_y2-boxsize*1/4,fg,light_shad,dark_shad);
      }
   else
      {
      draw_3d_circle(screen,box_x,box_y,box_x2,c_inside,dark_shad,light_shad);
      if(selected) draw_3d_circle(screen,box_x+boxsize*1/4,box_y+boxsize*1/4,box_x2-boxsize*1/4,fg,light_shad,dark_shad);
      }

   // Draw the text
   text_mode(back);
   degui_textout(screen,(char*)text,text_x,text_y,fg,FALSE);

   // Display focus frame
   if(has_focus) draw_dotted_rect(screen,text_x-2,text_y-2,text_x+txtlen+1,text_y+text_height(font)+1,fg);
   else rect(screen,text_x-2,text_y-2,text_x+txtlen+1,text_y+text_height(font)+1,back);
   }
//----------------------------------------------------------------------------

