//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include <stdio.h>
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Hidden list object
//----------------------------------------------------------------------------
// Constructor
hidden_list_object::hidden_list_object (char*(*proc)(int,int*), const int n)
   :list_object(proc),
   nitems(n),
   displaylist(false),
   underlist(NULL),
   donechoosing(true),
   oldy(0),
   oldh(0)
   {
   if(proc==NULL) list_grabber_proc = default_list_object_procedure;
   if(n<=0) nitems = 5;

   // Setup the defaults
   set_x(100);
   set_y(100);
   set_h(100);
   set_w(100);

   demand_focus = true;
   }
//----------------------------------------------------------------------------
// Destructor
hidden_list_object::~hidden_list_object (void)
   {
   // Make sure we release memory
   if(underlist!=NULL) destroy_bitmap(underlist);
   }
//----------------------------------------------------------------------------
// Basic message passing functions
//----------------------------------------------------------------------------
// Tell the object to draw itself
void hidden_list_object::msg_draw (void)
   {
   // Draw as a list object when we have the focus and the mouse
   if(donechoosing==false)
      {
      // Readjust our size
      if(displaylist==false)
         {
         oldy = y();
         oldh = h();

         set_y(y() + (h()/2) - text_height(font)/2 - 2);
         set_h(nitems*text_height(font)+10);

         // Get the background under list
         if(underlist!=NULL) destroy_bitmap(underlist);
         underlist = create_bitmap(w()+1,h()+1);
         blit(screen,underlist,x(),y(),0,0,w()+1,h()+1);
         }
      displaylist = true;

      // Draw ourselves
      list_object::msg_draw();
      }
   // Draw as a editable text object
   else
      {
      // Readjust the sizes if necessary
      if(displaylist==true)
         {
         // Replace what was under the list
         blit(underlist,screen,0,0,x(),y(),w()+1,h()+1);
         underlist = NULL;

         // Go back to the old positioning
         set_y(oldy);
         set_h(oldh);
         }
      displaylist = false;

      // Get the text to show
      char *text = "";
      if(selection()>=0) text = list_grabber_proc(selection(),&listsize);

      // Draw in the non-focus style
      _draw_edittext_object(text,
                            -1,
                            0,
                            x(),y(),w()-10,h(),
                            disabled(),has_focus(),
                            color ? color->fore() : degui_fore_color,
                            color ? color->deselect() : degui_deselect_color,
                            color ? color->disable() : degui_disable_color,
                            color ? color->light_shad() : degui_light_shad_color,
                            color ? color->dark_shad() : degui_dark_shad_color);

      _draw_hidden_list_marker(x2()-10,y(),10,h(),
                               disabled(),has_focus(),
                               color ? color->fore() : degui_fore_color,
                               color ? color->mid() : degui_mid_color,
                               color ? color->deselect() : degui_deselect_color,
                               color ? color->disable() : degui_disable_color,
                               color ? color->light_shad() : degui_light_shad_color,
                               color ? color->dark_shad() : degui_dark_shad_color);

      }
   _redraw = false;
   }
//----------------------------------------------------------------------------
// Tell the object to draw show the list when clicked
void hidden_list_object::msg_click (void)
   {
   // Possibly switch to a list view
   if(displaylist==false)
      {
      donechoosing = false;
      show_mouse(NULL);
      msg_draw();
      show_mouse(screen);
      }
   else
      {
      list_object::msg_click();
      }
   }
//----------------------------------------------------------------------------
// Tell the object to draw itself when it loses the focus
void hidden_list_object::msg_dclick (void)
   {
   list_object::msg_dclick();
   msg_lostmouse();
   }
//----------------------------------------------------------------------------
// Tell the object to draw itself when user is done
void hidden_list_object::msg_key (void)
   {
   msg_click();
   }
//----------------------------------------------------------------------------
// Tell the object to draw itself when it loses the focus
void hidden_list_object::msg_lostfocus (void)
   {
   msg_lostmouse();
   }
//----------------------------------------------------------------------------
// Tell the object to draw itself when it loses the mouse
void hidden_list_object::msg_lostmouse (void)
   {
   donechoosing = true;
   show_mouse(NULL);
   msg_draw();
   show_mouse(screen);
   }
//----------------------------------------------------------------------------
// Deal with keypresses if we have the list up
bool hidden_list_object::msg_char (const int c)
   {
   // Possibly pass char to
   if(displaylist==true) return list_object::msg_char(c);

   // Other wise don't use the key
   else return false;
   }
//----------------------------------------------------------------------------

