//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Simple object to draw a shadow box
//----------------------------------------------------------------------------
// Constructor
shadow_box_object::shadow_box_object (void)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
	set_w(100);
   set_h(100);
   }
//----------------------------------------------------------------------------
// Destructor
shadow_box_object::~shadow_box_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Draw the screen clear
void shadow_box_object::msg_draw (void)
   {
   // Draw the background
   draw_3d_frame(screen,x(),y(),x2()-1,y2()-1,color ? color->back() : degui_back_color, color ? color->light_shad() : degui_light_shad_color, color ? color->dark_shad() : degui_dark_shad_color);

   vline(screen, x2(), y()+1, y2(), color ? color->fore() : degui_fore_color);
   hline(screen, x()+1, y2(), x2(), color ? color->fore() : degui_fore_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------

