/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.5
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzlist.c
 *
 */

#include "palantir.h"

//------------------ ONE DIRECTIONAL LIST ----------------
//---------------------- OD LIST NEW ---------------------

odlist *odlist_new()
{ int tmp;
  odlist *list;

  lwp_disable; //disable threading
  list=(odlist*)malloc(sizeof(odlist));
  lwp_enable;
  if(list==NULL) return(NULL);

  lwp_disable;
  lwp_lock(&list->status);
  list->first=NULL;
  list->last=NULL;
  list->nElements=0;
  lwp_enable;
  lwp_unlock(&list->status);
  return(list);
}

//--------------------- LIST INSERT --------------------
//add new element to the end of list
odelement* odlist_insert(odlist *list,void *element_data)
{ int tmp;
  odelement *new_element;

  lwp_disable; //disable threading
  new_element=(odelement*)malloc(sizeof(odelement));
  lwp_enable;
  if (new_element==NULL) return(NULL);

  lwp_disable;
  lwp_lock(&list->status);
  if (list->first==NULL) list->first=new_element;
  else (list->last)->next=new_element;
  new_element->next=NULL;
  new_element->data=element_data;
  list->last=new_element;
  list->nElements++;
  lwp_enable;
  lwp_unlock(&list->status);

  return(new_element);
}

//------------------ LIST INSERT TO HEAD --------------------
//add new element to the end of list
odelement* odlist_insert_to_head(odlist *list,void *element_data)
{ int tmp;
  odelement *new_element;

  lwp_disable; //disable threading
  new_element=(odelement*)malloc(sizeof(odelement));
  lwp_enable;
  if (new_element==NULL) return(NULL);

  lwp_disable;
  lwp_lock(&list->status);
  new_element->next=list->first;
  new_element->data=element_data;

  if (list->first==NULL) //list is empty
   { list->first=new_element;
     list->last=new_element;
   }
  else
   list->first=new_element;

  list->nElements++;

  lwp_enable;
  lwp_unlock(&list->status);
  return(new_element);
}

//--------------------- LIST REMOVE ---------------------------

void odlist_remove(odlist *list,void *element_data)
{ int tmp;
  odelement *cur,*prev=NULL;

  lwp_disable; //disable threading
  lwp_lock(&list->status);
  cur=list->first;
  while(cur!=NULL)
   { if (cur->data==element_data)
      { if (prev!=NULL) prev->next=cur->next;
        else list->first=cur->next; //remove first element
        if (cur->next==NULL) list->last=prev; //remove last element
        list->nElements--;
        free(cur);
        lwp_enable;
        lwp_unlock(&list->status);
        return;
      }
     prev=cur;
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
  return;
}

//--------------------- LIST DELETE ---------------------------

void odlist_delete(odlist *list)
{ int tmp;
  odelement *cur,*next;

  lwp_disable; //disable threading
  cur=list->first;
  while(cur!=NULL)
   { next=cur->next;
     free(cur->data);
     free(cur);
     cur=next;
   }
  free(list);
  lwp_enable;
  return;
}

//----------------------- MOVE TO HEAD ------------------------

void odlist_move_to_head(odlist *list,void *element_data)
{ int tmp;
  odelement *cur,*prev=NULL;

  lwp_disable; //disable threading
  lwp_lock(&list->status);
  cur=list->first;
  while(cur!=NULL)
   { if (cur->data==element_data)
      { if (prev!=NULL)
         { prev->next=cur->next;
           if (prev->next==NULL) //new last element
             list->last=prev;
           cur->next=list->first;
           list->first=cur;
           lwp_unlock(&list->status);
           lwp_enable;
           return;
         }
        else
         { lwp_enable;
           lwp_unlock(&list->status);
           return;// element already at the list head
         }
      }
     prev=cur;
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
  return;
}

//------------------------ CHECK DATA --------------------

int odlist_data_check(odlist *list,void *element_data)
{ int tmp;
  odelement *cur;

  lwp_disable; //disable threading
  lwp_lock(&list->status);
  cur=list->first;
  while (cur!=NULL)
   { if (cur->data==element_data)
      { lwp_enable;
        lwp_unlock(&list->status);
        return(1);
      }
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
  return(0);
}

//------------------ TWO DIRECTIONAL LIST ----------------

//---------------------- TD LIST NEW ---------------------

tdlist *tdlist_new()
{ tdlist *list;
  int tmp;
  lwp_disable;
  list=(tdlist*)malloc(sizeof(tdlist));
  lwp_enable;
  if(list==NULL) return(NULL);

  list->first=NULL;
  list->last=NULL;
  list->nElements=0;
  lwp_unlock(&list->status);
  return(list);
}

//--------------------- TD LIST INSERT --------------------
//add new element to the end of list
tdelement* tdlist_insert(tdlist *list,void *element_data)
{ tdelement *new_element;
  int tmp;

  lwp_disable;
  new_element=(tdelement*)malloc(sizeof(tdelement));
  lwp_enable;
  if (new_element==NULL) return(NULL);

  lwp_disable;
  lwp_lock(&list->status);
  if (list->first==NULL) list->first=new_element;
  else list->last->next=new_element;
  new_element->next=NULL;
  new_element->prev=list->last;
  new_element->data=element_data;
  list->last=new_element;
  list->nElements++;
  lwp_enable;
  lwp_unlock(&list->status);

  return(new_element);
}

//------------------ TD LIST INSERT TO HEAD --------------------
//add new element to the head of list
tdelement* tdlist_insert_to_head(tdlist *list,void *element_data)
{ tdelement *new_element;
  int tmp;

  lwp_disable;
  new_element=(tdelement*)malloc(sizeof(tdelement));
  lwp_enable;
  if (new_element==NULL) return(NULL);

  lwp_disable;
  lwp_lock(&list->status);
  new_element->next=list->first;
  new_element->prev=NULL;
  new_element->data=element_data;

  if (list->first==NULL) //list is empty
   { list->first=new_element;
     list->last=new_element;
   }
  else
   { (list->first)->prev=new_element;
     list->first=new_element;
   }

  list->nElements++;

  lwp_enable;
  lwp_unlock(&list->status);
  return(new_element);
}

//--------------------- TD LIST REMOVE ---------------------------

void tdlist_remove(tdlist *list,void *element_data)
{ tdelement *cur,*prev=NULL;
  int tmp;

  lwp_disable;
  lwp_lock(&list->status);
  cur=list->first;
  while(cur!=NULL)
   { if (cur->data==element_data)
      { if (prev!=NULL)
          prev->next=cur->next;
        else
          list->first=cur->next; //remove first element

        if (cur->next!=NULL)
          ((tdelement*)(cur->next))->prev=prev;
        else
         { list->last=prev; //remove last element
           prev->next=NULL;
         }
        list->nElements--;
        free(cur);
        lwp_enable;
        lwp_unlock(&list->status);
        return;
      }
     prev=cur;
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
  return;
}

//-------------------- TD LIST REMOVE LAST -----------------------

void tdlist_remove_last(tdlist *list)
{ tdelement *prev;
  int tmp;

  lwp_disable;
  lwp_lock(&list->status);
  prev=list->last;
  free(list->last);
  list->last=prev;
  prev->next=NULL;
  list->nElements--;
  lwp_enable;
  lwp_unlock(&list->status);
  return;
}

//----------------------- TD MOVE TO HEAD ------------------------

void tdlist_move_to_head(tdlist *list,void *element_data)
{ tdelement *cur,*prev=NULL;
  int tmp;

  lwp_disable;
  lwp_lock(&list->status);
  cur=list->first;
  while(cur!=NULL)
   { if (cur->data==element_data)
      { if (prev!=NULL)
         { prev->next=cur->next;
           if (cur->next!=NULL) cur->next=prev;
           if (prev->next==NULL) //new last element
             list->last=prev;
           cur->next=list->first;
           list->first=cur;
           lwp_enable;
           lwp_unlock(&list->status);
           return;
         }
        else
         { lwp_enable;
           lwp_unlock(&list->status);
           return;// element already at the list head
         }
      }
     prev=cur;
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
}

//------------------------ CHECK DATA --------------------

int tdlist_data_check(tdlist *list,void *element_data)
{ tdelement *cur;
  int tmp;

  lwp_disable;
  cur=list->first;
  while (cur!=NULL)
   { if (cur->data==element_data)
      { lwp_enable;
        return(1);
      }
     cur=cur->next;
   }
  lwp_enable;
  lwp_unlock(&list->status);
  return(0);
}

