/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.5
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzstr.c
 *
 */

#include "palantir.h"
#include <sys/stat.h>

typedef struct
{ device *port;
  odlist *waiting_strings;
} port_waiting_string;
#define pwstring_(_str_) ({(port_waiting_string*)(_str_);})
odlist *strings_list;
int waitstring_handler(a_message code,int p1,int p2);
dz_app *str_wait_app;
static int strings_init=0;

//------------------------ WAITING STRING INIT ---------------------------

int waiting_strings_init(void)
{ int tmp;

  if (strings_init) return(1); //already installed

  if ((strings_list=odlist_new())==NULL)
   {
     return(0);
   }

  if ((str_wait_app=dz_app_new("Wait string (comm helper)",16384,1,waitstring_handler))==NULL)
   { lwp_disable;
     free(strings_list);
     lwp_enable;
     return(0);
   }

  strings_init=1;
  return(1);
}

//----------------------- COMM PORT STRING WAIT -------------------------

waiting_string *comm_port_waitstring_add(device *dev,dz_app *app,char *s)
{ comm_port *port=dev->device_user_data;
  int tmp;
  odlist *cur_list;
  odelement *cur;

  if (dev==NULL||port==NULL||s==NULL||s[0]==0) return(NULL);
  lwp_disable;
  { cur=strings_list->first;
    while (cur!=NULL) //check installed handlers
     { if (pwstring_(cur->data)->port==dev) break;
       cur=cur->next;
     }
    if (cur==NULL) //add handler for new port
     { port_waiting_string *new_port_list=pwstring_(malloc(sizeof(port_waiting_string)));
       if (new_port_list==NULL)
        { lwp_enable;
          return(NULL);
        }

       new_port_list->port=dev;
       if ((new_port_list->waiting_strings=odlist_new())==NULL)
        { free(new_port_list);
          lwp_enable;
          return(NULL);
        }
       if (odlist_insert(strings_list,new_port_list)==NULL)
        { free(new_port_list->waiting_strings);
          free(new_port_list);
          lwp_enable;
          return(NULL);
        }
       cur_list=new_port_list->waiting_strings;
       if (device_client_task_add(dev,str_wait_app,READ)==NULL) //add handler
        { free(new_port_list->waiting_strings);
          free(new_port_list);
          lwp_enable;
          return(NULL);
        }
     }
    else
     cur_list=pwstring_(cur->data)->waiting_strings;
  }
  lwp_disable;

  { waiting_string *wstr;
  cur=cur_list->first;
  while (cur!=NULL) //check installed strings
   { wstr=wstring_(cur->data);
     if (strcmp(wstr->string,s)==0)
      { wstr->status=0;
        return(wstr);
      }
     cur=cur->next;
   }
  }
//  printf("ADD : %s\n",s);
  {
  waiting_string *wstr=wstring_(malloc(sizeof(waiting_string)));
  char *str=(char*)malloc(strlen(s)+1);
  char *str_buf=(char*)malloc(strlen(s)+1);

  if (wstr==NULL||str==NULL||str_buf==NULL)
   { free(wstr);
     free(str_buf);
     free(str);
     lwp_enable;
     return(NULL);
   }

  wstr->app=app;
  wstr->dev=dev;
  wstr->string=str;
  wstr->string_len=strlen(s);
  wstr->string_buf_len=0;
  wstr->string_buf=str_buf;
  strcpy(str,s);

  wstr->status=1;
  if (odlist_insert(cur_list,wstr)==NULL)
   { free(wstr);
     free(str_buf);
     free(str);
     lwp_enable;
     return(NULL);
   }
  wstr->status=0;
  lwp_enable;
  return(wstr);
  }
}

//------------------- WAIT STRING HANDLER ---------------------

int waitstring_handler(a_message code,int p1,int p2)
{ odelement *cur;
  waiting_string *wstr;
  int c;
  int tmp;

  switch (code)
   { case H_COMM_IN :
       c=p1;
       if (c==0) c=' ';
       cur=strings_list->first;
       while (cur!=NULL)
        { if (pwstring_(cur->data)->port==dev_(p2)) break;
          cur=cur->next;
        }
       if (cur==NULL) return(1);

       cur=(pwstring_(cur->data)->waiting_strings)->first;
       while (cur!=NULL)
         { wstr=(waiting_string*)cur->data;
           if (wstr->status!=1)
            { wstr=wstring_(cur->data);
              if (wstr->string_buf_len==wstr->string_len)
                { lwp_disable;
                  memmove(wstr->string_buf,wstr->string_buf+1,wstr->string_len-1);
                  lwp_enable;
                  wstr->string_buf_len--;
                }
              wstr->string_buf[wstr->string_buf_len]=c;
              wstr->string_buf_len++;
              wstr->string_buf[wstr->string_buf_len]=0;
              if (strcmp(wstr->string,wstr->string_buf)==0)
               { wstr->status=1;
                 lwp_disable;
                 app_msg_put(wstr->app,E_COMM_STRING,(int)wstr,(int)dev_(p2));
                 lwp_enable;
                 return(1);
               }
             }
            cur=cur->next;
         }
      default :
        break;
    }
  return(1);
}

//------------------- COMM PORT STRING WAIT REMOVE ---------------------

void comm_port_waitstring_remove(device *dev,dz_app *task,char *s)
{ odelement *cur;
  odlist *wlist;
  int tmp;
  if (dev==NULL) return;

  cur=strings_list->first;
  while (cur!=NULL) //find port
   { if (pwstring_(cur->data)->port==dev) break;
     else cur=cur->next;
   }
  if (cur==NULL) return;

  wlist=pwstring_(cur->data)->waiting_strings;
  cur=wlist->first;

  while (cur!=NULL)
   { if (wstring_(cur->data)->app==task)
      { if (strcmp(wstring_(cur->data)->string,s)==0)
         { lwp_disable;
//           printf("\nDELETE : %s\n",s);
           odlist_remove(wlist,cur->data);
           free(wstring_(cur->data)->string);
           free(wstring_(cur->data)->string_buf);
           free(cur->data);
           lwp_enable;
           return;
         }
      }
     cur=cur->next;
   }
}
