/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.4
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : palantir.h
 *
 */
#include <stdio.h>
#include <time.h>
#include <io.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include "allegro.h"
#include "lwp.h"
#include "messages.h"

//#define FORTIFY

#ifdef FORTIFY
#include <fortify.h>
#endif

#ifndef __PALANTIR__
#define __PALANTIR__

//#define __DZ_DEBUG__
#ifdef __cplusplus
extern "C" {
#endif

#define __DEVICE__
#define __DZCOMM__
#define __LWP__

#define DISABLE()   asm volatile ("cli")
#define ENABLE()    asm volatile ("sti")

typedef unsigned int uint;
typedef unsigned short int usint;
typedef unsigned char byte;

//#x# are marks for automatic documentator and may be ignored by human reader.
//#d# function description
//#v# returned values
//#c# any comments, notes, etc.
//#n# exclude line from documentation
//#sb# begin structure. Type structure name (if any) after this tag.
//#ds# in structure description means what field maintained by system.
//#se# end structure
//#p# parameters list
//#dv# variable description
#define not_commented(_s_) ((_s_)[-1]!='/'&&(_s_)[-2]!='/')

typedef enum {LWP_READY=0,LWP_LOCKED=1} res_status;
typedef enum {EMPTY=0,NOT_EMPTY=1} empty_status;
extern int _lwp_enable;
#define lwp_disable {tmp=_lwp_enable;_lwp_enable=1;}
#define lwp_enable  {_lwp_enable=tmp;}
void ready_and_lock(res_status *flag);
void lwp_unlock(res_status *flag);
void lwp_lock(res_status *flag);

//----------------------------- FIFO QUEUE ------------------------
//#sb# First In First Out queue
typedef struct
{
#ifdef __LWP__
  empty_status empt;
  res_status status;
#endif
  uint size;  //size of queue.
  uint dsize; //size of data element in queue (1-4 bytes)
  uint initial_size;
  uint resize_counter;
  uint fill_level;
  int (*empty_handler)();
  void  *queue;     //#ds#pointer to queue. Points to int[], where actual data stored.
  uint head,tail;  //#ds#number of head and tail elements
                   //head points to the first element in queue
                   //tail points to the first element next to last
                   //element in queue. (For example : we have ten elements
                   //in queue, then head==0, tail==10
} fifo_queue;
//#se#
fifo_queue* queue_new_(uint size,uint dsize); //#d#Allocate storage space for new fifo_queue.
fifo_queue* queue_new(uint size); //#d#Allocate storage space for new fifo_queue.
//#v# NULL if failed
// pointer to newly created fifo_queue structure
void queue_delete(fifo_queue *q); //#d#Delete queue description and free occuped space.
inline void queue_reset(fifo_queue *q);//#d#Set head and tail to zero (data not lost).
int queue_resize(fifo_queue *q,uint new_size); //#d#Increase(decrease) storage space
//for fifo queue.
//#v# 0 if failed
//1 if success
inline int queue_put(fifo_queue *q,int c); //#d#Put value into given queue.
inline int queue_get(fifo_queue *q); //#d#Get values from queue.
//#v# Byte from queue's head
//#c# Use queue_empty befor calling queue_get. queue_get don't test
// queue's head and tail, just return queue[head].
inline int queue_empty(fifo_queue *q);//#d#Test queue for emptyness.
//#v# 1 if empty (head==tail)
// 0 if not empty (head!=tail)
//#c# Call this function before any queue_get calling
/*
typedef enum {NORMAL,DATA_PRESERVE} get_mode; //#n#
inline void queue_get_n(fifo_queue *q,int *mem_to,byte n,get_mode m);
//read n elements from queue q and place in mem_to
inline int queue_put_n(fifo_queue *q,int *mem_from,byte n);
//put n elements to queue q and from address pointed by mem_from
*/
//---------------------- ONE DIRECTIONAL LIST ----------------------

typedef struct
{ void *next;  //any object.
  void *data;  //pointer to the actual element data
} odelement;

typedef struct
{
#ifdef __LWP__
  res_status status;
#endif
  int nElements; //counter of elements in list
  odelement *first; //pointer to first element in list.
  odelement *last; //pointer to last element in list
} odlist;

#define odlist_(_odlist_) ({(odlist*)(_odlist_);})

odlist *odlist_new();//#d#Allocate space for list.
odelement* odlist_insert(odlist *list,void *element_data);//#d#Insert new element at
//list header.
void odlist_remove(odlist *list,void *element_data);//#d#Remove element from list.
odelement* odlist_insert_to_head(odlist *list,void *element_data);
void odlist_move_to_head(odlist *list,void *element_data);
int odlist_data_check(odlist *list,void *element_data);//#d#check for presence data in list
void odlist_delete(odlist *list); //delete list by free all elements data and elements itself

//---------------------- TWO DIRECTIONAL LIST ----------------------

typedef struct
{ void *prev;  //any object
  void *next;  //any object.
  void *data;  //pointer to the actual element data
} tdelement;

typedef struct
{
#ifdef __LWP__
  res_status status;
#endif
  int nElements; //counter of elements in list
  tdelement *first; //pointer to first element in list.
  tdelement *last; //pointer to last element in list
} tdlist;

#define tdlist_(_tdlist_) ({(tdlist*)(_tdlist_);})

tdlist *tdlist_new();//#d#Allocate space for list.
tdelement* tdlist_insert(tdlist *list,void *element_data);//#d#Insert new element at
//list header.
void tdlist_remove(tdlist *list,void *element_data);//#d#Remove element from list.
void tdlist_remove_last(tdlist *list);//Remove last element from list
tdelement* tdlist_insert_to_head(tdlist *list,void *element_data);
void tdlist_move_to_head(tdlist *list,void *element_data);
int tdlist_data_check(tdlist *list,void *element_data);//#d#check for presence data in list

//-------------------------- SOME DECODERS --------------------------

#define scan_(_key_)  ({((_key_)>>8)&0xff;}) //#d#extract scan part
#define ascii_(_key_) ({(_key_)&0xff;})//#d#extract ascii part
#define key_shifts_(_key_) ({((_key_)>>16)&0xff;})//#d#extract shifts keys status
//#d#Determine if Ctrl-... pressed
//#v# 1 - if yes. For example if(ctrl_,'C') {exit(1);}
//0 - if not
#define ctrl_(_key_,c) \
({((key_shifts_(_key_)&KB_CTRL_FLAG)&&((ascii_(_key_)+'A'-1)==(c)));})
#define alt_(_key_,c) \
({((key_shifts_(_key_)&KB_ALT_FLAG)&&((((_key_)>>8)&0x00ff)==(c))&&ascii_(_key_)==0);})

#define data_(_comm_data_) ({(_comm_data_)&0xff;}) //#d#extract data byte
#define q_reg_(_comm_data_) ({((_comm_data_)>>16)&0xff;}) //#d#extract status registers byte

#define x_(c) ({((c)>>14)&0x3fff;})//#d#extract mouse x (14 bit)
#define y_(c) ({(c)&0x3fff;})//#d#extract mouse y (14 bit)
#define but_(c) ({((c)>>28)&0xf;})//#d#extract mouse buttons state (4 bit)

//#ifdef __cplusplus
//}
//#endif

#ifdef __DEVICE__

extern char *wd;

//--------------------------- DEVICE -------------------------

typedef enum {Q_READ=1,Q_WRITE=2,Q_LOCKED=4} status;
typedef enum {DEV_DEV=1,DEV_APP=2} device_style;
typedef enum {DEV_NONE=0,DEV_KEYBOARD=1,DEV_MOUSE=2,DEV_COMMS=4} dev_types;

//#sb# Device.
typedef struct _device_
{ char szName[64];    //#d#device name.
  unsigned long hName; //#ds#device id.
  uint priority;       //#d#1 - highest level (proccessed first) (0 - reserved)
  byte read_write_priority; //#d# 0 - read_handler called first
                            // 1 - write_handler called first
#ifdef __LWP__
  res_status status;
#else
  byte status; //#ds# Bit field. 0 - all queues empty, bit 1 - read queue not empty,
               // bit 2 - write queue not empty
  device_style style;//may be DEV_DEV for hardware device or DEV_APP for app
#endif

  fifo_queue *read_queue; //#d#data from device
  fifo_queue *write_queue; //#d#data to device
  fifo_queue *clients_read_queue; //#d#data from device
  fifo_queue *clients_write_queue; //#d#data to device
  odlist *write_client_tasks;
  odlist *read_client_tasks;
  a_message read_code;
  a_message write_code;
  int client_apps_status;
  int (*device_read_handler)();  //#d#user function called then read_queue not empty
  int (*device_write_handler)(); //#d#user function called then write_queue not empty
                                 //For example : you may install this hanler to
                                 //write log file for comm port device.
                                 //Note : this handlers are not hardware handlers for your
                                 //device. They are software routines called inside
                                 //events_dispatch loop. If user function return 1 then
                                 //events_dispatch will be canceled emmediately.
  void (*device_delete_handler)(); //#d#this function called then device deleted.
  int  (*device_put_handler)(); //#d#this user defined function, called by
                                //device_put(device) function
  int  (*device_get_handler)(); //#d#this user defined function, called by
                                //device_get(device) function
  void *device_user_data; //#d#pointer to user defined structure.
  void (*device_empty_handler)(struct _device_ *dev);
} device;
//#se#
#define dev_(_dev_) ({(device*)(_dev_);})

#ifndef __LWP__
typedef struct
{ byte status;  //number of installed devices
  odlist *list; //list of installed devices
} devicelist;
#endif

//----------------------------- MSG ----------------------------

typedef struct
{ int code;
  int p1;
  int p2;
} dz_msg;
inline void msg_get(fifo_queue *q,dz_msg *msg);
inline void msg_put(fifo_queue *q,a_message code,int p1,int p2);

//#include <palantir.h>

//typedef enum
//{ ALLEGRO_DEVICE,
//  ALLEGRO_OBJECT
//} device_type;

#ifndef __LWP__
//#b#
devicelist *devicelist_new();//#d#Allocate storage space for new device list.
//It's may be gui objects, game objects, etc.
//messages will be sended to this list automaticaly.
void devicelist_delete(devicelist *list);//#d#Delete device list.
int devicelist_insert(devicelist *list,device *dev);//#d#Add new device
//to the list. You don't normally need to call this function deirectly.
//It called by device_new() then you create new device.
device *device_new(devicelist *dev_list,char *szName,uint priority,uint read_size,uint write_size);//#d#
//Allocate storage space for new device and place it into dev_list
//according to the 'priority' value. Devices from start of the list (highest
//priority=1 (0 - reserved) will proccessed first.
//#p# dev_list - pointer to list, where new device will be inserted.
//szName - user defined name for device (There are 3 predefined devices in system :
//"KEYBOARD", "MOUSE")
//priority - device priority level. 1 - highest (0 - reserved)
//read_size, write_size - size of read and write device buffer.
//Default values for devices : "KEYBOARD","MOUSE"-(1K,1K)
//#v# NULL if some error occured
//pointer to newly created device
void device_delete(devicelist *dev_list,device *ptrDevice);//#d#remove device from
//given list.Call device_delete_handler (if any).
//Deallocate storage space occuped by device.
#else
device *device_new(char *szName,uint read_size,uint write_size);//#d#
device *device_new_(char *szName,uint read_size,uint write_size,
                                 uint dread_size,uint dwrite_size);//#d#
void device_delete(device *dev);//#d#remove device from
#endif

int device_put(device *dev,int c);//#d#wrapper for device_put_handler() wich supplied by user
//#v# 1 - if user function return 1
//0 - if user function return 0
int device_get(device *dev);//#d#wrapper for device_get_handler() wich supplied by user

//------------------------------- EVENTS ---------------------------

int palantir_init(int devs);//#d# call this function before allegro_init()
//#v# 0 - if success
//1 - if some error occured during initialisation
void palantir_deinit();
extern odlist *palantir_app_list;
//#ifndef __LWP__
//int events_dispatch(void);//#d# make loop while(!events_dispatch) {...}; to proccess.
//#endif

extern device *keyboard_device; //#dv# predefined device.
//after calling install_keyboard
//set keyboard_device->device_read_handler=your_keyboard_handler;
//to recive keyboard events. (See term.c for more details)
extern device *mouse_device; //#dv# the same as keyboard_device
//extern device *timer_device;

#ifndef __LWP__
extern devicelist *allegro_device_list; //#dv# use this variable as first parameter to
//device_new(), if you want to add new hardware driver
#endif

extern volatile unsigned long tick_counter;//#dv#Counts timerticks.
extern long dbl_click_delay;//#dv#Delay in *tick_counter*. Default value 15.
//#e#

//--------------------------- APP ------------------------------

void idled(void *args);

typedef struct
{ res_status status;
  lwp *lwp_thread;
  char szName[64];
  int (*msg_handler)(a_message code,int p1,int p2);
  void *app_usrdata;
  fifo_queue *msg_queue;
} dz_app;
#define app_(app) ({(dz_app*)(app);})

dz_app* dz_app_new(char *szName,int stack,int priority,int (*app_hnd)(a_message code,int p1,int p2));
void    dz_app_delete(dz_app *app);
int dz_app_default_handler(dz_app *app,dz_msg *msg);

typedef enum {READ,WRITE,BOTH} client_status;
typedef struct
{ res_status status;
  client_status client; //recieve read, write or both events
  dz_app *task;
} client_task;

#define ctask_(_task_) ({(client_task*)(_task_);})
client_task *device_client_task_add(device *dev,dz_app *task,client_status client);
void device_client_task_remove(device *dev,dz_app *task,client_status client);

#endif //__DEVICE__

#ifdef __DZCOMM__

//---------------------------- COMM_PORT --------------------------

typedef enum {_com1,_com2,_com3,_com4,_com5,_com6,_com7,_com8} comm;
typedef enum {BITS_8=0x03,BITS_7=0x02,BITS_6=0x01,BITS_5=0x00} data_bits;
typedef enum {STOP_1=0x00,STOP_2=0x02} stop_bits;
typedef enum {EVEN_PARITY=0x03,ODD_PARITY=0x01,NO_PARITY=0x00} parity_bits;
typedef enum {_110=110,_150=150,_300=300,_600=600,
              _1200=1200,_2400=2400,_4800=4800,
              _9600=9600,_19200=19200,_38400=38400,
              _57600=57600,_115200=115200} boud_bits;
//typedef enum {DTR_ON=0xFD,RTS_ON=0xFE,DTR_OFF=~0x1,RTS_OFF=~0x2} hand;
typedef enum {CTS_ON=0x01,CTS_OFF=0x0,RTS_ON=0x1,RTS_OFF=0x0} hand;
typedef enum {XON_RCVD=1,XON_SENT=1,XOFF_RCVD=0,XOFF_SENT=0} xon_xoff_status;
typedef enum {NO_CONTROL=1,XON_XOFF=2,RTS_CTS=3} flow_control_type;
typedef enum {XON_ASCII=0x11,XOFF_ASCII=0x13} control_char;
extern char szDZCommErr[50];

typedef enum {DATA_BYTE=1,MSR_BYTE=2,LSR_BYTE=4} comm_status_byte;

//#sb#Comm port.
typedef struct
{ //general parametrs
  device *dev; //#ds# points to device there device_user_data points to this structure
  comm  nComm; //#d#comm port number
  usint nPort; //#d#comm port address
  byte  nIRQ;  //#d#comm IRQ
  usint nIRQVector; //#d#number of software interrupt vector.
  flow_control_type control_type; //default XON_XOFF
  //next five variables are for flow control handling
  byte xon;
  byte xoff;
  byte xonxoff_send;
  byte xonxoff_rcvd;
  byte rts;
  byte cts;
  //next two fields are for byte counting
  uint in_cnt; //counter for input data
  uint out_cnt; //counter for output data
//  uint flow_state;
//You may alter this (and 3 previous) fields after comm_port_new() where defaults
//values are set.
  byte  interrupt_enable_mask; //#ds#
  int (*comm_handler)(); //#d#pointer to short function see below
  int (*msr_handler)(); //#d#pointer to modem status register handler.
  int (*lsr_handler)(); //#d#pointer to line status register handler.
// template to comm's interrupt handler
//
//comm_port *your_comm,*your_comm1; //must be declared globaly
//int foo_comm_wrapper(void)
//{ dz_comm_interrupt_handler(ptr_your_comm);
//  return(0);
//}

  enum {YES,NO} installed; //#ds#

  //communication parametrs
  boud_bits   nBaud;   //#d#boud rate
  data_bits   nData;   //#d#data length
  stop_bits   nStop;   //#d#stop bits
  parity_bits nParity; //#d#parity

  //input and output queue
  fifo_queue *InBuf; //#ds#pointer to read buffer
  fifo_queue *OutBuf; //#ds#pointer to write buffer
  fifo_queue *lwp_OutBuf;
  usint THR;   //#ds# Transmitter Holding Register */
  usint RDR;   //#ds# Reciever Data Register */
  usint BRDL;  //#ds#Baud Rate Divisor, Low usint */
  usint BRDH;  //#ds# Baud Rate Divisor, High Byte */
  usint IER;   //#ds# Interupt Enable Register */
  usint IIR;   //#ds# Interupt Identification Register */
  usint FCR;   //#ds# FIFO Control Register */
  usint LCR;   //#ds# Line Control Register */
  usint MCR;   //#ds# Modem Control Register */
  usint LSR;   //#ds# Line Status Register */
  usint MSR;   //#ds# Modem Status Register */
  usint SCR;   //#ds# SCR Register */
  usint ISR_8259; //#ds#interrupt service register
  usint IMR_8259; //#ds#interrupt mask register
} comm_port;
#define cport_(_p_) ({(comm_port*)(_p_);})
//#se#
extern char szDZCommErr[50];
#define cdport_(_d_) ({cport_((device*)(_d_)->device_user_data);})
device *comm_port_init(comm com); //#d# Allocate storage space for
//new comm port device and place it in allegro_device_list.
//#p# com - number of com port. Use one of - com1,com2,com3,com4 enumerated values.
//handler - wrapper for hardware interrupt.
//#c#This function only allocate memory for new comm device. Hardware handler set up
//in comm_port_install_handler().
int comm_port_install_handler(device *dev);//#d# Set up hardware handler for given
//comm device.
//#p# dev - values returned by comm_port_new
inline void comm_port_out(device *dev,byte c);//#d#Put value into comm device
//write queue.
//#p# dev - comm device
//c - byte to place into queue.
//#c# This function don't send any data directly to comm port. Data sended to port in
//hardware interrupt handler then it's possible
inline int comm_port_test(device *dev);
inline int dz_comm_port_interrupt_handler(device *port);//#d#Hardware interrupt handler
//#c# Never call this function directly. This declaration placed in Allegro.h just
//for using in user defined comm_port_wrapper()
void comm_port_delete(device *port);//#d#Free memory occuped by comm device.
//update registers.
void comm_port_string_send(device *dev,char *s);//#d#Put string contents to the comm port
//output queue.
void comm_port_command_send(device *port,char *s);
void comm_port_break_send(device *dev);
void comm_port_hand(device *dev,int m);
int comm_port_load_settings(device *dev,char *ini_name);
inline int comm_port_send_xoff(device *dev);
inline int comm_port_send_xon(device *dev);
int comm_port_reinstall(device *dev);
void modem_hangup(device *dev);
void dzcomm_init(void);
void print_bin_s(int c,char *s);
extern device *com1;
extern device *com2;
extern device *com3;
extern device *com4;
extern device *com5;
extern device *com6;
extern device *com7;
extern device *com8;
#define com1_ cdport_(com1)
#define com2_ cdport_(com2)
#define com3_ cdport_(com3)
#define com4_ cdport_(com4)
#define com5_ cdport_(com5)
#define com6_ cdport_(com6)
#define com7_ cdport_(com7)
#define com8_ cdport_(com8)

#endif //end  __DZCOMM__

int app_msg_get(dz_app *app,dz_msg *msg);
int app_msg_put(dz_app *app,a_message code,int p1,int p2);

#ifndef __LWP__
//devicelist *allegro_app_list;
//tdlist *allegro_task_list;
//devicelist *allegro_object_list; //#dv# use this variable as first parameter to
//device_new(), if you want to add new software object. (May be it's a window or
//something else).
#endif
//at the current moment 'understend' only one event 'M_STOP'. From any place
//call device_put(system_device,M_STOP) to shutdown system correctly
//device *system_device; //#dv# predefined software object.
//int system_msg_put(a_message code,int p1,int p2);
//int system_handler(a_message code,int p1,int p2);
extern dz_app *system_app;

//- TIMER HELPERS --------------------------------------------------//

typedef struct
{ dz_app *app;
  time_t time_of_next_call;
  time_t period;
} scheduled_app;
#define schedapp_(_tapp) ({(scheduled_app*)(_tapp);})
int scheduler_init(void);
scheduled_app *scheduled_app_add(time_t period,dz_app *app);
int scheduled_app_remove(dz_app *app,time_t period);

typedef struct
{ int da_cent;
  int da_year;
  int da_mon;
  int da_day;
} rdate;

int real_time_clock(int cmd,struct time *real_time);
int real_time_date(int cmd,rdate *real_date);

//---------------------------------------------------TIMER HELPERS -//

extern dz_app *free_mem_monitor;
scheduled_app *free_mem_monitor_install(time_t period);
extern dz_app *clock_app;

typedef struct
{ struct date date;
  struct time time;
} real_time;

scheduled_app *clock_install(time_t period);
//uint diff_time(real_time *past, real_time *now);

#define bcd2bin(_bcd_) ({ ( (_bcd_) & 0x0f ) + ( 10 * ( ( (_bcd_) & 0xf0 ) >> 4) );})
#define bin2bcd(_bin_,_bcd_) ({int i=_bin_/10;*_bcd_=(i<<4)+(_bin_-(i*10));})

//---------------------- WAIT STRING HELPER ----------------------------

typedef struct
{ dz_app *app;//application wich wait for string
  device *dev;//port
  int status;
  char *string;//waited string
  char *string_buf;//runtime buffer
  int string_len;
  int string_buf_len;
} waiting_string;
#define wstring_(_str_) ({(waiting_string*)(_str_);})
int waiting_strings_init(void);
waiting_string *comm_port_waitstring_add(device *port,dz_app *app,char *s);
void comm_port_waitstring_remove(device *port,dz_app *app,char *s);

int make_remote_copy_of_file(char *from_file,char *to_file);
char *wd_cat(char *buf,char *f_name);

//---------------------- WAIT DELIMITER HELPER ----------------------------

typedef enum {BUF_OPEN=1,BUF_CLOSED=2} buf_status_type;

typedef struct
{ dz_app *app;//application wich wait for delimiter
  device *dev;//port
  int status;
  char *delimiter1;//waited delimiter
  char *delimiter1_buf;//runtime buffer
  int delimiter1_len;
  int delimiter1_buf_len;
  char *delimiter2;//waited delimiter
  char *delimiter2_buf;//runtime buffer
  int delimiter2_len;
  int delimiter2_buf_len;
  buf_status_type buffer_status;
  int buffer_len;
  int buffer_max_len;
  char *buffer; //buffer for delimited text
  char *rcv_buffer;
} waiting_delimiter;
#define wdelimiter_(_str_) ({(waiting_delimiter*)(_str_);})
int waiting_delimiter_init(void);
waiting_delimiter *comm_port_waitdelimiters_add(device *dev,dz_app *app,char *s1,char *s2);
void comm_port_waitdelimiter_remove(device *port,dz_app *app,char *s1,char *s2);
int read_delimiters_from_file(waiting_delimiter *wdlm,char *ini_name);
#define BUFFER_OPEN

//------------------------ LOG FILE HELPER -----------------------------

#define LOG_NORMAL 1 //open log and logging until the end of the day ;)
#define LOG_PERIODICAL 2 //open new file at the start of new period
#define LOG_TIME 4 //logging time
#define LOG_START_TIME 8 //start log exactly at the time
#define LOG_START_OFFSET 16//start log at current hour+offset sec.

typedef struct
{ int status; //bit field
  time_t start_time; //when log  open exactly
  char szStartTime[10];
  time_t start_time_offset; //when log  opened from begin of an hour
  time_t log_time; //time to logging
  char szLogTime[10];
  time_t period;
  char szPeriod[10];
  time_t started;
} log_time;
#define ltime_(_time_) ({(log_time*)(_time_);})

typedef struct
{ dz_app *app;
  int hName; //user defined value. Used then file removed from list
  int buffer_size;
  int tail;
  char *buffer;
  char szName[MAXPATH];
  char szPrevName[MAXPATH];
  char szPath[MAXPATH];
  char szCopyPath[MAXPATH];
  char szExt[5];
  char *call_command;
  log_time *time_info;
} log_file;
#define lfile_(_file_) ({(log_file*)(_file_);})
int log_file_init(void);
log_file *comm_port_logfile_add(device *dev,dz_app *app,log_file *Lfile,log_time *Ltime,int buf_size,int hName);
void comm_port_log_file_remove(device *dev,dz_app *task,int hName);
odlist *log_file_add_to_port_from_ini_file(device *port,dz_app *app,char *ini_name);
int log_file_load_settings(log_file *lfile,log_time *ltime,char *ini_name,char *log_name);
//time_t diff_time(time_t t1,time_t t0);
int log_file_get_settings(log_file *lfile,log_time *ltime,char *mem_buf,char *log_name);
int mkdirs(char *path);

//----------------------- PORT MONITOR HELPER ---------------------

dz_app *port_monitor_install();
extern dz_app *port_monitor;

//------------------------- SAVE LOG HELPER -----------------------

dz_app *log_save_install();
extern dz_app *app_log_save;

//---------------------- AUTO DIALER HELPER ----------------------------

typedef struct
{ dz_app *app;//application wich wait for string
  device *dev;//port
  int status;
  char call_command[25];
} dialing_string;
#define dstring_(_str_) ({(dialing_string*)(_str_);})
int autodialer_init(void);
dialing_string *comm_port_dialstring_add(device *port,dz_app *app,char *s);
void comm_port_dialstring_remove(device *port,dz_app *app,char *s);
extern dz_app *adial_app;

extern dz_app *cur_app;

//extern int cur_y;
int idle_proc_add(int (*hnd)(void));
void idle_proc_remove(int (*hnd)(void));

void hwrd(void *args);
void hwwd(void *args);

#ifdef __cplusplus
} //end extern "C"
#endif

#endif //endif __PALANTIR__


