COPPER_FMODE	MACRO
		move.l	#(FMODE<<16)+$000f,(a1)+
		ENDM
		
COPPER_DDFDIW	MACRO
		move.l	#(DDFSTRT<<16)+$0048,(a1)+
		move.l	#(DDFSTOP<<16)+$00c0,(a1)+
		move.l	#(DIWSTRT<<16)+$2ca1,(a1)+
		move.l	#(DIWSTOP<<16)+$eca1,(a1)+
		ENDM
		


; Build of a simple copper list
; a1 = Buffer of chip ram to build copper.
; d0 = Palette Structure
; d1 = Screen Structure
ssBuildRaceCopper:
	movem.l	d0-d7/a0-a3,-(a7)
	move.l	hAddress(a1),a1
	COPPER_FMODE
; Set the Display window sizes
	move.l	#(DDFSTRT<<16)+$0048,(a1)+
	move.l	#(DDFSTOP<<16)+$00c0,(a1)+
	move.l	#(DIWSTRT<<16)+$2ca1,(a1)+
	move.l	#(DIWSTOP<<16)+$eba1,(a1)+
	
	move.l	#(CLXCON<<16)+$0000,(a1)+
	
	move.l	RAWPTR_BLANK_BITPLANES(a6),a3
	move.l	hAddress(a3),d3
	moveq	#0,d3
	
	swap	d3
	move.w	#SPR0PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR0PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR0POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR0CTL,(a1)+
	move.w	#0,(a1)+

	swap	d3
	move.w	#SPR1PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR1PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR1POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR1CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR2PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR2PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR2POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR2CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR3PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR3PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR3POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR3CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR4PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR4PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR4POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR4CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR5PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR5PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR5POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR5CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR6PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR6PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR6POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR6CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR7PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR7PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR7POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR7CTL,(a1)+
	move.w	#0,(a1)+
	
	move.l  #$1001ff00,(a1)+
	
; Load the colour palette High Nybbles
	move.l	#(BPLCON3<<16)+$2ca0,(a1)+
	move.l	PALPTR_INGAME_CARS(a6),a0
	move.l	#COLOR00<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7	
	
	move.l	a1,COPPTR_CAR_PALS(a6)			;
	
	;move.l	a1,COPPTR_CAR1_PAL(a6)
	;move.l	a1,COPPTR_CAR2_PAL(a6)
	;move.l	a1,COPPTR_CAR3_PAL(a6)
	;move.l	a1,COPPTR_CAR4_PAL(a6)
	move.l	#5*4,COPPTR_CAR1OFS_PAL(a6)		; Blue colour 5
	move.l	#11*4,COPPTR_CAR2OFS_PAL(a6)		; Red colour 11
	move.l	#13*4,COPPTR_CAR3OFS_PAL(a6)		; Yellow 13 
	move.l	#9*4,COPPTR_CAR4OFS_PAL(a6)		; Green 9
	
.pal_carh:
	move.l	(a2)+,d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_carh
	
	move.l	#(BPLCON3<<16)+$2ea0,(a1)+
	move.l	PALPTR_INGAME_CARS(a6),a0
	move.l	#COLOR00<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7
	;clr.l	(a2)
.pal_carl:
	move.l	(a2)+,d1
	swap	d1
	move.w	d1,d3
	;move.w	#$fff,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_carl
	
; Load the colour palette High Nybbles
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	PALPTR_LOWER_TRACK(a6),a0
	move.l	#COLOR00<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7
	;clr.l	(a2)
.pal_lowh:
	move.l	(a2)+,d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_lowh
	
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	PALPTR_LOWER_TRACK(a6),a0
	move.l	#COLOR00<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7
	;clr.l	(a2)
.pal_lowl:
	move.l	(a2)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_lowl
	
; Load the colour palette High Nybbles
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	PALPTR_UPPER_TRACK(a6),a0
	move.l	#COLOR16<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7
	;clr.l	(a2)
.pal_uph:
	move.l	(a2)+,d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_uph
	
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	PALPTR_UPPER_TRACK(a6),a0
	move.l	#COLOR16<<16,d3
	lea	hPalette(a0),a2				; Get palette address
	moveq	#16-1,d7
	;clr.l	(a2)
.pal_upl:
	move.l	(a2)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_upl

; Work out the number of bitplanes
	move.w	#BPLCON0,(a1)+
	move.w	#%1000011000010100,(a1)+	; Hires, 8 planes, interlaced, Dual Playfield
	move.w	#BPLCON1,(a1)+
	move.l	a1,COPPTR_BPLCON1(a6)
	move.w	#0,(a1)+
	move.l	a1,COPPTR_BPLCON2(a6)
	move.w	#BPLCON2,(a1)+
	move.w	#%0000000001000111,(a1)+
	move.w	#BPLCON3,(a1)+
	move.w	#$12a0,(a1)+			; First set of 16 colours for 2nd playfield
	move.w	#BPLCON4,(a1)+
	move.w	#$22,(a1)+

	move.l	a1,COPPTR_BPL1MOD(a6)
	
	IFNE	DEBUG_COLLISION_MAP
	move.l	a1,COPPTR_BPL2MOD(a6)
	move.w	#BPL2MOD,(a1)+
	move.w	#64-8,(a1)+
	move.w	#BPL1MOD,(a1)+
	move.w	#(64*7)-8,(a1)+		
	ELSE
	move.w	#BPL1MOD,(a1)+
	move.w	#(64*7)-8,(a1)+
	move.w	#BPL2MOD,(a1)+
	move.w	#(64*7)-8,(a1)+		
	ENDC
	
	move.l	#$1001ff00,(a1)+
	move.l	#INTREQ<<16+$8010,(a1)+	
	
	move.l  #$1601ff00,(a1)+
		
	move.l	a1,COPPTR_SPRPTH0(a6)

	move.l	RAWPTR_BLANK_BITPLANES(a6),a3
	move.l	hAddress(a3),d3
	moveq	#0,d3
	
	swap	d3
	move.w	#SPR0PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR0PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR0POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR0CTL,(a1)+
	move.w	#0,(a1)+

	swap	d3
	move.w	#SPR1PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR1PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR1POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR1CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR2PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR2PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR2POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR2CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR3PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR3PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR3POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR3CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR4PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR4PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR4POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR4CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR5PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR5PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR5POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR5CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR6PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR6PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR6POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR6CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR7PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR7PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR7POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR7CTL,(a1)+
	move.w	#0,(a1)+
	
	
	
	move.l	a1,COPPTR_BPL0PTH(a6)
; Lower track Bitplane pointers
	move.l	DBSPTR_LOWER_TRACK(a6),a0
	move.l	hDbuffScreen1(a0),a0
	moveq	#4-1,d7
	lea	hScreenPointers(a0),a0
	move.l	#BPL0PTH<<16,d3
.lowbp:	move.l	(a0)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3	
	add.l	#$40000,d3
	dbf	d7,.lowbp	
	
; Upper track bitplane pointers
	move.l	a1,COPPTR_BPL1PTH(a6)
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	hDbuffScreen1(a0),a0
	
	;move.l	SCRPTR_UPPER_TRACK_MASK,a0

	;move.l	SCRPTR_UPPER_TRACK,a0
	moveq	#4-1,d7
	lea	hScreenPointers(a0),a0
	move.l	#BPL1PTH<<16,d3
.upperbp:	
	move.l	(a0)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3	
	add.l	#$40000,d3
	dbf	d7,.upperbp
	
	bsr	COPPER_OSD_INGAME
	
	
	move.l	a1,COPPTR_GET_READY(a6)
	move.l  #$8801ff00,(a1)+
	move.l	#(BPLCON3<<16)+$10a0,(a1)+
	move.l	#(COLOR20<<16)+$0ddd,(a1)+
	
	IFNE	DEBUGGING_OSD	
	move.l  #$cb01ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+
	move.l	#BPLCON0<<16+0204,(a1)+
	move.l  #$cc01ff00,(a1)+
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ELSE
	move.l	#$e401ff00,(a1)+
	move.w	#BPLCON3,(a1)+
	move.w	#$10a0,(a1)+			; First set of 16 colours for 2nd playfield
	move.l	#COLOR17<<16+$0f0,(a1)+
	move.l	#COLOR19<<16+$444,(a1)+
	ENDC
	

	
; Wait for line 16	
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	movem.l	(a7)+,d0-d7/a0-a3
	rts
	
	
	
	
; a0=SCRPTR_LOADSAVE
; a1=Copper Buffer
ssLoadSaveCopper:
	movem.l	d0-d7/a0-a3,-(a7)
	move.l	hAddress(a1),a1
	
	move.l	#(FMODE<<16)+$0000,(a1)+
	
	move.l	#(DDFSTRT<<16)+$0048,(a1)+
	move.l	#(DDFSTOP<<16)+$00c0,(a1)+
	move.l	#(DIWSTRT<<16)+$8081,(a1)+
	move.l	#(DIWSTOP<<16)+$88a9,(a1)+

	move.w	#BPLCON3,(a1)+
	move.w	#$0c00,(a1)+
	move.l	#(COLOR00<<16)+$0000,(a1)+
	move.l	#(COLOR01<<16)+$0f10,(a1)+
	
	move.l	#BPLCON0<<16+(BPLCON0F_HIRES!BPLCON0F_COLOR!BPLCON0F_ECSENA),d7
	rol.w	#4,d7
	or.w	#1,d7
	ror.w	#4,d7
	move.l	d7,(a1)+

	move.l	#BPLCON1<<16+0,(a1)+

	move.l	#BPL1MOD<<16+0,(a1)+
	move.l	#BPL2MOD<<16+0,(a1)+
	
; Lower track Bitplane pointers
	lea	hAddress(a0),a0
	move.l	#BPL0PTH<<16,d3
	move.l	a1,COPPTR_BPL0PTH(a6)
	move.l	(a0)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3	
	
	move.l  #$8001ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f10,(a1)+
	move.l  #$8101ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f20,(a1)+
	move.l  #$8201ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f30,(a1)+
	move.l  #$8301ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f40,(a1)+
	move.l  #$8401ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f50,(a1)+
	move.l  #$8501ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f60,(a1)+
	move.l  #$8601ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f70,(a1)+
	move.l  #$8701ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f80,(a1)+
	move.l  #$8801ff00,(a1)+
	move.l	#(COLOR01<<16)+$0f80,(a1)+
	
	move.l	#$fffffffe,(a1)+
	movem.l	(a7)+,d0-d7/a0-a3	
	rts
	
	
; Build of a simple copper list
; a0 = Screen structure (with palette)
; a1 = Buffer of chip ram to build copper.

ssUniCopper:
	movem.l	d0-d7/a0-a3,-(a7)
	move.l	hAddress(a1),a1
	
	COPPER_FMODE

; Set the Display window sizes
	COPPER_DDFDIW
	
	move.l	RAWPTR_BLANK_BITPLANES(a6),a3
	move.l	hAddress(a3),d3
	moveq	#0,d3
	
	swap	d3
	move.w	#SPR0PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR0PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR0POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR0CTL,(a1)+
	move.w	#0,(a1)+

	swap	d3
	move.w	#SPR1PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR1PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR1POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR1CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR2PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR2PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR2POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR2CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR3PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR3PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR3POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR3CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR4PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR4PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR4POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR4CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR5PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR5PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR5POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR5CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR6PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR6PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR6POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR6CTL,(a1)+
	move.w	#0,(a1)+
	
	swap	d3
	move.w	#SPR7PTH,(a1)+	
	move.w	d3,(a1)+
	swap	d3
	move.w	#SPR7PTL,(a1)+
	move.w	d3,(a1)+
	move.w	#SPR7POS,(a1)+
	move.w	#0,(a1)+
	move.w	#SPR7CTL,(a1)+
	move.w	#0,(a1)+
		
; Load the colour palette High Nybbles
	move.w	#(BPLCON3F_SPRES0!BPLCON3F_BRDRBLNK!BPLCON3F_PF2OF1!BPLCON3F_PF2OF2),d5
	move.w	#$0ca0,d5
	moveq	#0,d6

	move.l	hScreenPalette(a0),a2			; Get palette from screen
	move.l	hSize(a2),d7
	divu.l	#3,d7
	move.l	d7,d6					; $40 = 64 colours must be 2
	subq.w	#1,d7
	and.w	#$1f,d7					; 31 colours max
	move.l	d7,d4
	lea	hPalette(a2),a2				; Get palette address
	
	lsr.w	#5,d6					; Divide by 32
	bmi.s	.16col
	beq.s	.16col
	subq.w	#1,d6

.16col:


.bank_loop:
	move.l	a1,COPPTR_WINCARS_PAL(a6)
	
	move.l	d4,d7
	move.w	#BPLCON3,(a1)+
	move.w	d5,(a1)+
	move.l	#COLOR00<<16,d3
	
	move.l	a1,COPPTR_TRACK_SELECT_PALETTE(a6)
	move.l	a1,COPPTR_UPGRADE_CAR_PALETTE(a6)

	clr.l	(a2)
.pal_bankhi:
	move.l	(a2)+,d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_bankhi

	eor.w	#BPLCON3F_LOCT,d5
	move.w	#BPLCON3,(a1)+
	move.w	d5,(a1)+
	
; This is loading the same damn palette into high

	move.l	hScreenPalette(a0),a2			; Get palette from screen
	lea	hPalette(a2),a2				; Get palette address
	move.l	d4,d7
	
	move.l	#COLOR00<<16,d3
	clr.l	(a2)
.pal_banklo:
	move.l	(a2)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	dbf	d7,.pal_banklo
	add.w	#%0010000000000000,d5	
	eor.w	#BPLCON3F_LOCT,d5	
	dbf	d6,.bank_loop
	
; Work out the number of bitplanes
	move.l	#BPLCON0<<16+(BPLCON0F_HIRES!BPLCON0F_COLOR!BPLCON0F_LACE!BPLCON0F_ECSENA),d7
	rol.w	#4,d7
	or.w	hScreenPlanes(a0),d7
	ror.w	#4,d7
	move.l	d7,(a1)+

	move.l	a1,COPPTR_BPLCON1(a6)
	move.l	#BPLCON1<<16+0,(a1)+
	
	move.l	a1,COPPTR_BPLCON2(a6)
	move.l	#BPLCON2<<16+(BPLCON2F_PF2PRI!BPLCON2F_PF1P2!BPLCON2F_PF1P1!BPLCON2F_PF1P0!BPLCON2F_KILLEHB),(a1)+
	
	move.l	a1,COPPTR_BPLCON3(a6)
	move.l	#BPLCON3<<16+(BPLCON3F_PF2OF0!BPLCON3F_PF2OF1!BPLCON3F_PF2OF2!BPLCON3F_LOCT!BPLCON3F_SPRES1),(a1)+
	
	move.l	a1,COPPTR_BPLCON4(a6)
	move.l	#BPLCON4<<16+0,(a1)+
		
; Calculate modulo for the screen/bitplanes
	move.w	hScreenWidth(a0),d7
	add.w	d7,d7				; For interlacing
	mulu.w	hScreenPlanes(a0),d7
	sub.w	hScreenWidth(a0),d7
	subq.w	#8,d7
	
	move.l  #$2501ff00,(a1)+
	
	move.w	#BPL1MOD,(a1)+
	move.w	d7,(a1)+
	move.w	#BPL2MOD,(a1)+
	move.w	d7,(a1)+
	
	move.l	a1,COPPTR_BPL0PTH(a6)
; Lower track Bitplane pointers
	move.w	hScreenPlanes(a0),d7			; d7 = Number of planes
	subq.w	#1,d7	
	lea	hScreenPointers(a0),a0
	move.l	#BPL0PTH<<16,d3
	move.l	a1,COPPTR_BPL0PTH(a6)
.fg:	move.l	(a0)+,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3	
	dbf	d7,.fg	

	cmp.w	#sceneCredits,CURRENT_SCENE(a6)
	beq	.copCredits
	cmp.w	#sceneTitle,CURRENT_SCENE(a6)
	beq	.copTitle
	cmp.w	#scenePrepareRace,CURRENT_SCENE(a6)
	beq	.copPrepareRace
	cmp.w	#sceneUpgradeCar,CURRENT_SCENE(a6)
	beq	.copUpgradeCar
	cmp.w	#sceneTrackSelect,CURRENT_SCENE(a6)
	beq	.copTrackSelect
	cmp.w	#sceneHiscore,CURRENT_SCENE(a6)
	beq	.copHiscore
	cmp.w	#sceneWinningCars,CURRENT_SCENE(a6)
	beq	.copWinningCars
	move.l  #$2701ff00,(a1)+
	bsr	SUB_COPPER_OSD_UPPER
	move.l  #$e001ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR01<<16)+$00f0,(a1)+	; Green
	move.l	#(COLOR02<<16)+$0222,(a1)+
	move.l	#(COLOR03<<16)+$0000,(a1)+
	bra	.copper_end
	
.copUpgradeCar:
	move.l  #$2701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+	
	move.l	#(COLOR00<<16)+$607,(a1)+
	
	bsr	SUB_COPPER_OSD_UPPER
	move.l	a1,COPPTR_WHEEL_POINTER(a6)
	move.l	#COLOR01<<16+$0000,(a1)+
	move.l	#COLOR02<<16+$0000,(a1)+
	
	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ELSE
	
	move.l  #$e001ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0Ca0,(a1)+
	move.l	#(COLOR01<<16)+$00f0,(a1)+	; Green
	move.l	#(COLOR02<<16)+$0222,(a1)+
	move.l	#(COLOR03<<16)+$0000,(a1)+
	ENDC
	bra	.copper_end	
	
.copTitle:
;	move.l	#COLOR03<<16+$0e0e,(a1)+
;	bsr	SUB_COPPER_OSD_UPPER
;	move.l	#COLOR01<<16+$0eee,(a1)+
;	move.l	#COLOR02<<16+$0888,(a1)+
;	move.l	#COLOR02<<16+$0222,(a1)+

	move.l  #$2701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#COLOR01<<16+$0de,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#COLOR01<<16+$0ff,(a1)+	
	
	move.l  #$2801ff00,(a1)+
	move.l	#COLOR01<<16+$0ee,(a1)+		
	move.l  #$2901ff00,(a1)+
	move.l	#COLOR01<<16+$0dd,(a1)+		
	move.l  #$2a01ff00,(a1)+
	move.l	#COLOR01<<16+$0cc,(a1)+	
	move.l  #$2b01ff00,(a1)+
	move.l	#COLOR01<<16+$0bb,(a1)+	
	move.l  #$2c01ff00,(a1)+
	move.l	#COLOR01<<16+$0aa,(a1)+	
	move.l  #$2d01ff00,(a1)+
	move.l	#COLOR01<<16+$099,(a1)+	
	move.l  #$2e01ff00,(a1)+
	move.l	#COLOR01<<16+$088,(a1)+	
	move.l  #$2f01ff00,(a1)+
	move.l	#COLOR01<<16+$077,(a1)+	
	move.l  #$3001ff00,(a1)+
	move.l	#COLOR01<<16+$066,(a1)+		
	move.l  #$3101ff00,(a1)+
	move.l	#COLOR01<<16+$055,(a1)+		
	move.l  #$3201ff00,(a1)+
	move.l	#COLOR01<<16+$044,(a1)+	
	move.l  #$3301ff00,(a1)+
	move.l	#COLOR01<<16+$033,(a1)+	
	move.l  #$3401ff00,(a1)+
	move.l	#COLOR01<<16+$022,(a1)+	
	move.l  #$3501ff00,(a1)+
	move.l	#COLOR01<<16+$011,(a1)+	
	move.l  #$3601ff00,(a1)+
	move.l	#COLOR01<<16+$000,(a1)+	

	move.l  #$3701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#COLOR01<<16+$0cd,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#COLOR01<<16+$0ff,(a1)+	
	move.l  #$3801ff00,(a1)+
	move.l	#COLOR01<<16+$0ee,(a1)+		
	move.l  #$3901ff00,(a1)+
	move.l	#COLOR01<<16+$0dd,(a1)+		
	move.l  #$3a01ff00,(a1)+
	move.l	#COLOR01<<16+$0cc,(a1)+	
	move.l  #$3b01ff00,(a1)+
	move.l	#COLOR01<<16+$0bb,(a1)+	
	move.l  #$3c01ff00,(a1)+
	move.l	#COLOR01<<16+$0aa,(a1)+	
	move.l  #$3d01ff00,(a1)+
	move.l	#COLOR01<<16+$099,(a1)+	
	move.l  #$3e01ff00,(a1)+
	move.l	#COLOR01<<16+$088,(a1)+	
	move.l  #$3f01ff00,(a1)+
	move.l	#COLOR01<<16+$077,(a1)+	
	move.l  #$4001ff00,(a1)+
	move.l	#COLOR01<<16+$066,(a1)+		
	move.l  #$4101ff00,(a1)+
	move.l	#COLOR01<<16+$055,(a1)+		
	move.l  #$4201ff00,(a1)+
	move.l	#COLOR01<<16+$044,(a1)+	
	move.l  #$4301ff00,(a1)+
	move.l	#COLOR01<<16+$033,(a1)+	
	move.l  #$4401ff00,(a1)+
	move.l	#COLOR01<<16+$022,(a1)+	
	move.l  #$4501ff00,(a1)+
	move.l	#COLOR01<<16+$011,(a1)+	
	move.l  #$4601ff00,(a1)+
	move.l	#COLOR01<<16+$000,(a1)+		

	move.l  #$4701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#COLOR01<<16+$0bc,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#COLOR01<<16+$0ff,(a1)+	
	move.l  #$4801ff00,(a1)+
	move.l	#COLOR01<<16+$0ee,(a1)+		
	move.l  #$4901ff00,(a1)+
	move.l	#COLOR01<<16+$0dd,(a1)+		
	move.l  #$4a01ff00,(a1)+
	move.l	#COLOR01<<16+$0cc,(a1)+	
	move.l  #$4b01ff00,(a1)+
	move.l	#COLOR01<<16+$0bb,(a1)+	
	move.l  #$4c01ff00,(a1)+
	move.l	#COLOR01<<16+$0aa,(a1)+	
	move.l  #$4d01ff00,(a1)+
	move.l	#COLOR01<<16+$099,(a1)+	
	move.l  #$4e01ff00,(a1)+
	move.l	#COLOR01<<16+$088,(a1)+	
	move.l  #$4f01ff00,(a1)+
	move.l	#COLOR01<<16+$077,(a1)+	
	move.l  #$5001ff00,(a1)+
	move.l	#COLOR01<<16+$066,(a1)+		
	move.l  #$5101ff00,(a1)+
	move.l	#COLOR01<<16+$055,(a1)+		
	move.l  #$5201ff00,(a1)+
	move.l	#COLOR01<<16+$044,(a1)+	
	move.l  #$5301ff00,(a1)+
	move.l	#COLOR01<<16+$033,(a1)+	
	move.l  #$5401ff00,(a1)+
	move.l	#COLOR01<<16+$022,(a1)+	
	move.l  #$5501ff00,(a1)+
	move.l	#COLOR01<<16+$011,(a1)+	
	move.l  #$5601ff00,(a1)+
	move.l	#COLOR01<<16+$000,(a1)+		
	
	move.l  #$5701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#COLOR01<<16+$0ab,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#COLOR01<<16+$0ff,(a1)+	
	move.l  #$5801ff00,(a1)+
	move.l	#COLOR01<<16+$0ee,(a1)+		
	move.l  #$5901ff00,(a1)+
	move.l	#COLOR01<<16+$0dd,(a1)+		
	move.l  #$5a01ff00,(a1)+
	move.l	#COLOR01<<16+$0cc,(a1)+	
	move.l  #$5b01ff00,(a1)+
	move.l	#COLOR01<<16+$0bb,(a1)+	
	move.l  #$5c01ff00,(a1)+
	move.l	#COLOR01<<16+$0aa,(a1)+	
	move.l  #$5d01ff00,(a1)+
	move.l	#COLOR01<<16+$099,(a1)+	
	move.l  #$5e01ff00,(a1)+
	move.l	#COLOR01<<16+$088,(a1)+	
	move.l  #$5f01ff00,(a1)+
	move.l	#COLOR01<<16+$077,(a1)+	
	move.l  #$6001ff00,(a1)+
	move.l	#COLOR01<<16+$066,(a1)+		
	move.l  #$6101ff00,(a1)+
	move.l	#COLOR01<<16+$055,(a1)+		
	move.l  #$6201ff00,(a1)+
	move.l	#COLOR01<<16+$044,(a1)+	
	move.l  #$6301ff00,(a1)+
	move.l	#COLOR01<<16+$033,(a1)+	
	move.l  #$6401ff00,(a1)+
	move.l	#COLOR01<<16+$022,(a1)+	
	move.l  #$6501ff00,(a1)+
	move.l	#COLOR01<<16+$011,(a1)+	
	move.l  #$6601ff00,(a1)+
	move.l	#COLOR01<<16+$000,(a1)+	

	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	
	move.l	a1,COPPTR_TITLE_TEXT1(a6)
	move.l	#$c201ff00,(a1)+
	move.l	#COLOR12<<16+$0e0e,(a1)+
	move.l	#$ca01ff00,(a1)+
	move.l	#COLOR10<<16+$0ee,(a1)+	
	move.l	#$d201ff00,(a1)+
	move.l	#COLOR10<<16+$f80,(a1)+	

	;move.l	#$c201ff00,(a1)+
	;move.l	#COLOR00<<16+$0e0e,(a1)+
	;move.l	#$ca01ff00,(a1)+
	;move.l	#COLOR00<<16+$0ee,(a1)+	
	;move.l	#$d201ff00,(a1)+
	;move.l	#COLOR00<<16+$f80,(a1)+	
	

	
	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ENDC
	
	bra	.copper_end
	
.copHiscore:
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+	
	move.l  #$2701ff00,(a1)+
	move.l	#COLOR01<<16+$0eee,(a1)+
	move.l	#COLOR01<<16+$0eee,(a1)+

	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ENDC

	bra	.copper_end
	
.copCredits:
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	

	move.l  #$4c01ff00,(a1)+			
	move.l	#COLOR01<<16+$0c00,(a1)+
	move.l	#COLOR02<<16+$0400,(a1)+
	
	move.l  #$5401ff00,(a1)+			
	move.l	#COLOR01<<16+$0fff,(a1)+
	move.l	#COLOR02<<16+$0444,(a1)+
	
	move.l  #$6401ff00,(a1)+			
	move.l	#COLOR01<<16+$00a0,(a1)+
	move.l	#COLOR02<<16+$0040,(a1)+
	
	move.l  #$6c01ff00,(a1)+			
	move.l	#COLOR01<<16+$0fff,(a1)+
	move.l	#COLOR02<<16+$0444,(a1)+
	
	move.l  #$8401ff00,(a1)+			
	move.l	#COLOR01<<16+$0aa0,(a1)+
	move.l	#COLOR02<<16+$0440,(a1)+

	move.l  #$8c01ff00,(a1)+			
	move.l	#COLOR01<<16+$0fff,(a1)+
	move.l	#COLOR02<<16+$0444,(a1)+

	move.l  #$a401ff00,(a1)+			
	move.l	#COLOR01<<16+$00aa,(a1)+
	move.l	#COLOR02<<16+$0044,(a1)+

	move.l  #$ac01ff00,(a1)+			
	move.l	#COLOR01<<16+$0fff,(a1)+
	move.l	#COLOR02<<16+$0444,(a1)+
	
	bra	.copper_end

	
	
	
.copPrepareRace:
	move.l  #$2701ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+	
	move.l	#(COLOR00<<16)+$607,(a1)+
	
	moveq	#64,d7
	move.l	#$2801fffe,d3
	move.l	#$2825fffe,d4
	move.l	#$2875fffe,d5			;< wait for hpos $77
	move.l	#$28a5fffe,d6
	
	move.l	d3,(a1)+
	move.l	#(COLOR04<<16)+$0222,(a1)+
	move.l	#(COLOR02<<16)+$0737,(a1)+
	
.cpr1:	move.l	d4,(a1)+		
	move.l	#(COLOR01<<16)+$0004,(a1)+	
	move.l	#(COLOR02<<16)+$000f,(a1)+	
	move.l	d5,(a1)+		
	move.l	#(COLOR01<<16)+$0400,(a1)+	
	move.l	#(COLOR02<<16)+$0f00,(a1)+
	move.l	d6,(a1)+		
	move.l	#(COLOR01<<16)+$0440,(a1)+	
	move.l	#(COLOR02<<16)+$0ff0,(a1)+
	rol.l	#8,d3
	rol.l	#8,d4
	rol.l	#8,d5
	rol.l	#8,d6
	addq.b	#1,d3
	addq.b	#1,d4
	addq.b	#1,d5
	addq.b	#1,d6
	ror.l	#8,d3
	ror.l	#8,d4
	ror.l	#8,d5
	ror.l	#8,d6	
	dbf	d7,.cpr1	

; Split car colour
	move.l	d3,(a1)+
	move.l	#(COLOR04<<16)+$0969,(a1)+
	move.l	#(COLOR02<<16)+$0737,(a1)+

	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l  #$b001ff00,(a1)+
	move.l	#COLOR08<<16+$d00,(a1)+
	move.l	#COLOR09<<16+$e00,(a1)+
	move.l	#COLOR10<<16+$f88,(a1)+
	move.l	#COLOR11<<16+$b80,(a1)+
	move.l	#COLOR12<<16+$eb0,(a1)+
	move.l	#COLOR13<<16+$fc0,(a1)+

	move.l	#COLOR16<<16+$090,(a1)+	
	move.l	#COLOR17<<16+$0a0,(a1)+
	move.l	#COLOR18<<16+$0b0,(a1)+
	move.l	#COLOR19<<16+$0d2,(a1)+
	move.l	#COLOR20<<16+$0e2,(a1)+
	move.l	#COLOR21<<16+$0e9,(a1)+
	
	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ELSE
	
	move.l  #$e001ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0Ca0,(a1)+
	move.l	#(COLOR02<<16)+$00f0,(a1)+	; Blue
	move.l	#(COLOR04<<16)+$0000,(a1)+
	ENDC
	bra	.copper_end
	
.copWinningCars:

	move.l	#(FMODE<<16)+$0003,(a1)+
		
	move.l  #$2701ff00,(a1)+

	move.w	#BPLCON2,(a1)+
	move.w	#%0000001000100100,(a1)+	; Kill EHB 
	move.w	#BPLCON4,(a1)+
	move.w	#$0066,(a1)+
	
; Select car colours
	move.l	#(BPLCON3<<16)+$6ca0,(a1)+
	move.l	#(COLOR00<<16)+$000,(a1)+
	move.l	#(COLOR01<<16)+$a40,(a1)+	
	move.l	#(COLOR03<<16)+$e88,(a1)+	
	
	move.l	#(COLOR04<<16)+$000,(a1)+
	move.l	#(COLOR05<<16)+$a40,(a1)+	
	move.l	#(COLOR07<<16)+$e88,(a1)+
	
	move.l	#(COLOR08<<16)+$000,(a1)+
	move.l	#(COLOR09<<16)+$a40,(a1)+	
	move.l	#(COLOR11<<16)+$e88,(a1)+
	
	move.l	#(COLOR12<<16)+$000,(a1)+
	move.l	#(COLOR13<<16)+$a40,(a1)+	
	move.l	#(COLOR15<<16)+$e88,(a1)+
	
	move.l	a1,COPPTR_WINCARS_FLAGS
	move.l	#(COLOR02<<16)+$f0f,(a1)+
	move.l	#(COLOR06<<16)+$f0f,(a1)+	
	move.l	#(COLOR10<<16)+$f0f,(a1)+
	move.l	#(COLOR14<<16)+$f0f,(a1)+	
	
	move.l  #$1501ff00,(a1)+
	
	bsr	SUB_COPPER_OSD_WC

	move.l	#(BPLCON3<<16)+$6ca0,(a1)+

	move.l	a1,COPPTR_SPRITE_FLAGS_1(a6)
	move.l	#(SPR0PTH<<16)+0,(a1)+
	move.l	#(SPR0PTL<<16)+0,(a1)+
	move.l	#(SPR0POS<<16)+0,(a1)+
	move.l	#(SPR0CTL<<16)+0,(a1)+

	move.l	#(SPR1PTH<<16)+0,(a1)+
	move.l	#(SPR1PTL<<16)+0,(a1)+
	move.l	#(SPR1POS<<16)+0,(a1)+
	move.l	#(SPR1CTL<<16)+0,(a1)+
	
	move.l	#(SPR2PTH<<16)+0,(a1)+
	move.l	#(SPR2PTL<<16)+0,(a1)+
	move.l	#(SPR2POS<<16)+0,(a1)+
	move.l	#(SPR2CTL<<16)+0,(a1)+
	
	move.l	#(SPR3PTH<<16)+0,(a1)+
	move.l	#(SPR3PTL<<16)+0,(a1)+
	move.l	#(SPR3POS<<16)+0,(a1)+
	move.l	#(SPR3CTL<<16)+0,(a1)+
	
	move.l	#(SPR4PTH<<16)+0,(a1)+
	move.l	#(SPR4PTL<<16)+0,(a1)+
	move.l	#(SPR4POS<<16)+0,(a1)+
	move.l	#(SPR4CTL<<16)+0,(a1)+
	
	move.l	#(SPR5PTH<<16)+0,(a1)+
	move.l	#(SPR5PTL<<16)+0,(a1)+
	move.l	#(SPR5POS<<16)+0,(a1)+
	move.l	#(SPR5CTL<<16)+0,(a1)+
	
	move.l	#(SPR6PTH<<16)+0,(a1)+
	move.l	#(SPR6PTL<<16)+0,(a1)+
	move.l	#(SPR6POS<<16)+0,(a1)+
	move.l	#(SPR6CTL<<16)+0,(a1)+
	
	move.l	#(SPR7PTH<<16)+0,(a1)+
	move.l	#(SPR7PTL<<16)+0,(a1)+
	move.l	#(SPR7POS<<16)+0,(a1)+
	move.l	#(SPR7CTL<<16)+0,(a1)+
	
	move.l  #$4c01ff00,(a1)+
	move.l	#(COLOR00<<16)+$f00,(a1)+
	
	move.l	a1,COPPTR_SPRITE_FLAGS_2(a6)
	move.l	#(SPR0PTH<<16)+0,(a1)+
	move.l	#(SPR0PTL<<16)+0,(a1)+
	move.l	#(SPR0POS<<16)+0,(a1)+
	move.l	#(SPR0CTL<<16)+0,(a1)+

	move.l	#(SPR1PTH<<16)+0,(a1)+
	move.l	#(SPR1PTL<<16)+0,(a1)+
	move.l	#(SPR1POS<<16)+0,(a1)+
	move.l	#(SPR1CTL<<16)+0,(a1)+
	
	move.l	#(SPR2PTH<<16)+0,(a1)+
	move.l	#(SPR2PTL<<16)+0,(a1)+
	move.l	#(SPR2POS<<16)+0,(a1)+
	move.l	#(SPR2CTL<<16)+0,(a1)+
	
	move.l	#(SPR3PTH<<16)+0,(a1)+
	move.l	#(SPR3PTL<<16)+0,(a1)+
	move.l	#(SPR3POS<<16)+0,(a1)+
	move.l	#(SPR3CTL<<16)+0,(a1)+
	
	move.l	#(SPR4PTH<<16)+0,(a1)+
	move.l	#(SPR4PTL<<16)+0,(a1)+
	move.l	#(SPR4POS<<16)+0,(a1)+
	move.l	#(SPR4CTL<<16)+0,(a1)+
	
	move.l	#(SPR5PTH<<16)+0,(a1)+
	move.l	#(SPR5PTL<<16)+0,(a1)+
	move.l	#(SPR5POS<<16)+0,(a1)+
	move.l	#(SPR5CTL<<16)+0,(a1)+
	
	move.l	#(SPR6PTH<<16)+0,(a1)+
	move.l	#(SPR6PTL<<16)+0,(a1)+
	move.l	#(SPR6POS<<16)+0,(a1)+
	move.l	#(SPR6CTL<<16)+0,(a1)+
	
	move.l	#(SPR7PTH<<16)+0,(a1)+
	move.l	#(SPR7PTL<<16)+0,(a1)+
	move.l	#(SPR7POS<<16)+0,(a1)+
	move.l	#(SPR7CTL<<16)+0,(a1)+	
	
	;move.l	a1,COPPTR_COLOR00(a6)
	move.l  #$6c01ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$999,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#(COLOR00<<16)+$eee,(a1)+
	
	move.l  #$8c01ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$666,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#(COLOR00<<16)+$000,(a1)+
	
	move.l  #$b001ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR12<<16)+$a30,(a1)+			; Hair colour correction

	move.l	#(BPLCON3<<16)+$2ca0,(a1)+
	move.l	#(COLOR13<<16)+$e90,(a1)+			; Hair colour correction
	move.l	#(COLOR00<<16)+$45a,(a1)+			; Engineer Suit correction
	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+

	move.l  #$b401ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$444,(a1)+
	
	move.l  #$c801ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$a53,(a1)+
	;move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	;move.l	#(COLOR00<<16)+$fff,(a1)+
	
	move.l  #$cc01ff00,(a1)+	
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$c86,(a1)+
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#(COLOR00<<16)+$f46,(a1)+
	
	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ELSE
	
	move.l  #$e301ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0Ca0,(a1)+
	move.l	#(COLOR01<<16)+$00f0,(a1)+	; Green
	move.l	#(COLOR02<<16)+$0222,(a1)+
	move.l	#(COLOR03<<16)+$0000,(a1)+
	ENDC
	
	bra	.copper_end
	
.copTrackSelect:
	move.l	#(BPLCON3<<16)+$0Ca0,(a1)+
	moveq	#17,d7
	move.l	#$2c01fffe,d3
	move.l	#$2c25fffe,d4
	move.l	#$2c79fffe,d5
	move.l	#$2ca5fffe,d6
	
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0000,(a1)+	
	
.text:	move.l	d4,(a1)+		
	move.l	#(COLOR01<<16)+$000f,(a1)+	; Blue
	move.l	#(COLOR02<<16)+$0004,(a1)+	; Blue
	move.l	d5,(a1)+		
	move.l	#(COLOR01<<16)+$0f00,(a1)+	; Red
	move.l	#(COLOR02<<16)+$0400,(a1)+	; Blue
	move.l	d6,(a1)+		
	move.l	#(COLOR01<<16)+$0ff2,(a1)+	; Yellow
	move.l	#(COLOR02<<16)+$0440,(a1)+	; Blue
	
	rol.l	#8,d3
	rol.l	#8,d4
	rol.l	#8,d5
	rol.l	#8,d6
	addq.b	#1,d3
	addq.b	#1,d4
	addq.b	#1,d5
	addq.b	#1,d6
	ror.l	#8,d3
	ror.l	#8,d4
	ror.l	#8,d5
	ror.l	#8,d6	
	dbf	d7,.text	
	
	move.l	a1,COPPTR_TRACK_SELECT_PLAYER
	move.l	d3,(a1)+
	move.l	#(COLOR01<<16)+$0ddd,(a1)+
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0333,(a1)+
	
	IFNE	DEBUGGING_OSD	
	move.l  #$d801ff00,(a1)+		; cb
	move.l	#COLOR00<<16+$0300,(a1)+	
	move.l	#FMODE<<16+0,(a1)+
	bsr	agdCreateDebugCopper
	ELSE
	
	move.l  #$e001ff00,(a1)+
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR01<<16)+$00f0,(a1)+	; Green
	move.l	#(COLOR02<<16)+$0040,(a1)+
	move.l	#(COLOR03<<16)+$0000,(a1)+
	
	ENDC
	
	bra	.copper_end
	nop

.copper_end:	
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	move.l	#$fffffffe,(a1)+
	
	movem.l	(a7)+,d0-d7/a0-a3
	rts
	


SUB_COPPER_OSD_UPPER:
; Horizontal wait
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	moveq	#17,d7
	move.l	#$2c01fffe,d3
	move.l	#$2c25fffe,d4
	move.l	#$2c79fffe,d5
	move.l	#$2ca5fffe,d6
	
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0000,(a1)+	
	
.text:	move.l	d4,(a1)+		
	move.l	#(COLOR01<<16)+$000f,(a1)+	; Blue
	move.l	#(COLOR02<<16)+$0004,(a1)+	; Blue
	move.l	d5,(a1)+		
	move.l	#(COLOR01<<16)+$0f00,(a1)+	; Red
	move.l	#(COLOR02<<16)+$0400,(a1)+	; Blue
	move.l	d6,(a1)+		
	move.l	#(COLOR01<<16)+$0ff2,(a1)+	; Yellow
	move.l	#(COLOR02<<16)+$0440,(a1)+	; Blue
	rol.l	#8,d3
	rol.l	#8,d4
	rol.l	#8,d5
	rol.l	#8,d6
	addq.b	#1,d3
	addq.b	#1,d4
	addq.b	#1,d5
	addq.b	#1,d6
	ror.l	#8,d3
	ror.l	#8,d4
	ror.l	#8,d5
	ror.l	#8,d6	
	dbf	d7,.text	

	move.l	d3,(a1)+
	move.l	#(COLOR01<<16)+$00f0,(a1)+
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0040,(a1)+
	rts
	
SUB_COPPER_OSD_WC:
; Horizontal wait
	move.l	#(BPLCON3<<16)+$0ca0,(a1)+
	move.l	#(COLOR00<<16)+$0428,(a1)+		; 64   32  128
	move.l	#(BPLCON3<<16)+$0ea0,(a1)+
	move.l	#(COLOR00<<16)+$0ac6,(a1)+		; $a   $c  $6=(134)


	move.l	#(BPLCON3<<16)+$0ca0,(a1)+	
	moveq	#17,d7
	move.l	#$2c01fffe,d3
	move.l	#$2c25fffe,d4
	move.l	#$2c79fffe,d5
	move.l	#$2ca5fffe,d6
	
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0000,(a1)+
	
.text:	move.l	d4,(a1)+		
	move.l	#(COLOR01<<16)+$000f,(a1)+	; Blue
	move.l	#(COLOR02<<16)+$0004,(a1)+	; Blue
	move.l	d5,(a1)+		
	move.l	#(COLOR01<<16)+$0f00,(a1)+	; Red
	move.l	#(COLOR02<<16)+$0400,(a1)+	; Red
	move.l	d6,(a1)+		
	move.l	#(COLOR01<<16)+$0ff2,(a1)+	; Yellow
	move.l	#(COLOR02<<16)+$0440,(a1)+	; Yellow
	rol.l	#8,d3
	rol.l	#8,d4
	rol.l	#8,d5
	rol.l	#8,d6
	addq.b	#1,d3
	addq.b	#1,d4
	addq.b	#1,d5
	addq.b	#1,d6
	ror.l	#8,d3
	ror.l	#8,d4
	ror.l	#8,d5
	ror.l	#8,d6	
	dbf	d7,.text	

	move.l	d3,(a1)+
	move.l	#(COLOR01<<16)+$0333,(a1)+
	move.l	d3,(a1)+
	move.l	#(COLOR02<<16)+$0410,(a1)+
	rts
	
	
FONT_COLREG:	equ	COLOR17
	
COPPER_OSD_INGAME:
; Horizontal wait
	move.l	#(BPLCON3<<16)+$10a0,(a1)+
	
	moveq	#17,d7
	move.l	#$2c01ff01,d3
	move.l	#$2c25fffe,d4
	move.l	#$2c75fffe,d5			;< wait for hpos $77
	move.l	#$2ca5fffe,d6
	
	move.l	d3,(a1)+
	move.l	#(FONT_COLREG<<16)+$0000,(a1)+	; BP1 <<< Color 17 is in use!
.text:	move.l	d4,(a1)+		
	move.l	#(FONT_COLREG<<16)+$000f,(a1)+		
	move.l	d5,(a1)+		
	move.l	#(FONT_COLREG<<16)+$0f00,(a1)+	
	move.l	d6,(a1)+		
	move.l	#(FONT_COLREG<<16)+$0ff0,(a1)+	
	rol.l	#8,d3
	rol.l	#8,d4
	rol.l	#8,d5
	rol.l	#8,d6
	addq.b	#1,d3
	addq.b	#1,d4
	addq.b	#1,d5
	addq.b	#1,d6
	ror.l	#8,d3
	ror.l	#8,d4
	ror.l	#8,d5
	ror.l	#8,d6	
	dbf	d7,.text	

	;move.l	#(FONT_COLREG<<16)+$0f0f,(a1)+	; BP1 <<< Color 17 is in use!
	
	move.w	#BPLCON3,(a1)+
	move.w	#$12a0,(a1)+			; First set of 16 colours for 2nd playfield
	rts