			

; Create a new global handle or resource
; Input
; d0=Resource Type to return
; Output
; d0=Handle number
; a0=Handle pointer
;--------------------------------------
agdCreateNewHandle:
		movem.l	d6-d7,-(a7)
		IFNE	ENABLE_HANDLE_TRACKING
		move.w	d0,$124.w			; Debug for create new handle.
		ENDC
		
		move.l	#0,d6				; Handle counter	
		lea	RESOURCE_TABLE(a6),a0
		IFNE	ENABLE_HANDLE_TRACKING
		move.l	a0,$120
		ENDC
		lsl.l	#4,d0				; Multiply by 16
		add.l	d0,a0				; Index to correct type
		
		addq.l	#1,12(a0)			; Increase number of handles allocated.
		move.l	8(a0),d7			; Maximum number of handles
		move.l	4(a0),d0			; Get the structure size
		move.l	(a0),a0				; Get the address of the structures
		subq.w	#1,d7
		
.loop:		tst.w	(a0)				; Is the handle free?
		bmi	.allocate
		add.l	d0,a0				; Next handle
		add.w	#1,d6
		dbf	d7,.loop
		moveq	#-1,d0				; Error code in d0
.crash:		move.w	#$707,$dff180	
		bra	.crash
		
; Exhausted all handles
.allocate:	move.l	d6,d0				; Return handle 

.exit:		movem.l	(a7)+,d6-d7
		rts
	
	
; a0=Handle Pointer
agdDestroyHandle:
		cmp.l	#0,a0
		beq	.blank
		
		bsr	agdCheckHandleSanity
		tst.l	d1
		bmi.s	.error

; Get size of the handle
		move.l	hType(a0),d1			;Get type of handle we are destroying
		bmi.s	.exit
		lea	RESOURCE_TABLE(a6),a1
		lsl.l	#4,d1				; Index to its type
		add.l	d1,a1				
		move.l	4(a1),d1			; Get the struct size

.loop:		move.b	#-1,(a0,d1)			; Clear the handle.
		dbf	d1,.loop
		subq.l	#1,12(a1)			; Reduce handle numbers
		bra.s	.exit
.blank:		moveq	#0,d0
		bra	.exit
.error:		nop
.exit:		rts


agdCheckHandleSanity:
		moveq	#-1,d1

		cmp.l	#-1,a0
		beq	.error
		
		cmp.l	#maxTypes,hType(a0)
		bgt.s	.error
		cmp.l	#maxResourceStructs,hIndex(a0)
		bgt.s	.error
		
		moveq	#0,d1
		bra	.exit
.error:		

.exit:		rts
		
	
;a1=Memory ptr
agdClearResource:
		movem.l	d1/a1,-(a7)
		move.l	hSize(a1),d1
		move.l	(a1),a1
		lsr.l	#4,d1
		subq.w	#1,d1
.clear:		clr.l	(a1)+
		clr.l	(a1)+
		clr.l	(a1)+
		clr.l	(a1)+
		;move.l	#-1,(a1)+
		dbf	d1,.clear
		movem.l	(a7)+,d1/a1
		rts