
SPRITE_SIZE_16x16:	equ	0
SPRITE_SIZE_32x32:	equ	1
SPRITE_SIZE_32x60:	equ	2

SPRITE_SLOT_SIZE:       equ     2048

	
agdBuildHardwareSpriteXY:
	agdSerialEntry #$2c392149
        lea     HWSPR_TAB_XPOS(a6),a0
        lea     HWSPR_TAB_YPOS(a6),a1

        move.l  #512-1,d7
        moveq   #0,d0
        moveq   #0,d1
        moveq   #0,d2
        moveq   #0,d3

        moveq   #0,d6           ; counter

.loop:
        move.w  d6,d1           ; vstart
        move.w  d6,d2
        lsr.w   #8,d2
        and.w   #1,d2           ; vstart high bit
        lsl.w   #2,d2           ; into bit position 2
        and.w   #$ff,d1         ; vstart low bits
        lsl.w   #8,d1           ; Word 1
        move.w  d1,(a1)+        ; store SPRPOS word

        move.w  d6,d1           ; vstop
        move.w  d6,d3
        ;add.w   #$20,d1
        ;add.w   #$20,d3
        lsr.w   #8,d3
        and.w   #1,d3           ; vstart high bit
        lsl.w   #1,d3           ; into bit position 2
        and.w   #$ff,d1         ; vstart low bits
        lsl.w   #8,d1           ; Word 1
        or.w    d2,d1
        or.w    d3,d1
        ;or.w    #$80,d1         ; set Attach bit.
        move.w  d1,(a1)+        ; store Y SPRCTL word
; Now do horizontal

        moveq   #0,d0
        moveq   #0,d1
        move.w  d6,d0
        move.w  d6,d1
        and.w   #1,d0
        lsr.w   #1,d1
        move.w  d1,(a0)+        ; Store Hstart High bits
        move.w  d0,(a0)+        ; Store Hstart Low bits

        addq.w  #1,d6
        dbf     d7,.loop
	agdSerialLeave #$2c392149
        rts


	
; *pSpritesheet = agdCreateAttachedSpriteSheet(*ptr pRawSpr, *ptr pRawSpr, Sprite Size, Number, Sprite Y Size)
;            d0                                     d0            d1       d2		 d3	 d4
agdCreateAttachedSpriteSheet:
	agdSerialEntry #$dbb747f4
	movem.l	d1-d7/a0-a5,-(a7)
	
	move.l	d0,a2
	move.l	d1,a3
	
	move.l	#tAttSpriteSheet,d0	
	bsr	agdCreateNewHandle	
	move.l	a0,a1
	move.l	a2,hAttSpriteSheetPlane12(a1)
	move.l	a3,hAttSpriteSheetPlane34(a1)

	move.l	d0,hIndex(a1)
	move.l	#tAttSpriteSheet,hType(a1)
	move.w	d4,hAttSpriteSheetYSize(a1)
	
	move.l	d3,d6			; d5 = 53
	lsl.l	#3,d6
	move.l	d6,hSize(a1)

	move.l	a1,-(a7)
	move.l	d6,d0
	moveq	#MEMF_CHIP,d1
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	move.l	(a7)+,a1
	tst.l	d0
	beq	.error
	ADDSEG_SIZE_D6
	
	move.l	d0,hAddress(a1)
	move.l	d0,a0
	add.l	#16,d2		;	Header	
	
	;move.l	hAddress(a1),a0

	subq.l	#1,d3
	
.loop:
	move.l	a2,(a0)+
	move.l	a3,(a0)+
	add.l	d2,a2
	add.l	d2,a3

	dbf	d3,.loop
	
	move.l	a1,d0
	
.error:
	movem.l	(a7)+,d1-d7/a0-a5
	agdSerialLeave #$dbb747f4
	rts
	

agdCreateAttachedSpriteSheet1:
	agdSerialEntry #$dbb747f4
	movem.l	d1-d7/a0-a5,-(a7)
	
	move.l	d0,a2
	move.l	d1,a3
	
	move.l	#tAttSpriteSheet,d0	
	bsr	agdCreateNewHandle	
	move.l	a0,a1
	move.l	a2,hAttSpriteSheetPlane12(a1)
	move.l	a3,hAttSpriteSheetPlane34(a1)

	move.l	d0,hIndex(a1)
	move.l	#tAttSpriteSheet,hType(a1)
	move.w	d4,hAttSpriteSheetYSize(a1)
	
	move.l	d3,d6			; d5 = 53
	lsl.l	#3,d6
	move.l	d6,hSize(a1)

	move.l	a1,-(a7)
	move.l	d6,d0
	moveq	#MEMF_CHIP,d1
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	move.l	(a7)+,a1
	tst.l	d0
	beq	.error
	
	ADDSEG_SIZE_D6
	
	move.l	d0,hAddress(a1)
	move.l	d0,a0
	add.l	#32,d2		; Header and footer compensate	
	
	;move.l	hAddress(a1),a0

	subq.l	#1,d3
	
.loop:
	move.l	a2,(a0)+
	move.l	a3,(a0)+

	add.l	d2,a2
	add.l	d2,a3

	dbf	d3,.loop
	
	move.l	a1,d0
	
.error:
	movem.l	(a7)+,d1-d7/a0-a5
	agdSerialLeave #$dbb747f4
	rts	


	

; *pSpritesheet = agdCreateSpriteSheet(*ptr pBitmap, *ptr pBitmapMask, uWord SIZE, bool MASK, *ptr VRAM)
;            d0                          d0            d1                 d2         d3 	a0
agdCreateSpriteSheet:
	agdSerialEntry #$832c8c21
	movem.l	d1-d7/a0-a5,-(a7)
	move.l	a0,a1
	move.l	d0,a2			; a0 = bitmap settings
	move.l	d1,a3			; a1 = mask settings
	
	moveq	#0,d0
	moveq	#0,d1
	
	move.w	hBitmapWidth(a2),d0
	lsr.w	#3,d0			; 320/8 = 40

	move.l	d2,d1			
	lsr.w	#8,d1			; X Width
	lsr.w	#3,d1			; to bytes
	and.l	#$ff,d2			; Y Depth 
	
	divu	d1,d0	
	move.l	d0,d6			
; d6 now contains number of columns
	
	move.l	#tSpriteSheet,d0	; Create a new Bitmap handle
	bsr	agdCreateNewHandle	
	
	move.l	#tSpriteSheet,hType(a0)			; Save type of resource	
	move.l	d0,hIndex(a0)				; Save handle for this type	

	move.l	a2,hSpriteSheetBitmap(a0)		; Pointer to associated bitmap struct
	
	move.w	d1,hSpriteSizeWidth(a0)
	move.w	d6,hSpriteSheetCols(a0)
	move.w	d2,hSpriteSizeDepth(a0)
	moveq	#0,d4
	move.w	hBitmapDepth(a2),d4
	divu	d2,d4
; d3 now contains number of rows
	move.w	d4,hSpriteSheetRows(a0)

	mulu	d4,d6
	move.w	d6,hSpriteSheetAmount(a0)
	
	lsl.w	#3,d6
	move.l	d6,hSize(a0)
	
	move.l	d6,d0
	move.l	a0,d7
	
	cmp.l	#0,a1				; Create in Amiga Ram or VRam?
	bne.s	.vram
	
;Allocate Amiga ram
	moveq	#MEMF_CHIP,d1
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq	.error
	
	ADDSEG_SIZE_D6
	
	move.l	d7,a0				; Restore sprite sheet handle.
	move.l	d0,hAddress(a0)
	move.l	d0,a1	
	bra.s	.x
	
; Allocate from VRAM
.vram:	move.l	a1,a0
	moveq	#-1,d1
	bsr	agdCreateScreen
	tst.l	d0
	bmi	.error
	move.l	d7,a0				; Restore sprite sheet handle.
	
	move.l	d0,a1				; d0 points to screen struct
	move.l	(a1),a1				; 
	move.l	a1,hAddress(a0)			; a0= Sprite Sheet struct

; Pointer returned in d0
.x:	
;-----------------------------------------------------
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
	
	move.w	hSpriteSheetAmount(a0),d7
	subq.w	#1,d7
	
; a0 = structure
; a1 = pointers
; a2 = bitmap
; a3 = mask

	move.w	hSpriteSizeWidth(a0),d3
	move.w	hSpriteSizeDepth(a0),d4    ; d4 64
	move.l	d4,d5
	
	move.w	hBitmapScanLength(a2),d6
	

	mulu.w	hBitmapScanLength(a2),d4
	mulu.w	hBitmapScanLength(a3),d5		; Needs to be from mask
	
	;divu	hBitmapPlanes(a2),d6	
	;mulu.w	d6,d5
	
	moveq	#0,d6	
; d4 = Scan line pixels to next row.
	move.w	hSpriteSheetRows(a0),d6
	subq.w	#1,d6

	move.l	hBitmapBody(a2),a2
	move.l	hBitmapMaskBody(a3),a3
	addq.l	#8,a2
	addq.l	#8,a3

; d4 has the row width for the bob
; d5 has the row width for the mask.

; loop here
	move.l	a2,a4				; Body in a2 & a4
	move.l	a3,a5				; Mask in a3 & a5
.loop_row:
	move.l	a4,a2
	move.l	a5,a3
	
	add.l	d0,a2				; Next sprite Row
	add.l	d1,a3 				; Next Mask Row

	moveq	#0,d2				; Number of Coloums to traverse.
	move.w	hSpriteSheetCols(a0),d2	
	subq.w	#1,d2
	
.loop_cols:
	move.l	a2,(a1)+			;a2 is the bob
	move.l	a3,(a1)+			;a3 is the mask.
	add.w	hSpriteSizeWidth(a0),a2		;Next adjacent sprite.
	add.w	hSpriteSizeWidth(a0),a3
	dbf	d2,.loop_cols
; Next row
	add.l	d4,d0
	add.l	d5,d1
	dbf	d6,.loop_row
	
	move.l	a0,d0
	bra.s	.exit
	
.error:	moveq	#-1,d0
.exit:	movem.l	(a7)+,d1-d7/a0-a5
	agdSerialLeave #$832c8c21
	rts
	
	

	
	
; HWSPRITE_UNATTACHED Called by HWSPRITE_ATTACHED in most cicumstances
; Allocate unattached hardware sprite
;a0.l Pointer to spritesheet
;a1.l Sprite Copper Pointer
;d0.w Xpos 30
;d1.w Ypos 50
;d6.w if plus then allocate to given hw sprite address [0-3]
;d7.w Sprite asset number to display
agdShowHardwareSprite:
        lea     HWSPR_TAB_YPOS,a2
        move.l  (a2,d1*4),d2
        lea     HWSPR_TAB_XPOS,a2
        or.l    (a2,d0*4),d2
	
	moveq	#0,d0
	move.w	hAttSpriteSheetYSize(a0),d0
	lsl.w	#8,d0
	add.l	d0,d2
	move.l	hAddress(a0),a0			; Address of sprite control words
	lsl.l	#5,d6
	add.l	d6,a1
	
	rept	2
	move.l	(a0,d7*8),d0
	add.l	#16,d0				; Index to sprite data...
	move.l	d0,a2
	move.w	d0,6(a1)			; Store sprite address in pointers
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addq.w	#8,a1
	swap	d2
	move.w	d2,2(a1)
	swap	d2
	bset	#7,d2				; Disable Attache Bit.
	move.w	d2,6(a1)
	addq.l	#8,a1
	addq.l	#4,a0
	endr
	
.exit:  rts

agdShowHardwareSpriteByOrder:
	lea	CAR_PRI(a6),a2
	moveq	#0,d5
.find:	cmp.b	(a2)+,d6
	beq.s	.found
	addq.w	#1,d5
	bra.s	.find
	
.found:	move.l	d5,d6
	lea     HWSPR_TAB_YPOS(a6),a2
        move.l  (a2,d1*4),d2
        lea     HWSPR_TAB_XPOS(a6),a2
        or.l    (a2,d0*4),d2
	
	moveq	#0,d0
	move.w	hAttSpriteSheetYSize(a0),d0
	lsl.w	#8,d0
	add.l	d0,d2
	move.l	hAddress(a0),a0			; Address of sprite control words
	lsl.l	#5,d6
	add.l	d6,a1
	
	rept	2
	move.l	(a0,d7*8),d0
	add.l	#16,d0				; Index to sprite data...
	move.l	d0,a2
	move.w	d0,6(a1)			; Store sprite address in pointers
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addq.w	#8,a1
	swap	d2
	move.w	d2,2(a1)
	swap	d2
	bset	#7,d2				; Disable Attache Bit.
	move.w	d2,6(a1)
	addq.l	#8,a1
	addq.l	#4,a0
	endr
	
.exit:  rts