
; *pTilesheet = agdCreateTileSheet(*ptr pBitmap, uWord SIZE)
;           d0                        a0            d0
agdCreateTileSheet:
	movem.l	d1-d3/a0-a2,-(a7)
	move.l	a0,a2
	move.l	hBitmapBody(a2),a1			; Pointer to bitmap tile data "BODY"
	move.l	d0,d2					; Save Size
	move.l	d0,d3
	
	move.l	#tTilesheet,d0
	bsr	agdCreateNewHandle
	tst.l	d0
	bmi	.error
	move.l	#tTilesheet,hType(a0)			; Save type of resource
	move.l	d0,hIndex(a0)				; Save handle for this type

; Save sizes for resource	
	move.l	a1,hAddress(a0)			
	move.l	4(a1),hSize(a0)

; Calculate row size
	lsr.w	#8,d3
	add.w	d3,d3
	move.w	d3,hTilesheetTileWidth(a0)
	move.w	hBitmapPlanes(a2),hTilesheetPlanes(a0)	; Get bitplanes

	move.w	hBitmapWidth(a2),d1			; Calculate blitter modulo	
	lsr.w	#3,d1
	sub.w	d3,d1
	
	and.w	#$ff,d2					; Get depth length of tile
	move.w	d1,hTilesheetBlitModulo(a0)		; Save blit modulo
	
	move.w	hBitmapScanLength(a2),d3		; Get scanline lenth
	mulu.w	d2,d3
	move.w	d3,hTilesheetRowModulo(a0)
	
	move.l	a0,d0
	bra.s	.exit
.error:	moveq	#-1,d0
.exit:	movem.l	(a7)+,d1-d3/a0-a2
	rts
	
	
