DEFAULT_SAMPLE_PERIOD:	equ	520


SONG_PREPARE_TO_RACE:	equ	0
SONG_COIN:		equ	4
SONG_WINNING_CARS5:	equ	5
SONG_WINNING_CARS6:	equ	8

SONG_WINNING_CARS7:	equ	0
SONG_WINNING_CARS8:	equ	4

SONG_TRACK_SELECT:	equ	0
SONG_WINNING_CARS1:	equ	2
SONG_WINNING_CARS2:	equ	7
SONG_WINNING_CARS3:	equ	14
SONG_WINNING_CARS4:	equ	26
SONG_UPGRADE_BLUE:	equ	28
SONG_UPGRADE_RED:	equ	29
SONG_UPGRADE_YELLOW:	equ	30

agdInstallAudioPlayer:
	IFEQ	DISABLE_AUDIO
; Initialise Music / SFX routines
	tst.w	AUDIO_INSTALLED(a6)
	bmi	.exit
	move.w	#-1,AUDIO_INSTALLED(a6)
	move.l	a6,-(a7)	
	move.l	vbroffset,a0
	lea	CHIPBASE,a6		
	moveq	#0,d0			 
	bsr	_mt_install_cia
	clr.b	_mt_Enable
	moveq	#0,d0
	bsr	_mt_musicmask
	move.l	(a7)+,a6
.exit:	ENDC
	rts

agdRemoveAudioPlayer:
	IFEQ	DISABLE_AUDIO
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	clr.w	AUDIO_INSTALLED(a6)
	bsr	agdStopModule
	bsr	agdStopChannels
	clr.b	_mt_Enable
	move.l	a6,-(a7)
	lea	CHIPBASE,a6
	bsr	_mt_remove_cia
	move.l	(a7)+,a6
.exit:	ENDC
	rts
	
; In
; a0=Pointer to sample
; Out
; a0=Structure pointer.
agdGetSoundSample:
	cmp.l	#"FORM",(a0)
	beq.s	.header
	moveq	#-1,d0
	bra	.exit
	
.header:
	move.l	4(a0),d1			; Get size

	exg	a0,a1

	move.l	#tSoundSample,d0		; Create a new Memory handle
	bsr	agdCreateNewHandle		
	
	move.l	a0,d2
	move.l	#tSoundSample,hType(a0)		; Save type of resource	
	move.l	a1,hAddress(a0)
	move.l	d0,hIndex(a0)			; Save handle for this type	
	move.l	d1,hSize(a0)

.find:	cmp.l	#"BODY",(a1)
	beq.s	.body
	addq.l	#2,a1
	bra.s	.find
	
.body:
	move.l	4(a1),d1
	lsr.l	#1,d1
	move.w	d1,hSoundSampleLen(a0)
	addq.l	#8,a1
	move.l	a1,hSoundSampleBody(a0)
	
.exit:
	rts



; a0=Module structure
; d0=Position to play
agdPlayModule:
	IFEQ	DISABLE_AUDIO
	move.l	a6,-(a7)	
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	move.l	(a0),a0
	sub.l	a1,a1
	lea	CHIPBASE,a6
	bsr	_mt_init
	move.b	#-1,_mt_Enable		; Play music
.exit:	move.l	(a7)+,a6
	ENDC
	rts
	
agdStopModule:
	IFEQ	DISABLE_AUDIO
	move.l	a6,-(a7)
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	lea	CHIPBASE,a6
	bsr	_mt_end
.exit:	move.l	(a7)+,a6
	ENDC
	rts
	
	
; d0=Volume (0-63)
agdSetVolume:
	IFEQ	DISABLE_AUDIO
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	move.l	a6,-(a7)
	lea	CHIPBASE,a6
	bsr	_mt_mastervol
	move.l	(a7)+,a6	
.exit:	ENDC
	rts
	

;d0=Sample Number
agdPlayIngameSample:
	IFEQ	DISABLE_AUDIO
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	tst.w	RACE_OVER(a6)
	bne.s	.exit
	
	move.l	a0,-(a7)
	move.l	a6,-(a7)
	move.l	d2,-(a7)
	
	lea	SAMPLES_STRUCT(a6),a0
	lea	CHIPBASE,a6
	
	;move.l	#100,d2
	;cmp.w	#sampleNitro,d0
	;beq.s	.skid

	move.l	#DEFAULT_SAMPLE_PERIOD,d2
	cmp.w	#sampleSkid,d0
	bne.s	.skid
	move.l	#470,d2
.skid:
	lsl.l	#4,d0
	add.l	d0,a0
	
	;moveq	#3,d0			; Channel 3
	move.w	d2,6(a0)
	move.b	#3,10(a0)		; Channel
	bsr	_mt_playfx
	move.l	(a7)+,d2
	move.l	(a7)+,a6
	move.l	(a7)+,a0
.exit:	ENDC
	rts


;d0=Sample Number
agdPlaySample:	
	IFEQ	DISABLE_AUDIO
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	
	move.l	a0,-(a7)
	move.l	a6,-(a7)
	lea	SAMPLES_STRUCT(a6),a0
	lea	CHIPBASE,a6
	lsl.l	#4,d0
	add.l	d0,a0
	bsr	_mt_playfx
	move.l	(a7)+,a6
	move.l	(a7)+,a0
.exit:	ENDC
	rts



;d0=Sample Number
agdPlayLoopedSample:
	IFEQ	DISABLE_AUDIO		
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	cmp.w	#sampleEngine,d0
	bne.s	.exit
	tst.w	RACE_OVER(a6)
	bne.s	.exit
	
	move.l	d2,-(a7)
	move.l	d1,-(a7)

	move.l	d0,d2
	
	move.l	a0,-(a7)
	move.l	a6,-(a7)
	move.l	#DEFAULT_SAMPLE_PERIOD,d1
	
	rept	6
	sub.w	carThisSampleThrottle(a4),d1
	endr

; For when jumping	
	tst.w	carIsFalling(a4)
	beq.s	.revs
	
	move.l	#100,d1
.revs:	
	lea	SAMPLES_STRUCT(a6),a0
	lea	CHIPBASE,a6

	lsl.l	#4,d0
	add.l	d0,a0

	move.l	carNumber(a4),d0
	move.b	d0,10(a0)		; Channel
	move.w	d1,6(a0)		; Modify period if Engine sound
	bsr	_mt_loopfx
	
.skip:	move.l	(a7)+,a6
	move.l	(a7)+,a0
	
	move.l	(a7)+,d1
	move.l	(a7)+,d2
.exit:	ENDC	
	rts

agdStopChannels:
	IFEQ	DISABLE_AUDIO	
	tst.w	AUDIO_INSTALLED(a6)
	beq.s	.exit
	movem.l	d0/a6,-(a7)
	
	lea	CHIPBASE,a6
	
	clr.b	_mt_Enable
	moveq	#0,d0
	bsr	_mt_stopfx
	moveq	#1,d0
	bsr	_mt_stopfx
	moveq	#2,d0
	bsr	_mt_stopfx
	moveq	#3,d0
	bsr	_mt_stopfx	

	movem.l	(a7)+,d0/a6
.exit:	ENDC
	rts
	
;  void *sfx_ptr (pointer to sample start in Chip RAM, even address)
;     WORD sfx_len  (sample length in words)
;     WORD sfx_per  (hardware replay period for sample)
;     WORD sfx_vol  (volume 0..64, is unaffected by the song's master volume)
;     BYTE sfx_cha  (0..3 selected replay channel, -1 selects best channel)
;     BYTE sfx_pri  (unsigned priority, must be non-zero)	
	


sampleBump:		equ	0	
sampleCarHit:		equ	1
sampleChime:		equ	2
sampleChopper:		equ	3
sampleCountdown:	equ	4
sampleEngine:		equ	5
sampleExplode:		equ	6
samplePickup:		equ	7
sampleSkid:		equ	8
sampleSpanner:		equ	9
sampleSpin:		equ	10
sampleWater:		equ	11
sampleNitro:		equ	12
sampleRevs:		equ	13

mainLoadSamples: 
		lea	SAMPLES_STRUCT(a6),a1
		
		lea	SAMPLES_TAB(a6),a3
.loop:		move.l	(a3)+,a0
		move.l	(a3),a2
		move.l	a2,d2
		tst.l	a0
		bmi	.exit
		bsr	.load
		move.l	d0,a0
		move.l	(a0),(a2)
		move.l	(a0),a0
		
		move.l	a1,-(a7)
		bsr	agdGetSoundSample
		move.l	a1,(a3)+
		move.l	(a7)+,a1
		
		move.l	(a3)+,d3			; Pri
		move.l	(a3)+,d4			
		move.l	(a3)+,d5
		move.l	hSoundSampleBody(a0),0(a1)
		move.w	hSoundSampleLen(a0),4(a1)
		move.w	d5,6(a1)	; Period
		move.w	d4,8(a1)			; Volume
		move.b	#-1,10(a1)			; Channel
		move.b	d3,11(a1)			; Priority
		add.l	#16,a1
		bra.s	.loop
		

.load:		;lea	FNAME_SPRITES_F1_EXPLOWER_12,a0	
		moveq	#MEMF_CHIP,d1
		IFEQ	LOAD_FROM_BOX
		moveq	#0,d0
		bsr	agdLoadPackedAsset				; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
		ELSE
		move.l	a0,d0
		bsr	agdLoadBoxedAsset
		ENDC


		tst.l	d0
		bmi	.error
		bra	.exit
.error:		moveq	#-1,d0
		bra.s	.error
.exit:		rts

	
	data
		
AUDIO_FADE:	dc.l	0

SAMPLES_STRUCT:
	rept	maxSoundSampleStructs
	dc.l	0	; Pointer	4	0
	dc.w	0	; length	2	4
	dc.w	0	; Period	2	6
	dc.w	63	; volule	2	8
	dc.b	-1	; channel	1	10
	dc.b	0	; priority	1	11
	dc.w	0	; unused	2	12
	dc.l	0	; unused	4	
	endr
	
; Explosion Highest 30
; Bumps 20
; Pickups Highest 10

	
SAMPLES_TAB:		

		IFEQ	LOAD_FROM_BOX
		dc.l	FNAME_SAMPLE_BUMP1,RNCPTR_BUMP1,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_CARHIT,RNCPTR_CARHIT,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_CHIME,RNCPTR_CHIME,10,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_CHOPPER,RNCPTR_CHOPPER,30,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_COUNTDOWN,RNCPTR_COUNTDOWN,100,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_ENGINE,RNCPTR_ENGINE,1,20,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_EXPLODE,RNCPTR_EXPLODE,30,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_PICKUP,RNCPTR_PICKUP,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_SKID,RNCPTR_SKID,5,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_SPANNER,RNCPTR_SPANNER,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_SPIN,RNCPTR_SPIN,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_WATER,RNCPTR_WATER,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_NITRO,RNCPTR_NITRO,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	FNAME_SAMPLE_REVS,RNCPTR_REVS,40,63,750
		ELSE
		dc.l	hAssetsSampleBump1,RNCPTR_BUMP1,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleCarHit,RNCPTR_CARHIT,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleChime,RNCPTR_CHIME,10,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleChopper,RNCPTR_CHOPPER,30,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleCountdown,RNCPTR_COUNTDOWN,100,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleEngine,RNCPTR_ENGINE,1,20,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleExplode,RNCPTR_EXPLODE,30,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSamplePickup,RNCPTR_PICKUP,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleSkid,RNCPTR_SKID,5,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleSpanner,RNCPTR_SPANNER,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleSpin,RNCPTR_SPIN,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleWater,RNCPTR_WATER,20,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleNitro,RNCPTR_NITRO,40,63,DEFAULT_SAMPLE_PERIOD
		dc.l	hAssetsSampleRevs,RNCPTR_REVS,40,63,750		
		ENDC
		dc.l	-1
				

	code